/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.drawing;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.pttheta.loveandwar.blocks.drawing.DrawingBehaviour;
import net.pttheta.loveandwar.recipe.ModRecipes;
import net.pttheta.loveandwar.recipe.drawing.DrawingRecipe;

public class DrawingPressBlockEntity
extends KineticBlockEntity
implements DrawingBehaviour.DrawingBehaviourSpecifics {
    private static final Object drawingRecipesKey = new Object();
    public DrawingBehaviour drawingBehaviour;
    private int tracksCreated;
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public DrawingPressBlockEntity(BlockEntityType<? extends DrawingPressBlockEntity> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.drawingBehaviour = new DrawingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.drawingBehaviour);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PRESS, AllAdvancements.TRACK_CRAFTING});
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public void onItemDrawn(ItemStack result) {
        if (AllTags.AllBlockTags.TRACKS.matches(result)) {
            this.tracksCreated += result.m_41613_();
        }
        if (this.tracksCreated >= 1000) {
            this.award(AllAdvancements.TRACK_CRAFTING);
            this.tracksCreated = 0;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (((AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent()) {
            compound.m_128405_("TracksCreated", this.tracksCreated);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tracksCreated = compound.m_128451_("TracksCreated");
    }

    public DrawingBehaviour getDrawingBehaviour() {
        return this.drawingBehaviour;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.m_32055_();
        Optional<DrawingRecipe> recipe = this.getRecipe(item);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack itemCreated = ItemStack.f_41583_;
        this.drawingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.m_41613_() == 1) {
            RecipeApplier.applyRecipeOn((ItemEntity)itemEntity, (Recipe)((Recipe)recipe.get()));
            itemCreated = itemEntity.m_32055_().m_41777_();
        } else {
            for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (Recipe)((Recipe)recipe.get()))) {
                if (itemCreated.m_41619_()) {
                    itemCreated = result.m_41777_();
                }
                ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                created.m_32060_();
                created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                this.f_58857_.m_7967_((Entity)created);
            }
            item.m_41774_(1);
        }
        if (!itemCreated.m_41619_()) {
            this.onItemDrawn(itemCreated);
        }
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<DrawingRecipe> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.drawingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)(this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1)), (Recipe)((Recipe)recipe.get()));
        for (ItemStack created : outputs) {
            if (created.m_41619_()) continue;
            this.onItemDrawn(created);
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public boolean canProcessInBulk() {
        return (Boolean)AllConfigs.server().recipes.bulkPressing.get();
    }

    @Override
    public void onDrawingCompleted() {
    }

    public static <C extends Container> boolean canCompress(Recipe<C> recipe) {
        if (!(recipe instanceof CraftingRecipe) || !((Boolean)AllConfigs.server().recipes.allowShapedSquareInPress.get()).booleanValue()) {
            return false;
        }
        NonNullList ingredients = recipe.m_7527_();
        return (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.matchAllIngredients((NonNullList)ingredients);
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public void tick() {
        super.tick();
    }

    public Optional<DrawingRecipe> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, ModRecipes.DRAWING_TYPE.get(), DrawingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        pressingInv.m_6836_(0, item);
        return this.find(pressingInv, this.f_58857_);
    }

    public Optional<DrawingRecipe> find(RecipeWrapper inv, Level world) {
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)inv.m_8020_(0), ModRecipes.DRAWING_TYPE.get(), DrawingRecipe.class);
        if (sequenced.isPresent()) {
            return sequenced;
        }
        return world.m_7465_().m_44015_(ModRecipes.DRAWING_TYPE.get(), (Container)inv, world);
    }

    protected Object getRecipeCacheKey() {
        return drawingRecipesKey;
    }
}

