/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.petrochem;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.pttheta.loveandwar.blocks.LAWPartialModels;
import net.pttheta.loveandwar.blocks.petrochem.DistillationColumnBlockEntity;

public class DistillationColumnRenderer
extends SafeBlockEntityRenderer<DistillationColumnBlockEntity> {
    public DistillationColumnRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(DistillationColumnBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        LerpedFloat fluidLevel;
        if (!be.isController()) {
            return;
        }
        if (be.isBottom()) {
            this.renderAsBoiler(be, partialTicks, ms, buffer, light, overlay);
        }
        if ((fluidLevel = be.getFluidLevel()) == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.getHeight() - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        float xMin = tankHullWidth;
        float xMax = xMin + (float)be.getWidth() - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)be.getWidth() - 2.0f * tankHullWidth;
        ms.m_85836_();
        ms.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
        FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
        ms.m_85849_();
    }

    protected void renderAsBoiler(DistillationColumnBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        ms.m_85836_();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        msr.translate((double)((float)be.getWidth() / 2.0f), 0.5, (double)((float)be.getWidth() / 2.0f));
        float dialPivot = 0.359375f;
        float progress = Mth.m_14036_((float)be.progress, (float)0.0f, (float)1.0f);
        for (Direction d : Iterate.horizontalDirections) {
            ms.m_85836_();
            ((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)LAWPartialModels.DISTILLATION_GAUGE, (BlockState)blockState).rotateY((double)d.m_122435_())).unCentre()).translate((double)((float)be.getWidth() / 2.0f - 0.375f), 0.0, 0.0).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (BlockState)blockState).rotateY((double)d.m_122435_())).unCentre()).translate((double)((float)be.getWidth() / 2.0f - 0.375f), 0.0, 0.0).translate(0.0, (double)dialPivot, (double)dialPivot).rotateX((double)(-90.0f * progress))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot)).light(light).renderInto(ms, vb);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public boolean shouldRenderOffScreen(DistillationColumnBlockEntity be) {
        return be.isController();
    }
}

