/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.stamping;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.pttheta.loveandwar.blocks.LAWPartialModels;
import net.pttheta.loveandwar.blocks.stamping.StampingBehaviour;
import net.pttheta.loveandwar.blocks.stamping.StampingPressBlockEntity;
import org.joml.Quaternionf;

public class StampingPressInstance
extends ShaftInstance<StampingPressBlockEntity>
implements DynamicInstance {
    private final OrientedData pressHead;

    public StampingPressInstance(MaterialManager materialManager, StampingPressBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.pressHead = (OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(LAWPartialModels.STAMPING_PRESS_HEAD, this.blockState).createInstance();
        Quaternionf q = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(MechanicalPressBlock.HORIZONTAL_FACING))));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private float getRenderedHeadOffset(StampingPressBlockEntity press) {
        StampingBehaviour drawingBehaviour = press.getStampingBehaviour();
        return drawingBehaviour.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks()) * drawingBehaviour.mode.headOffset;
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset((StampingPressBlockEntity)this.blockEntity);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.pressHead});
    }

    public void remove() {
        super.remove();
        this.pressHead.delete();
    }
}

