/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.entity.ai;

import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.pttheta.loveandwar.entity.ShotProjectile;
import net.pttheta.loveandwar.entity.custom.RobotdogEntity;
import net.pttheta.loveandwar.sound.ModSounds;

public class RobotDogAttackGoal
extends MeleeAttackGoal {
    private final RobotdogEntity entity;
    private int attackDelay = 4;
    private int ticksUntilNextAttack = 12;
    private boolean shouldCountTillNextAttack = false;
    private long lastCanUseCheck;
    private Path path;
    private final double speedModifier;

    public RobotDogAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (RobotdogEntity)pMob;
        this.speedModifier = pSpeedModifier;
    }

    public boolean m_8036_() {
        long i = this.f_25540_.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.f_25540_.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.f_25540_.m_21573_().m_6570_((Entity)livingentity, this.entity.hasTurret() ? 10 : 0);
        if (this.path != null) {
            return true;
        }
        if (this.entity.hasTurret()) {
            this.path = null;
            return true;
        }
        return this.m_6639_(livingentity) >= this.f_25540_.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public void m_8056_() {
        super.m_8056_();
        this.f_25540_.m_21573_().m_26536_(this.path, this.speedModifier);
        this.f_25540_.m_21561_(true);
        this.ticksUntilNextAttack = 0;
        this.attackDelay = 4;
        this.ticksUntilNextAttack = 12;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.entity.hasTurret() && this.entity.hasTurretAmmo()) {
            this.projectileAttack(pEnemy, (float)pDistToEnemySqr);
            return;
        }
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }

    public void projectileAttack(LivingEntity pTarget, float pDistanceFactor) {
        if (this.entity.projectileAttackTick <= 0) {
            this.performRangedAttack(pTarget, pDistanceFactor);
            this.entity.projectileAttackTick = 10;
        }
    }

    public void performRangedAttack(LivingEntity pTarget, float pDistanceFactor) {
        boolean fireball = true;
        if (fireball) {
            Vec3 vec3 = this.entity.m_20252_(1.0f);
            double d4 = pTarget.m_20185_() - this.entity.m_20185_();
            double d5 = pTarget.m_20227_(0.5) - this.entity.m_20227_(0.5);
            double d6 = pTarget.m_20189_() - this.entity.m_20189_();
            double d7 = 2.0;
            ShotProjectile smallfireball = new ShotProjectile(this.entity.m_9236_(), (LivingEntity)this.entity, 0.0, 0.0, 0.0);
            smallfireball.m_6034_(smallfireball.m_20185_(), this.entity.m_20227_(1.0) + 0.25, smallfireball.m_20189_());
            smallfireball.m_6686_((float)d4, (float)d5, (float)d6, 5.0f, 0.0f);
            smallfireball.owner = this.entity.m_269323_();
            this.entity.m_9236_().m_7967_((Entity)smallfireball);
            this.playSound((SoundEvent)ModSounds.GUNSHOT.get(), 1.0f, 1.0f / (this.getRandom().m_188501_() * 0.4f + 0.8f));
        }
        this.entity.ConsumeAmmo();
    }

    public RandomSource getRandom() {
        return this.entity.m_217043_();
    }

    public void playSound(SoundEvent pSound, float pVolume, float pPitch) {
        this.entity.m_9236_().m_6263_((Player)null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), pSound, this.entity.m_5720_(), pVolume, pPitch);
    }

    public ItemStack getProjectile(ItemStack pShootable) {
        if (pShootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this.entity, (Predicate)predicate);
            return ForgeHooks.getProjectile((LivingEntity)this.entity, (ItemStack)pShootable, (ItemStack)(itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack));
        }
        return ForgeHooks.getProjectile((LivingEntity)this.entity, (ItemStack)pShootable, (ItemStack)ItemStack.f_41583_);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this.entity, (ItemStack)pArrowStack, (float)pVelocity);
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.m_6639_(pEnemy);
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)pEnemy);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
    }

    protected double m_6639_(LivingEntity pAttackTarget) {
        if (this.entity.hasTurret()) {
            return 10.0;
        }
        return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 2.0f + pAttackTarget.m_20205_();
    }
}

