/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ScrollableListComponent<T>
extends ExtendedButton {
    private static final ResourceLocation MISC = new ResourceLocation("teamlapenlib", "textures/gui/misc.png");
    protected final List<ListItem<T>> listItems = new ArrayList<ListItem<T>>();
    @NotNull
    private final ItemCreator<T> itemSupplier;
    private final int itemHeight;
    private final int scrollerWidth = 9;
    @NotNull
    private final Supplier<Collection<T>> baseValueSupplier;
    private int scrolled;
    private double scrolledD;
    private boolean scrollerClicked;
    private boolean canScroll = true;
    private double scrollSpeed = 1.0;

    public ScrollableListComponent(int xPos, int yPos, int width, int height, int itemHeight, @NotNull Supplier<Collection<T>> baseValueSupplier, @NotNull ItemCreator<T> itemSupplier) {
        super(xPos, yPos, width, height, (Component)Component.m_237113_((String)""), button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
        this.baseValueSupplier = baseValueSupplier;
        this.refresh();
    }

    public ScrollableListComponent(int xPos, int yPos, int width, int height, int itemHeight, @NotNull Supplier<Collection<T>> baseValueSupplier, @NotNull ItemCreator<T> itemSupplier, Component name) {
        super(xPos, yPos, width, height, name, button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
        this.baseValueSupplier = baseValueSupplier;
        this.refresh();
    }

    public void addItem(@NotNull T element) {
        this.listItems.add(this.itemSupplier.apply(element, this));
        this.setCanScroll();
    }

    public boolean isEmpty() {
        return this.listItems.isEmpty();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_) {
            return false;
        }
        this.scrolledD = this.scrolled;
        if (mouseX > (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY > (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            if (mouseX > (double)(this.m_252754_() + this.f_93618_ - this.scrollerWidth)) {
                this.scrollerClicked = true;
            } else {
                for (int i = 0; i < this.listItems.size(); ++i) {
                    int y = i * this.itemHeight - this.scrolled;
                    if (y < -this.itemHeight) continue;
                    ListItem<T> item = this.listItems.get(i);
                    if (!(mouseX > (double)(this.m_252754_() + 1)) || !(mouseX < (double)(this.m_252754_() + this.f_93618_ - this.scrollerWidth)) || !(mouseY > (double)(this.m_252907_() + 1 + y)) || !(mouseY < (double)(this.m_252907_() + 1 + y + this.itemHeight)) || !item.onClick(mouseX, mouseY)) continue;
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.f_93624_ && this.canScroll && this.scrollerClicked) {
            double perc = dragY / (double)(this.f_93619_ - 27);
            double s = (double)(this.listItems.size() * this.itemHeight - this.f_93619_) * perc;
            this.scrolledD += s;
            this.scrolled = (int)this.scrolledD;
            this.scrolled = Mth.m_14045_((int)this.scrolled, (int)0, (int)(this.listItems.size() * this.itemHeight - this.f_93619_ + 2));
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollerClicked = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        if (this.canScroll) {
            this.scrolled = Mth.m_14045_((int)(this.scrolled + 4 * (int)(-(delta * this.scrollSpeed))), (int)0, (int)(this.listItems.size() * this.itemHeight - this.f_93619_ + 2));
            this.scrolledD = this.scrolled;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.setItems(this.baseValueSupplier.get());
    }

    public void removeItem(T element) {
        this.listItems.removeIf(item -> item.item == element);
        this.setCanScroll();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        RenderSystem.enableDepthTest();
        pose.m_252880_(0.0f, 0.0f, 950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        graphics.m_280509_(4680, 2260, -4680, -2260, -16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        pose.m_252880_(0.0f, 0.0f, -950.0f);
        RenderSystem.depthFunc((int)518);
        pose.m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        graphics.m_280509_(this.f_93618_, this.f_93619_, 0, 0, -16711680);
        pose.m_252880_((float)(-this.m_252754_()), (float)(-this.m_252907_()), 0.0f);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderItems(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)518);
        pose.m_252880_(0.0f, 0.0f, -950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        graphics.m_280509_(4680, 2260, -4680, -2260, -16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        pose.m_252880_(0.0f, 0.0f, 950.0f);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        pose.m_85849_();
    }

    public ScrollableListComponent<T> scrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
        return this;
    }

    public void setItems(@NotNull Collection<T> elements) {
        this.listItems.clear();
        elements.forEach(item -> this.listItems.add(this.itemSupplier.apply(item, this)));
        this.setScrolled(0);
        this.setCanScroll();
    }

    protected void addItem(@NotNull ListItem<T> newElement, @NotNull ListItem<T> afterElement) {
        this.listItems.add(this.listItems.indexOf(afterElement) + 1, newElement);
        this.setCanScroll();
    }

    protected void removeItem(ListItem<T> item) {
        this.listItems.remove(item);
        this.setCanScroll();
    }

    private void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitWithBorder(new ResourceLocation("textures/gui/widgets.png"), this.m_252754_(), this.m_252907_(), 0, 46, this.f_93618_ - this.scrollerWidth + 1, this.f_93619_, 200, 20, 3, 3, 3, 3);
    }

    private void renderItems(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int itemHeight = this.itemHeight;
        for (int i = 0; i < this.listItems.size(); ++i) {
            int y = i * itemHeight - this.scrolled;
            ListItem<T> item = this.listItems.get(i);
            item.render(graphics, this.m_252754_() + 1, this.m_252907_() + 1 + y, this.f_93618_ - 9 - 1, this.f_93619_, this.itemHeight, mouseX, mouseY, partialTicks, 0.0f);
        }
        this.renderScrollBar(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280656_(this.m_252754_(), this.m_252754_() + this.f_93618_ - 1, this.m_252907_(), -16777216);
        graphics.m_280656_(this.m_252754_(), this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93619_ - 1, -16777216);
    }

    private void renderScrollBar(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitWithBorder(MISC, this.m_252754_() + this.f_93618_ - this.scrollerWidth, this.m_252907_(), 0, 0, 9, this.f_93619_, 9, 200, 2);
        this.renderScroller(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderScroller(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int scrollerHeight = 27;
        int scrollHeight = this.f_93619_ - 2 - scrollerHeight;
        float perc = (float)this.scrolled / (float)(this.listItems.size() * this.itemHeight - this.f_93619_ + 2);
        int yOffset = (int)((float)scrollHeight * perc);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int yMaxSize = Mth.m_14045_((int)(this.itemHeight * this.listItems.size() - 2), (int)0, (int)27);
        graphics.m_280218_(MISC, this.m_252754_() + this.f_93618_ - this.scrollerWidth + 1, this.m_252907_() + yOffset + 1, this.canScroll ? 9 : 16, 0, 7, yMaxSize);
    }

    private void setCanScroll() {
        this.canScroll = this.listItems.size() * this.itemHeight > this.f_93619_;
    }

    private void setScrolled(int scrolled) {
        this.scrolled = scrolled;
        this.scrolledD = this.scrolled;
    }

    @FunctionalInterface
    public static interface ItemCreator<T> {
        public ListItem<T> apply(@NotNull T var1, @NotNull ScrollableListComponent<T> var2);
    }

    public static abstract class ListItem<T> {
        private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        @NotNull
        protected final T item;
        @NotNull
        protected final ScrollableListComponent<T> list;

        public ListItem(@NotNull T item, @NotNull ScrollableListComponent<T> list) {
            this.item = item;
            this.list = list;
        }

        public boolean onClick(double mouseX, double mouseY) {
            return false;
        }

        public void preRenderToolTip(GuiGraphics graphics, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
            int ySize = Mth.m_14045_((int)listHeight, (int)0, (int)itemHeight);
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + ySize) {
                this.renderToolTip(graphics, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            }
        }

        public void render(@NotNull GuiGraphics graphics, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            int v = 66;
            if (mouseX >= x && mouseX < x + listWidth && mouseY >= y && mouseY < y + itemHeight) {
                v = 86;
            }
            RenderSystem.enableDepthTest();
            graphics.blitWithBorder(WIDGETS, x, y, 0, v, listWidth + 1, itemHeight, 200, 20, 3, 3, 3, 3);
            RenderSystem.disableDepthTest();
        }

        public void renderToolTip(GuiGraphics graphics, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        }
    }
}

