/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.radial.edit;

import de.teamlapen.lib.lib.client.gui.components.SimpleList;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.DrawCallback;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.GuiRadialMenu;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.IRadialMenuSlot;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenu;
import de.teamlapen.vampirism.api.util.ItemOrdering;
import de.teamlapen.vampirism.client.gui.screens.radial.edit.ItemWrapper;
import de.teamlapen.vampirism.client.gui.screens.radial.edit.NoItemRadialMenuSlot;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class ReorderingGuiRadialMenu<T>
extends GuiRadialMenu<ItemWrapper<T>> {
    protected ItemWrapper<T> movingItem;
    private final ItemOrdering<T> ordering;
    private final Function<T, MutableComponent> nameFunction;
    private final DrawCallback<T> drawCallback;
    private final Consumer<ItemOrdering<T>> saveAction;
    private final Function<T, Boolean> isEnabled;
    private ExcludedItemList excludedList;
    private Boolean wasGuiHidden;

    public ReorderingGuiRadialMenu(ItemOrdering<T> ordering, Function<T, MutableComponent> nameFunction, DrawCallback<T> drawCallback, @NotNull Consumer<ItemOrdering<T>> saveAction, Function<T, Boolean> isEnabled) {
        super(ReorderingGuiRadialMenu.createMenu(ordering, nameFunction, drawCallback, isEnabled));
        this.ordering = ordering;
        this.nameFunction = nameFunction;
        this.drawCallback = drawCallback;
        this.saveAction = saveAction;
        this.isEnabled = isEnabled;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ResetButton(0, this.f_96544_ - 40, 140, 20, context -> this.reset()));
        this.m_142416_((GuiEventListener)new ExtendedButton(0, this.f_96544_ - 20, 140, 20, (Component)Component.m_237115_((String)"gui.done"), context -> this.m_7379_()));
        this.excludedList = (ExcludedItemList)this.m_142416_((GuiEventListener)new ExcludedItemList(0, 20, 140, this.f_96544_ - 70));
        if (this.wasGuiHidden == null) {
            this.wasGuiHidden = Minecraft.m_91087_().f_91066_.f_92062_;
        }
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        this.updateExcludedList();
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        graphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        int i = 32;
        graphics.m_280398_(f_279548_, 0, 0, 0, 0.0f, 0.0f, 140, this.f_96544_, i, i);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveOrdering();
        if (this.wasGuiHidden != null) {
            Minecraft.m_91087_().f_91066_.f_92062_ = this.wasGuiHidden;
        }
    }

    private void updateExcludedList() {
        this.excludedList.updateContent(this.ordering.getExcluded(), this.nameFunction);
    }

    public void reset() {
        this.ordering.reset();
        this.updateExcludedList();
        this.radialMenuSlots.clear();
        this.checkEmpty();
        this.movingItem = null;
    }

    private void addDummyMenuItems() {
        if (this.radialMenuSlots.size() != 1 || ((ItemWrapper)((IRadialMenuSlot)this.radialMenuSlots.get(0)).primarySlotIcon()).get() != null) {
            for (int i = this.radialMenuSlots.size() - 1; i >= 0; --i) {
                this.radialMenuSlots.add(i, new NoItemRadialMenuSlot<T>(this.nameFunction, new ItemWrapper(), this.isEnabled));
            }
        }
    }

    public void excludeItem() {
        this.excludeItem(this.movingItem);
        this.movingItem.clear();
        this.movingItem = null;
        this.removeDummyItems();
        this.checkEmpty();
    }

    private void excludeItem(ItemWrapper<T> item) {
        if (item != null) {
            this.ordering.exclude(item.get());
        }
        this.updateExcludedList();
    }

    private void pickExcludedItem(T item) {
        this.movingItem = new ItemWrapper<T>(item);
        this.addDummyMenuItems();
    }

    protected void removeDummyItems() {
        this.radialMenuSlots.removeIf(slot -> ((ItemWrapper)slot.primarySlotIcon()).getOptional().isEmpty());
        this.checkEmpty();
    }

    private void saveOrdering() {
        this.syncOrdering();
        this.saveAction.accept(this.ordering);
    }

    private void syncOrdering() {
        this.ordering.applyOrdering(this.radialMenuSlots.stream().map(IRadialMenuSlot::primarySlotIcon).flatMap(a -> a.getOptional().stream()).collect(Collectors.toList()));
        this.updateExcludedList();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (GuiEventListener guieventlistener1 : this.m_6702_()) {
            if (!guieventlistener1.m_6375_(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        this.pickItem();
        return true;
    }

    private void pickItem() {
        if (this.selectedItem != -1) {
            IRadialMenuSlot selected = (IRadialMenuSlot)this.radialMenuSlots.get(this.selectedItem);
            if (this.movingItem != null) {
                ((ItemWrapper)selected.primarySlotIcon()).swapItem(this.movingItem);
                if (this.movingItem.get() == null) {
                    this.removeDummyItems();
                    this.movingItem = null;
                }
                if (this.radialMenuSlots.stream().noneMatch(s -> s.primarySlotIcon() == this.movingItem)) {
                    this.excludeItem(this.movingItem);
                }
                this.syncOrdering();
            } else {
                if (((ItemWrapper)selected.primarySlotIcon()).get() == null) {
                    return;
                }
                this.movingItem = (ItemWrapper)selected.primarySlotIcon();
                this.addDummyMenuItems();
            }
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.excludedList.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private void checkEmpty() {
        if (this.radialMenuSlots.isEmpty()) {
            this.radialMenuSlots.add(new NoItemRadialMenuSlot<T>(this.nameFunction, new ItemWrapper(), this.isEnabled));
        }
    }

    @Override
    public void drawSlice(IRadialMenuSlot<ItemWrapper<T>> slot, boolean highlighted, GuiGraphics buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        if (this.movingItem == null && !slot.primarySlotIcon().getOptional().map(this.isEnabled).orElse(true).booleanValue()) {
            r = 80;
        }
        super.drawSlice(slot, highlighted, buffer, x, y, z, radiusIn, radiusOut, startAngle, endAngle, r, g, b, Math.min(255, (int)((float)a * 2.0f)));
    }

    @Override
    public void drawSliceName(GuiGraphics graphics, String sliceName, ItemStack stack, int posX, int posY) {
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"text.vampirism.excluded"), 70, 5, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.movingItem != null) {
            this.drawCallback.accept(this.movingItem.get(), graphics, mouseX - 8, mouseY - 8, 16, false);
        }
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.m_7379_();
        }
        return true;
    }

    @Override
    protected void processInputEvent(MovementInputUpdateEvent event) {
    }

    private static <T> RadialMenu<ItemWrapper<T>> createMenu(ItemOrdering<T> ordering, Function<T, MutableComponent> nameFunction, DrawCallback<T> drawCallback, Function<T, Boolean> isEnabled) {
        List collect = ordering.getOrdering().stream().map(a -> new NoItemRadialMenuSlot<Object>(nameFunction, new ItemWrapper<Object>(a), isEnabled)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            collect.add(new NoItemRadialMenuSlot<T>(nameFunction, new ItemWrapper(), isEnabled));
        }
        return new RadialMenu<ItemWrapper<T>>(i -> {}, collect, (objectToBeDrawn, poseStack, positionX, positionY, size, renderTransparent) -> objectToBeDrawn.run(item -> drawCallback.accept(item, poseStack, positionX, positionY, size, renderTransparent)), 0);
    }

    public static class ResetButton
    extends ExtendedButton {
        private static final Component DESCRIPTION = Component.m_237115_((String)"text.vampirism.gui.reset");
        private static final Component DESCRIPTION_CONFIRM = Component.m_237115_((String)"text.vampirism.gui.reset_question").m_130940_(ChatFormatting.DARK_RED);
        private boolean isClicked = false;

        public ResetButton(int xPos, int yPos, int width, int height, Button.OnPress handler) {
            super(xPos, yPos, width, height, DESCRIPTION, handler);
        }

        public void m_5691_() {
            if (this.isClicked) {
                super.m_5691_();
                this.isClicked = false;
            } else {
                this.isClicked = true;
            }
        }

        protected boolean m_93680_(double pMouseX, double pMouseY) {
            boolean result = super.m_93680_(pMouseX, pMouseY);
            if (!result) {
                this.isClicked = false;
            }
            return result;
        }

        @NotNull
        public Component m_6035_() {
            return this.isClicked ? DESCRIPTION_CONFIRM : DESCRIPTION;
        }

        public int getFGColor() {
            return this.isClicked ? ChatFormatting.DARK_RED.m_126665_().intValue() : super.getFGColor();
        }
    }

    public class ExcludedItemList
    extends SimpleList<ExcludedEntry<T>> {
        public ExcludedItemList(int x, int y, int pWidth, int pHeight) {
            super(Minecraft.m_91087_(), pWidth, pHeight, y, y + pHeight, 20);
            this.m_93507_(x);
        }

        public void updateContent(List<T> newItems, Function<T, MutableComponent> nameFunction) {
            this.m_5988_(newItems.stream().map(s -> new ExcludedEntry<Object>(s, (Component)nameFunction.apply(s), () -> this.selectItem(s))).toList());
        }

        private void selectItem(T selected) {
            if (ReorderingGuiRadialMenu.this.movingItem == null) {
                ReorderingGuiRadialMenu.this.pickExcludedItem(selected);
            }
        }

        @Override
        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            if (this.m_5953_(pMouseX, pMouseY) && ReorderingGuiRadialMenu.this.movingItem != null) {
                ReorderingGuiRadialMenu.this.excludeItem();
                return true;
            }
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
            if (this.isVisible && ReorderingGuiRadialMenu.this.movingItem != null) {
                int i = this.getLeft();
                int j = this.getTop();
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)i, (float)j, 200.0f);
                graphics.m_280024_(0, 0, this.getWidth(), this.getHeight(), -1072689136, -804253680);
                graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"text.vampirism.place_exclude"), this.f_93388_ / 2, this.f_93389_ / 2, 0xFFFFFF);
                graphics.m_280168_().m_85849_();
            }
        }
    }

    public static class ExcludedEntry<T>
    extends SimpleList.Entry<ExcludedEntry<T>> {
        private final T item;

        public ExcludedEntry(@NotNull T item, Component name, Runnable onClick) {
            super(name, onClick);
            this.item = item;
        }

        public T getItem() {
            return this.item;
        }
    }
}

