/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class VillagerWithArmsModel<T extends Mob>
extends VillagerModel<T>
implements ArmedModel {
    private static final String RIGHT_ARM = "right_arm";
    private static final String LEFT_ARM = "left_arm";
    @NotNull
    private final ModelPart leftArm;
    @NotNull
    private final ModelPart rightArm;

    @NotNull
    public static LayerDefinition createLayer(float scale) {
        MeshDefinition mesh = VillagerModel.m_171052_();
        PartDefinition root = mesh.m_171576_();
        CubeDeformation def = new CubeDeformation(scale);
        root.m_171599_(RIGHT_ARM, CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, def).m_171488_(-4.0f, 6.0f, -2.0f, 4.0f, 3.0f, 4.0f, def), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        root.m_171599_(LEFT_ARM, CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, def).m_171488_(0.0f, 6.0f, -2.0f, 4.0f, 3.0f, 4.0f, def), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public VillagerWithArmsModel(@NotNull ModelPart part) {
        super(part);
        this.leftArm = part.m_171324_(LEFT_ARM);
        this.rightArm = part.m_171324_(RIGHT_ARM);
    }

    public void setupAnim(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.m_104227_(4.0f, 3.0f, -1.0f);
        this.rightArm.m_104227_(-4.0f, 3.0f, -1.0f);
        this.leftArm.f_104203_ = -0.75f;
        this.rightArm.f_104203_ = -0.75f;
        if (this.f_102608_ > 0.0f) {
            HumanoidArm enumhandside = this.getMainHand((Entity)entityIn);
            ModelPart modelrenderer = this.getArmForSide(enumhandside);
            float f1 = 1.0f - this.f_102608_;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
            float f3 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.m_5585_().f_104203_ - 0.7f) * 0.75f;
            modelrenderer.f_104203_ = (float)((double)modelrenderer.f_104203_ - ((double)f2 * 1.2 + (double)f3));
        }
    }

    public void m_6002_(@NotNull HumanoidArm handSide, @NotNull PoseStack matrixStack) {
        float f = handSide == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart arm = this.getArmForSide(handSide);
        arm.f_104200_ += f;
        arm.m_104299_(matrixStack);
        arm.f_104200_ -= f;
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @NotNull
    protected HumanoidArm getMainHand(Entity entityIn) {
        return entityIn instanceof LivingEntity ? ((LivingEntity)entityIn).m_5737_() : HumanoidArm.RIGHT;
    }
}

