/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAi;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModCommands;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRefinementSets;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModStructures;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.lord.actions.LordActions;
import de.teamlapen.vampirism.entity.player.lord.skills.LordSkills;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class RegistryManager
implements IInitListener {
    public RegistryManager() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    public static void setupRegistries(@NotNull IEventBus modbus) {
        ModRegistries.init(modbus);
        ModAttributes.register(modbus);
        ModBiomes.register(modbus);
        ModBlocks.register(modbus);
        ModContainer.register(modbus);
        ModEffects.register(modbus);
        ModEnchantments.register(modbus);
        ModEntities.register(modbus);
        ModFeatures.register(modbus);
        ModStructures.register(modbus);
        ModFluids.register(modbus);
        ModItems.register(modbus);
        ModLoot.register(modbus);
        ModParticles.register(modbus);
        ModPotions.register(modbus);
        ModRecipes.register(modbus);
        ModRefinements.register(modbus);
        ModRefinementSets.register(modbus);
        ModSounds.register(modbus);
        ModTasks.register(modbus);
        ModTiles.register(modbus);
        ModAi.register(modbus);
        ModVillage.register(modbus);
        VampireActions.register(modbus);
        HunterActions.register(modbus);
        EntityActions.register(modbus);
        MinionTasks.register(modbus);
        LordActions.register(modbus);
        LordSkills.register(modbus);
        VampireSkills.register(modbus);
        HunterSkills.register(modbus);
        ModCommands.register(modbus);
        ModOils.register(modbus);
    }

    @SubscribeEvent
    public void onBuildRegistries(NewRegistryEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::onModifyEntityTypeAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::onRegisterEntityTypeAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::onRegisterSpawns);
    }

    @Override
    public void onInitStep(@NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        switch (step) {
            case COMMON_SETUP: {
                ModEntities.registerCustomExtendedCreatures();
                ModItems.registerCraftingRecipes();
                ModAdvancements.registerAdvancementTrigger();
                event.enqueueWork(() -> {
                    ModPotions.registerPotionMixes();
                    ModStats.registerCustomStats();
                    ModVillage.villagerTradeSetup();
                });
                ModTiles.registerTileExtensionsUnsafe();
                event.enqueueWork(ModItems::registerDispenserBehaviourUnsafe);
            }
            case LOAD_COMPLETE: {
                if (ModEffects.checkNightVision()) {
                    event.enqueueWork(ModEffects::fixNightVisionEffectTypesUnsafe);
                }
                ModRecipes.registerDefaultLiquidColors();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onNewDatapackRegistries(@NotNull DataPackRegistryEvent.NewRegistry event) {
        ModRegistries.registerDatapackRegistries(event);
    }

    @SubscribeEvent
    public void onRegisterEffects(@NotNull RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.MOB_EFFECTS)) {
            ModEffects.replaceEffects((IForgeRegistry<MobEffect>)event.getForgeRegistry());
        }
    }
}

