/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.items.OilBottleItem;
import de.teamlapen.vampirism.util.NBTIngredient;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableRecipeBuilder {
    @NotNull
    private final ItemStack result;
    @NotNull
    private final IOil resultOil;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;
    private Ingredient ingredient;
    @NotNull
    private final IOil ingredientOil = (IOil)ModOils.EMPTY.get();
    private Ingredient input;
    private ISkill[] skills;

    @NotNull
    public static AlchemyTableRecipeBuilder builder(@NotNull ItemStack stack) {
        return new AlchemyTableRecipeBuilder(stack);
    }

    @NotNull
    public static AlchemyTableRecipeBuilder builder(@NotNull IOil oilStack) {
        return new AlchemyTableRecipeBuilder(OilUtils.createOilItem(oilStack));
    }

    @NotNull
    public static AlchemyTableRecipeBuilder builder(@NotNull Supplier<? extends IOil> oilStack) {
        return AlchemyTableRecipeBuilder.builder(oilStack.get());
    }

    public AlchemyTableRecipeBuilder(@NotNull ItemStack result) {
        this(result, OilUtils.getOil(result));
    }

    public AlchemyTableRecipeBuilder(@NotNull ItemStack result, @NotNull IOil resultOil) {
        Objects.requireNonNull(result);
        Objects.requireNonNull(resultOil);
        this.result = result;
        this.resultOil = resultOil;
    }

    @NotNull
    public AlchemyTableRecipeBuilder group(@NotNull String group) {
        this.group = group;
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder ingredient(@NotNull Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder oilIngredient(@NotNull IOil oil) {
        this.ingredient = new NBTIngredient(((OilBottleItem)ModItems.OIL_BOTTLE.get()).withOil(oil));
        return this;
    }

    public AlchemyTableRecipeBuilder plantOilIngredient() {
        return this.ingredient(new NBTIngredient(((OilBottleItem)ModItems.OIL_BOTTLE.get()).withOil((IOil)ModOils.PLANT.get()))).withCriterion("has_bottles", (CriterionTriggerInstance)AlchemyTableRecipeBuilder.has((ItemLike)ModItems.OIL_BOTTLE.get()));
    }

    public AlchemyTableRecipeBuilder bloodOilIngredient() {
        return this.ingredient(new NBTIngredient(((OilBottleItem)ModItems.OIL_BOTTLE.get()).withOil((IOil)ModOils.VAMPIRE_BLOOD.get()))).withCriterion("has_bottles", (CriterionTriggerInstance)AlchemyTableRecipeBuilder.has((ItemLike)ModItems.OIL_BOTTLE.get()));
    }

    @NotNull
    public AlchemyTableRecipeBuilder input(@NotNull Ingredient input) {
        this.input = input;
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder withCriterion(@NotNull String name, @NotNull CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder withSkills(ISkill ... skills) {
        this.skills = skills;
        return this;
    }

    public void build(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "alchemy_table/" + id.m_135815_());
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.group != null ? this.group : "", this.ingredient, this.ingredientOil, this.input, this.result, this.resultOil, this.skills != null ? this.skills : new ISkill[]{}, id.m_247449_("recipes/alchemy_table/" + id.m_135815_()), this.advancementBuilder));
    }

    private void validate(@NotNull ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredients defined for alchemical table recipe " + id + "!");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input defined for alchemical table recipe " + id + "!");
        }
    }

    protected static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull InventoryChangeTrigger.TriggerInstance has(@NotNull ItemLike p_200403_0_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_200403_0_}).m_45077_());
    }

    protected static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull InventoryChangeTrigger.TriggerInstance has(@NotNull TagKey<Item> p_200409_0_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(p_200409_0_).m_45077_());
    }

    protected static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... p_200405_0_) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, p_200405_0_);
    }

    private record Result(@NotNull ResourceLocation id, @NotNull String group, @NotNull Ingredient ingredient, @NotNull IOil ingredientOil, @NotNull Ingredient input, @NotNull ItemStack result, @NotNull IOil resultOil, @NotNull ISkill[] skills, @NotNull ResourceLocation advancementId, @NotNull Advancement.Builder advancementBuilder) implements FinishedRecipe
    {
        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.ALCHEMICAL_TABLE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        public void m_7917_(@NotNull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("result", (JsonElement)this.item(this.result));
            json.add("ingredient", this.ingredient.m_43942_());
            json.add("input", this.input.m_43942_());
            JsonArray skills = new JsonArray();
            for (ISkill skill : this.skills) {
                skills.add(RegUtil.id(skill).toString());
            }
            json.add("skill", (JsonElement)skills);
        }

        @NotNull
        private JsonObject item(@NotNull ItemStack stack) {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", RegUtil.id(stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                obj.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                obj.add("nbt", (JsonElement)new JsonParser().parse(stack.m_41783_().toString()).getAsJsonObject());
            }
            return obj;
        }
    }
}

