/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.blockentity.MotherBlockEntity;
import de.teamlapen.vampirism.blockentity.VulnerableRemainsBlockEntity;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.IRemainsEntity;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemainsDefenderEntity
extends Mob
implements IRemainsEntity {
    protected static final EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID = SynchedEntityData.m_135353_(RemainsDefenderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Integer> DATA_LIGHT_TICKS_REMAINING = SynchedEntityData.m_135353_(RemainsDefenderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22285_, 6.0);
    }

    public RemainsDefenderEntity(EntityType<RemainsDefenderEntity> type, Level pLevel) {
        super(type, pLevel);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.5f, false));
        this.f_21345_.m_25352_(2, (Goal)new RemainsDefenderAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new RemainsDefenderAttackTargetGoal(this));
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 512L == 32L && this.m_20202_() == null && !this.m_9236_().m_8055_(this.m_20183_().m_121945_(this.getAttachFace())).m_204336_(ModTags.Blocks.ACTIVE_REMAINS)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        int i = this.getLightTicksRemaining();
        if (i > 0) {
            this.setLightTicksRemaining(i - 1);
        }
    }

    public boolean m_6673_(@NotNull DamageSource pSource) {
        return pSource.m_269533_(ModTags.DamageTypes.MOTHER_RESISTANT_TO) || pSource.m_276093_(DamageTypes.f_268612_) || pSource.m_276093_(DamageTypes.f_268722_) || super.m_6673_(pSource);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REMAINS_DEFENDER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REMAINS_DEFENDER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.REMAINS_DEFENDER_HURT.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ATTACH_FACE_ID, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(DATA_LIGHT_TICKS_REMAINING, (Object)0);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAttachFace(Direction.m_122376_((int)pCompound.m_128445_("AttachFace")));
        this.setLightTicksRemaining(pCompound.m_128451_("LightTicks"));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128344_("AttachFace", (byte)this.getAttachFace().m_122411_());
        pCompound.m_128405_("LightTicks", this.getLightTicksRemaining());
    }

    protected boolean m_7341_(@NotNull Entity pVehicle) {
        return pVehicle instanceof VulnerableRemainsDummyEntity;
    }

    public void m_6083_() {
        this.m_8119_();
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (super.m_6469_(pSource, pAmount)) {
            this.getDummy().ifPresent(vehicle -> vehicle.childrenIsHurt(pSource, this.f_20890_, this.getAttachFace()));
            return true;
        }
        return false;
    }

    protected void m_6475_(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        super.m_6475_(pDamageSource, pDamageAmount);
        this.f_19802_ *= 2;
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public void m_20256_(@NotNull Vec3 pDeltaMovement) {
    }

    public void setAttachFace(Direction face) {
        this.f_19804_.m_135381_(DATA_ATTACH_FACE_ID, (Object)face);
    }

    public Direction getAttachFace() {
        return (Direction)this.f_19804_.m_135370_(DATA_ATTACH_FACE_ID);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        if (DATA_ATTACH_FACE_ID.equals(pKey)) {
            this.m_20011_(this.m_142242_());
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return switch (this.getAttachFace()) {
            case Direction.UP -> 0.8f;
            case Direction.DOWN -> 0.2f;
            default -> 0.5f;
        };
    }

    public void m_7334_(@NotNull Entity pEntity) {
    }

    public boolean m_7998_(Entity pEntity, boolean pForce) {
        if (super.m_7998_(pEntity, pForce)) {
            this.m_20090_();
            return true;
        }
        return false;
    }

    @NotNull
    protected AABB m_142242_() {
        Direction attachFace = this.getAttachFace().m_122424_();
        AABB box = new AABB(BlockPos.f_121853_);
        return (switch (attachFace.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> box.m_82310_(0.0, 0.25, 0.25).m_82310_(0.0, -0.25, -0.25);
            case Direction.Axis.Y -> box.m_82310_(0.25, 0.0, 0.25).m_82310_(-0.25, 0.0, -0.25);
            case Direction.Axis.Z -> box.m_82310_(0.25, 0.25, 0.0).m_82310_(-0.25, -0.25, 0.0);
        }).m_82310_((double)attachFace.m_122429_() * 0.75, (double)attachFace.m_122430_() * 0.75, (double)attachFace.m_122431_() * 0.75).m_82338_(this.m_20183_());
    }

    public Optional<VulnerableRemainsDummyEntity> getDummy() {
        return Optional.ofNullable(this.m_20202_()).filter(VulnerableRemainsDummyEntity.class::isInstance).map(VulnerableRemainsDummyEntity.class::cast);
    }

    private void setLightTicksRemaining(int ticks) {
        this.f_19804_.m_135381_(DATA_LIGHT_TICKS_REMAINING, (Object)ticks);
    }

    public int getLightTicksRemaining() {
        return (Integer)this.f_19804_.m_135370_(DATA_LIGHT_TICKS_REMAINING);
    }

    protected void m_20090_() {
        if (this.m_20202_() != null) {
            Direction attachFace = this.getAttachFace();
            this.m_146884_(Vec3.m_82539_((Vec3i)this.m_20202_().m_20183_().m_7494_()).m_82492_((double)attachFace.m_122429_(), (double)attachFace.m_122430_(), (double)attachFace.m_122431_()));
        } else {
            super.m_20090_();
        }
    }

    class RemainsDefenderAttackGoal
    extends Goal {
        private int attackTime;

        public RemainsDefenderAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = RemainsDefenderEntity.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                return RemainsDefenderEntity.this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void m_8056_() {
            this.attackTime = 40;
        }

        public void m_8041_() {
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (RemainsDefenderEntity.this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                --this.attackTime;
                LivingEntity livingentity = RemainsDefenderEntity.this.m_5448_();
                if (livingentity != null) {
                    RemainsDefenderEntity.this.m_21563_().m_24960_((Entity)livingentity, 180.0f, 180.0f);
                    double d0 = RemainsDefenderEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 400.0) {
                        if (this.attackTime <= 0) {
                            this.attackTime = 20 + RemainsDefenderEntity.this.f_19796_.m_188503_(10) * 20 / 2;
                            Vec3 position = RemainsDefenderEntity.this.m_20182_();
                            Vec3 direction = RemainsDefenderEntity.this.m_20252_(1.0f);
                            DarkBloodProjectileEntity projectile = new DarkBloodProjectileEntity(RemainsDefenderEntity.this.m_9236_(), position.m_7096_(), position.m_7098_(), position.m_7094_(), direction.m_7096_(), direction.m_7098_(), direction.m_7094_());
                            projectile.m_5602_((Entity)RemainsDefenderEntity.this);
                            projectile.setDamage((float)RemainsDefenderEntity.this.m_21133_(Attributes.f_22281_), 0.0f);
                            projectile.excludeShooter();
                            RemainsDefenderEntity.this.m_9236_().m_7967_((Entity)projectile);
                            RemainsDefenderEntity.this.setLightTicksRemaining(40);
                        }
                    } else {
                        RemainsDefenderEntity.this.m_6710_(null);
                    }
                    super.m_8037_();
                }
            }
        }
    }

    static class RemainsDefenderAttackTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public RemainsDefenderAttackTargetGoal(RemainsDefenderEntity entity) {
            super((Mob)entity, LivingEntity.class, 10, true, false, target -> {
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    if (entity.getDummy().flatMap(VulnerableRemainsDummyEntity::getTile).flatMap(VulnerableRemainsBlockEntity::getMother).map(MotherBlockEntity::involvedPlayers).stream().anyMatch(s -> s.contains(player))) {
                        return true;
                    }
                }
                return !(target instanceof IRemainsEntity) && !Helper.isVampire((Entity)target);
            });
        }
    }
}

