/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.refinements;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.util.random.WeightedEntry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefinementSet
implements IRefinementSet {
    private final Set<RegistryObject<? extends IRefinement>> refinements;
    private final IRefinementSet.Rarity rarity;
    private final int color;
    @NotNull
    private final WeightedEntry.Wrapper<IRefinementSet> weightedRandom;
    private Component name;
    private Component desc;
    @Nullable
    private IRefinementItem.AccessorySlotType restrictedType;

    public RefinementSet(IRefinementSet.Rarity rarity, int color, Set<RegistryObject<? extends IRefinement>> refinements) {
        this.refinements = refinements;
        this.rarity = rarity;
        this.weightedRandom = WeightedEntry.m_146290_((Object)this, (int)this.rarity.weight);
        this.color = color;
    }

    @SafeVarargs
    public RefinementSet(IRefinementSet.Rarity rarity, int color, RegistryObject<? extends IRefinement> ... refinements) {
        this(rarity, color, UtilLib.newSortedSet(refinements));
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name != null ? this.name : (this.name = Component.m_237115_((String)("refinement_set." + RegUtil.id(this).m_135827_() + "." + RegUtil.id(this).m_135815_())));
    }

    @Override
    @NotNull
    public IRefinementSet.Rarity getRarity() {
        return this.rarity;
    }

    @Override
    @NotNull
    public Set<RegistryObject<? extends IRefinement>> getRefinements() {
        return this.refinements;
    }

    @Override
    @NotNull
    public Optional<IRefinementItem.AccessorySlotType> getSlotType() {
        return Optional.ofNullable(this.restrictedType);
    }

    public WeightedEntry.Wrapper<IRefinementSet> getWeightedRandom() {
        return this.weightedRandom;
    }

    @NotNull
    public RefinementSet onlyFor(IRefinementItem.AccessorySlotType restrictedType) {
        this.restrictedType = restrictedType;
        return this;
    }

    public static class VampireRefinementSet
    extends RefinementSet {
        public VampireRefinementSet(IRefinementSet.Rarity rarity, int color, Set<RegistryObject<? extends IRefinement>> refinements) {
            super(rarity, color, refinements);
        }

        @SafeVarargs
        public VampireRefinementSet(IRefinementSet.Rarity rarity, int color, RegistryObject<? extends IRefinement> ... refinements) {
            super(rarity, color, refinements);
        }

        @Override
        @NotNull
        public IFaction<?> getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    }
}

