/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterBasicMenu
extends InventoryContainerMenu {
    private static final InventoryContainerMenu.SelectorInfo[] SELECTOR_INFOS = new InventoryContainerMenu.SelectorInfo[]{new InventoryContainerMenu.SelectorInfo((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 27, 32)};
    @NotNull
    private final IHunterPlayer player;
    @Nullable
    private final BasicHunterEntity entity;

    @Deprecated
    public HunterBasicMenu(int id, @NotNull Inventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterBasicMenu(int id, @NotNull Inventory playerInventory, @Nullable BasicHunterEntity hunter) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModContainer.HUNTER_BASIC.get()), id, playerInventory, hunter == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)hunter.m_9236_(), (BlockPos)hunter.m_20183_()), (Container)new SimpleContainer(SELECTOR_INFOS.length), SELECTOR_INFOS);
        this.player = HunterPlayer.get(playerInventory.f_35978_);
        this.addPlayerSlots(playerInventory);
        this.entity = hunter;
    }

    public int getMissingCount() {
        int targetLevel = this.player.getLevel() + 1;
        ItemStack blood = this.inventory.m_8020_(0);
        return HunterLeveling.getBasicHunterRequirement(targetLevel).map(req -> {
            int required = req.vampireBloodAmount();
            return blood.m_41619_() || !blood.m_41720_().equals(ModItems.VAMPIRE_BLOOD_BOTTLE.get()) ? required : Math.max(0, required - blood.m_41613_());
        }).orElse(-1);
    }

    public boolean canLevelUp() {
        return this.getMissingCount() == 0;
    }

    public void onLevelUpClicked() {
        if (!this.canLevelUp()) {
            return;
        }
        int target = this.player.getLevel() + 1;
        HunterLeveling.getBasicHunterRequirement(target).ifPresent(req -> {
            this.inventory.m_7407_(0, req.vampireBloodAmount());
            FactionPlayerHandler.getOpt(this.player.getRepresentingPlayer()).ifPresent(h -> h.setFactionLevel(VReference.HUNTER_FACTION, target));
            this.player.getRepresentingPlayer().m_5661_((Component)Component.m_237115_((String)"container.vampirism.basic_hunter.levelup"), false);
            this.player.getRepresentingPlayer().m_6915_();
        });
    }

    @Override
    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.m_20193_().f_46443_) {
            this.m_150411_(playerIn, this.inventory);
        }
    }

    @Override
    public boolean m_6875_(@NotNull Player playerIn) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3(playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_()).m_82554_(new Vec3(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_())) < 5.0;
    }
}

