/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.AltarCleansingBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.DarkSpruceLeavesBlock;
import de.teamlapen.vampirism.blocks.GarlicDiffuserBlock;
import de.teamlapen.vampirism.blocks.LogBlock;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.jetbrains.annotations.NotNull;

public class MigrationData {
    @SubscribeEvent
    public static void onMissingMappings(@NotNull MissingMappingsEvent event) {
        event.getAllMappings(VampirismRegistries.SKILLS_ID).forEach(MigrationData::fixSkill);
        event.getAllMappings(ForgeRegistries.Keys.POTIONS).forEach(MigrationData::fixPotions);
        event.getAllMappings(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES).forEach(MigrationData::fixTiles);
        event.getAllMappings(ForgeRegistries.Keys.ITEMS).forEach(MigrationData::fixItems);
        event.getAllMappings(ForgeRegistries.Keys.BLOCKS).forEach(MigrationData::fixBlocks);
        event.getAllMappings(ForgeRegistries.Keys.ENCHANTMENTS).forEach(MigrationData::fixEnchantments);
        event.getAllMappings(ForgeRegistries.Keys.ENTITY_TYPES).forEach(MigrationData::fixEntityTypes);
        event.getAllMappings(ForgeRegistries.Keys.MOB_EFFECTS).forEach(MigrationData::fixEffects);
    }

    public static void fixSkill(@NotNull MissingMappingsEvent.Mapping<ISkill<?>> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:creeper_avoided": 
            case "vampirism:enhanced_crossbow": 
            case "vampirism:vampire_forest_fog": {
                mapping.ignore();
                break;
            }
            case "vampirism:bat": {
                mapping.remap((Object)((ISkill)VampireSkills.FLEDGLING.get()));
                break;
            }
            case "vampirism:garlic_beacon_improved": {
                mapping.remap((Object)((ISkill)HunterSkills.GARLIC_DIFFUSER_IMPROVED.get()));
                break;
            }
            case "vampirism:garlic_beacon": {
                mapping.remap((Object)((ISkill)HunterSkills.GARLIC_DIFFUSER.get()));
                break;
            }
            case "vampirism:holy_water_enhanced": {
                mapping.remap((Object)((ISkill)HunterSkills.ENHANCED_BLESSING.get()));
                break;
            }
            default: {
                if (!mapping.getKey().toString().startsWith("vampirism:blood_potion_")) break;
                mapping.ignore();
            }
        }
    }

    public static void fixPotions(@NotNull MissingMappingsEvent.Mapping<Potion> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:long_strong_resistance": 
            case "vampirism:very_long_resistance": {
                mapping.remap((Object)((Potion)ModPotions.LONG_RESISTANCE.get()));
                break;
            }
            case "vampirism:very_strong_resistance": {
                mapping.remap((Object)((Potion)ModPotions.STRONG_RESISTANCE.get()));
                break;
            }
            case "vampirism:thirst": 
            case "vampirism:long_thirst": 
            case "vampirism:strong_thirst": 
            case "vampirism:very_long_thirst": 
            case "vampirism:very_strong_thirst": 
            case "vampirism:long_strong_thirst": {
                mapping.ignore();
                break;
            }
            case "vampirism:very_strong_harming": {
                mapping.remap((Object)Potions.f_43583_);
            }
        }
    }

    public static void fixTiles(@NotNull MissingMappingsEvent.Mapping<BlockEntityType<?>> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:garlic_beacon": {
                mapping.remap((Object)((BlockEntityType)ModTiles.GARLIC_DIFFUSER.get()));
            }
        }
    }

    public static void fixItems(@NotNull MissingMappingsEvent.Mapping<Item> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:blood_potion": 
            case "vampirism:blood_potion_table": {
                mapping.ignore();
                break;
            }
            case "vampirism:vampire_clothing_head": {
                mapping.remap((Object)((Item)ModItems.VAMPIRE_CLOTHING_CROWN.get()));
                break;
            }
            case "vampirism:vampire_clothing_feet": {
                mapping.remap((Object)((Item)ModItems.VAMPIRE_CLOTHING_BOOTS.get()));
                break;
            }
            case "vampirism:garlic_beacon_core": {
                mapping.remap((Object)((Item)ModItems.GARLIC_DIFFUSER_CORE.get()));
                break;
            }
            case "vampirism:garlic_beacon_core_improved": {
                mapping.remap((Object)((Item)ModItems.GARLIC_DIFFUSER_CORE_IMPROVED.get()));
                break;
            }
            case "vampirism:garlic_beacon_normal": {
                mapping.remap((Object)((GarlicDiffuserBlock)((Object)ModBlocks.GARLIC_DIFFUSER_NORMAL.get())).m_5456_());
                break;
            }
            case "vampirism:garlic_beacon_weak": {
                mapping.remap((Object)((GarlicDiffuserBlock)((Object)ModBlocks.GARLIC_DIFFUSER_WEAK.get())).m_5456_());
                break;
            }
            case "vampirism:garlic_beacon_improved": {
                mapping.remap((Object)((GarlicDiffuserBlock)((Object)ModBlocks.GARLIC_DIFFUSER_IMPROVED.get())).m_5456_());
                break;
            }
            case "vampirism:church_altar": {
                mapping.remap((Object)((AltarCleansingBlock)((Object)ModBlocks.ALTAR_CLEANSING.get())).m_5456_());
                break;
            }
            case "vampirism:item_med_chair": {
                mapping.remap((Object)((MedChairBlock)((Object)ModBlocks.MED_CHAIR.get())).m_5456_());
                break;
            }
            case "vampirism:bloody_spruce_log": {
                mapping.remap((Object)((LogBlock)((Object)ModBlocks.CURSED_SPRUCE_LOG.get())).m_5456_());
                break;
            }
            case "vampirism:bloody_spruce_leaves": {
                mapping.remap((Object)((DarkSpruceLeavesBlock)((Object)ModBlocks.DARK_SPRUCE_LEAVES.get())).m_5456_());
                break;
            }
            case "vampirism:coffin": {
                mapping.remap((Object)((CoffinBlock)((Object)ModBlocks.COFFIN_RED.get())).m_5456_());
                break;
            }
            case "vampirism:holy_salt_water": {
                mapping.remap((Object)((Item)ModItems.PURE_SALT_WATER.get()));
                break;
            }
            case "vampirism:holy_salt": {
                mapping.remap((Object)((Item)ModItems.PURE_SALT.get()));
                break;
            }
            case "vampirism:injection_zombie_blood": {
                mapping.remap((Object)Items.f_42410_);
                break;
            }
            case "vampirism:cure_apple": {
                mapping.remap((Object)Items.f_42436_);
                break;
            }
            case "vampirism:obsidian_armor_head_normal": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_HEAD_NORMAL.get()));
                break;
            }
            case "vampirism:obsidian_armor_chest_normal": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_CHEST_NORMAL.get()));
                break;
            }
            case "vampirism:obsidian_armor_legs_normal": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_LEGS_NORMAL.get()));
                break;
            }
            case "vampirism:obsidian_armor_feet_normal": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_FEET_NORMAL.get()));
                break;
            }
            case "vampirism:obsidian_armor_head_enhanced": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_HEAD_ENHANCED.get()));
                break;
            }
            case "vampirism:obsidian_armor_chest_enhanced": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_CHEST_ENHANCED.get()));
                break;
            }
            case "vampirism:obsidian_armor_legs_enhanced": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_LEGS_ENHANCED.get()));
                break;
            }
            case "vampirism:obsidian_armor_feet_enhanced": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_FEET_ENHANCED.get()));
                break;
            }
            case "vampirism:obsidian_armor_head_ultimate": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get()));
                break;
            }
            case "vampirism:obsidian_armor_chest_ultimate": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get()));
                break;
            }
            case "vampirism:obsidian_armor_legs_ultimate": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get()));
                break;
            }
            case "vampirism:obsidian_armor_feet_ultimate": {
                mapping.remap((Object)((Item)ModItems.HUNTER_COAT_FEET_ULTIMATE.get()));
            }
        }
    }

    public static void fixBlocks(@NotNull MissingMappingsEvent.Mapping<Block> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:blood_potion_table": {
                mapping.remap((Object)((Block)ModBlocks.POTION_TABLE.get()));
                break;
            }
            case "vampirism:garlic_beacon_normal": {
                mapping.remap((Object)((Block)ModBlocks.GARLIC_DIFFUSER_NORMAL.get()));
                break;
            }
            case "vampirism:garlic_beacon_weak": {
                mapping.remap((Object)((Block)ModBlocks.GARLIC_DIFFUSER_WEAK.get()));
                break;
            }
            case "vampirism:garlic_beacon_improved": {
                mapping.remap((Object)((Block)ModBlocks.GARLIC_DIFFUSER_IMPROVED.get()));
                break;
            }
            case "vampirism:church_altar": {
                mapping.remap((Object)((Block)ModBlocks.ALTAR_CLEANSING.get()));
                break;
            }
            case "vampirism:vampire_spruce_leaves": 
            case "vampirism:bloody_spruce_leaves": {
                mapping.remap((Object)((Block)ModBlocks.DARK_SPRUCE_LEAVES.get()));
                break;
            }
            case "vampirism:bloody_spruce_log": {
                mapping.remap((Object)((Block)ModBlocks.CURSED_SPRUCE_LOG.get()));
                break;
            }
            case "vampirism:cursed_grass_block": {
                mapping.remap((Object)((Block)ModBlocks.CURSED_GRASS.get()));
                break;
            }
            case "cursed_bark": {
                mapping.ignore();
                break;
            }
            case "castle_block_dark_brick": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE_BRICKS.get()));
                break;
            }
            case "castle_block_dark_brick_bloody": {
                mapping.remap((Object)((Block)ModBlocks.BLOODY_DARK_STONE_BRICKS.get()));
                break;
            }
            case "castle_block_dark_stone": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE.get()));
                break;
            }
            case "castle_block_normal_brick": {
                mapping.remap((Object)Blocks.f_50222_);
                break;
            }
            case "castle_slab_dark_brick": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE_BRICK_SLAB.get()));
                break;
            }
            case "castle_slab_dark_stone": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE_SLAB.get()));
                break;
            }
            case "castle_stairs_dark_brick": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE_BRICK_STAIRS.get()));
                break;
            }
            case "castle_stairs_dark_stone": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE_STAIRS.get()));
                break;
            }
            case "castle_block_dark_brick_cracked": {
                mapping.remap((Object)((Block)ModBlocks.CRACKED_DARK_STONE_BRICKS.get()));
                break;
            }
            case "castle_block_dark_brick_wall": {
                mapping.remap((Object)((Block)ModBlocks.DARK_STONE_BRICK_WALL.get()));
                break;
            }
            case "castle_block_purple_brick": {
                mapping.remap((Object)((Block)ModBlocks.PURPLE_STONE_BRICKS.get()));
                break;
            }
            case "castle_slab_purple_brick": {
                mapping.remap((Object)((Block)ModBlocks.PURPLE_STONE_BRICK_SLAB.get()));
                break;
            }
            case "castle_stairs_purple_brick": {
                mapping.remap((Object)((Block)ModBlocks.PURPLE_STONE_BRICK_STAIRS.get()));
                break;
            }
            case "castle_block_purple_brick_wall": {
                mapping.remap((Object)((Block)ModBlocks.PURPLE_STONE_BRICK_WALL.get()));
            }
        }
    }

    static void fixEnchantments(@NotNull MissingMappingsEvent.Mapping<Enchantment> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:crossbowinfinite": {
                mapping.remap((Object)Enchantments.f_44952_);
            }
        }
    }

    static void fixEntityTypes(@NotNull MissingMappingsEvent.Mapping<EntityType<?>> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:vampire_hunter": {
                mapping.remap((Object)((EntityType)ModEntities.HUNTER.get()));
                break;
            }
            case "vampirism:vampire_hunter_imob": {
                mapping.remap((Object)((EntityType)ModEntities.HUNTER_IMOB.get()));
            }
        }
    }

    public static void fixEffects(@NotNull MissingMappingsEvent.Mapping<MobEffect> mapping) {
        switch (mapping.getKey().toString()) {
            case "vampirism:thirst": {
                mapping.remap((Object)MobEffects.f_19612_);
            }
        }
    }
}

