/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.mixin.ProcessorListsAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.NotNull;

public class VanillaStructureModifications {
    public static void addVillageStructures(@NotNull RegistryAccess dynamicRegistries) {
        VanillaStructureModifications.addHunterTrainerHouse(dynamicRegistries, VanillaStructureModifications.getDefaultPools());
        VanillaStructureModifications.addTotem(dynamicRegistries, VanillaStructureModifications.getDefaultPools());
        VanillaStructureModifications.replaceTemples(dynamicRegistries, VanillaStructureModifications.getTempleReplacements((HolderGetter<StructureProcessorList>)dynamicRegistries.m_255025_(Registries.f_257011_)));
    }

    @NotNull
    private static Map<ResourceLocation, BiomeType> getDefaultPools() {
        return Map.ofEntries(Map.entry(new ResourceLocation("village/plains/houses"), BiomeType.PLAINS), Map.entry(new ResourceLocation("village/desert/houses"), BiomeType.DESERT), Map.entry(new ResourceLocation("village/savanna/houses"), BiomeType.SAVANNA), Map.entry(new ResourceLocation("village/taiga/houses"), BiomeType.TAIGA), Map.entry(new ResourceLocation("village/snowy/houses"), BiomeType.SNOWY));
    }

    @NotNull
    private static Map<ResourceLocation, Map<String, StructurePoolElement>> getTempleReplacements(final @NotNull HolderGetter<StructureProcessorList> processorList) {
        return new HashMap<ResourceLocation, Map<String, StructurePoolElement>>(){
            {
                this.put(new ResourceLocation("village/plains/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/plains/houses/plains_temple_3", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/plains/houses/plains_temple_4", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_)));
                this.put(new ResourceLocation("village/desert/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/desert/houses/desert_temple_1"), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/desert/houses/desert_temple_2")));
                this.put(new ResourceLocation("village/savanna/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/savanna/houses/savanna_temple_1"), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/savanna/houses/savanna_temple_2")));
                this.put(new ResourceLocation("village/taiga/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/taiga/houses/taiga_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/taiga/houses/taiga_temple_1", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_)));
                this.put(new ResourceLocation("village/snowy/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/snowy/houses/snowy_temple_1")));
                this.put(new ResourceLocation("village/plains/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/plains/houses/plains_temple_3", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127199_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/plains/houses/plains_temple_4", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127199_)));
                this.put(new ResourceLocation("village/desert/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/desert/houses/desert_temple_1", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127203_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/desert/houses/desert_temple_2", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127203_)));
                this.put(new ResourceLocation("village/savanna/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/savanna/houses/savanna_temple_1", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127200_), (Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/savanna/houses/savanna_temple_2", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127200_)));
                this.put(new ResourceLocation("village/taiga/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/taiga/zombie/houses/taiga_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/taiga/houses/taiga_temple_1", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127202_)));
                this.put(new ResourceLocation("village/snowy/zombie/houses"), ImmutableMap.of((Object)VanillaStructureModifications.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)processorList, "village/snowy/houses/snowy_temple_1", (ResourceKey<StructureProcessorList>)ProcessorLists.f_127201_)));
            }
        };
    }

    private static void replaceTemples(@NotNull RegistryAccess dynamicRegistries, @NotNull Map<ResourceLocation, Map<String, StructurePoolElement>> patternReplacements) {
        if (!((Boolean)VampirismConfig.COMMON.villageReplaceTemples.get()).booleanValue()) {
            return;
        }
        dynamicRegistries.m_6632_(Registries.f_256948_).ifPresent(jigsawRegistry -> patternReplacements.forEach((pool, replacements) -> jigsawRegistry.m_6612_(pool).ifPresent(pattern -> replacements.forEach((original, modified) -> {
            ArrayList oldPieces = new ArrayList();
            pattern.f_210560_.removeIf(piece -> {
                if (piece.toString().equals(original)) {
                    oldPieces.add(piece);
                    return true;
                }
                return false;
            });
            int targetCountHalf = oldPieces.size();
            if (targetCountHalf > 1) {
                targetCountHalf = (int)((double)targetCountHalf * 0.6);
            }
            for (int i = 0; i < targetCountHalf; ++i) {
                pattern.f_210560_.add(modified);
                pattern.f_210560_.add((Object)((StructurePoolElement)oldPieces.get(i)));
            }
            ArrayList weightedElementList = new ArrayList(pattern.f_210559_);
            Optional<Pair> originalPiece = weightedElementList.stream().filter(entry -> ((StructurePoolElement)entry.getFirst()).toString().equals(original)).findAny();
            originalPiece.ifPresent(originalEntry -> {
                weightedElementList.remove(originalPiece.get());
                int targetCountHalf2 = oldPieces.size();
                if (targetCountHalf2 > 1) {
                    targetCountHalf2 = (int)((double)targetCountHalf2 * 0.6);
                }
                weightedElementList.add(new Pair((Object)((StructurePoolElement)originalEntry.getFirst()), (Object)targetCountHalf2));
                weightedElementList.add(new Pair(modified, (Object)targetCountHalf2));
            });
            pattern.f_210559_ = weightedElementList;
        }))));
    }

    private static void addHunterTrainerHouse(@NotNull RegistryAccess reg, @NotNull Map<ResourceLocation, BiomeType> pools) {
        reg.m_6632_(Registries.f_256948_).ifPresent(patternRegistry -> pools.forEach((pool, type) -> patternRegistry.m_6612_(pool).ifPresent(pattern -> {
            SinglePoolElement piece = VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)reg.m_255025_(Registries.f_257011_), "village/" + type.path + "/houses/hunter_trainer");
            for (int i = 0; i < (Integer)VampirismConfig.COMMON.villageHunterTrainerWeight.get(); ++i) {
                pattern.f_210560_.add((Object)piece);
            }
            ArrayList<Pair> weightedElementList = new ArrayList<Pair>(pattern.f_210559_);
            weightedElementList.add(new Pair((Object)piece, (Object)((Integer)VampirismConfig.COMMON.villageHunterTrainerWeight.get())));
            pattern.f_210559_ = weightedElementList;
        })));
    }

    private static void addTotem(@NotNull RegistryAccess reg, @NotNull Map<ResourceLocation, BiomeType> pools) {
        ResourceKey TOTEM_FACTION_PROCESSOR = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("vampirism", "totem_faction"));
        SinglePoolElement totem = VanillaStructureModifications.singleJigsawPiece((HolderGetter<StructureProcessorList>)reg.m_255025_(Registries.f_257011_), "village/totem", (ResourceKey<StructureProcessorList>)TOTEM_FACTION_PROCESSOR);
        reg.m_6632_(Registries.f_256948_).ifPresent(arg_0 -> VanillaStructureModifications.lambda$addTotem$12(pools, (StructurePoolElement)totem, arg_0));
    }

    private static SinglePoolElement singleJigsawPiece(@NotNull HolderGetter<StructureProcessorList> processorList, @NotNull String path) {
        return VanillaStructureModifications.singleJigsawPiece(processorList, path, ProcessorListsAccessor.getEmpty());
    }

    private static SinglePoolElement singleJigsawPiece(@NotNull HolderGetter<StructureProcessorList> processorList, @NotNull String path, @NotNull ResourceKey<StructureProcessorList> processors) {
        Holder.Reference holder = processorList.m_255043_(processors);
        return (SinglePoolElement)SinglePoolElement.m_210531_((String)("vampirism:" + path), (Holder)holder).apply(StructureTemplatePool.Projection.RIGID);
    }

    @NotNull
    public static Function<StructureTemplatePool.Projection, SinglePoolElement> singleJigsawPieceFunction(@NotNull HolderGetter<StructureProcessorList> processorList, @NotNull String path) {
        return VanillaStructureModifications.singleJigsawPieceFunction(processorList, path, ProcessorListsAccessor.getEmpty());
    }

    @NotNull
    public static Function<StructureTemplatePool.Projection, SinglePoolElement> singleJigsawPieceFunction(@NotNull HolderGetter<StructureProcessorList> processorList, @NotNull String path, @NotNull ResourceKey<StructureProcessorList> processors) {
        Holder.Reference holder = processorList.m_255043_(processors);
        return SinglePoolElement.m_210531_((String)("vampirism:" + path), (Holder)holder);
    }

    @NotNull
    private static String singleJigsawString(String resourceLocation) {
        return "Single[Left[" + resourceLocation + "]]";
    }

    @NotNull
    private static String singleLegacyJigsawString(String resourceLocation) {
        return "LegacySingle[Left[" + resourceLocation + "]]";
    }

    private static /* synthetic */ void lambda$addTotem$12(Map pools, StructurePoolElement totem, Registry patternRegistry) {
        pools.forEach((pool, type) -> patternRegistry.m_6612_(pool).ifPresent(pattern -> {
            for (int i = 0; i < (Integer)VampirismConfig.COMMON.villageTotemWeight.get(); ++i) {
                pattern.f_210560_.add((Object)totem);
            }
            ArrayList<Pair> weightedElementList = new ArrayList<Pair>(pattern.f_210559_);
            weightedElementList.add(new Pair((Object)totem, (Object)((Integer)VampirismConfig.COMMON.villageTotemWeight.get())));
            pattern.f_210559_ = weightedElementList;
        }));
    }

    public static enum BiomeType {
        PLAINS("plains"),
        TAIGA("taiga"),
        DESERT("desert"),
        SNOWY("snowy"),
        SAVANNA("savanna"),
        BADLANDS("badlands"),
        BIRCH("birch"),
        DARK_FOREST("dark_forest"),
        CRIMSON("crimson"),
        GIANT_TAIGA("giant_taiga"),
        JUNGLE("jungle"),
        MOUNTAINS("mountains"),
        OAK("oak"),
        SWAMP("swamp"),
        WARPED("warped");

        public final String path;

        private BiomeType(String path) {
            this.path = path;
        }
    }
}

