/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionManager;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.gunshots.EPressType;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.network.bidirectional.ActionUpdateMessage;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.physics.common.util.Maths;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ClientActionManager
extends ActionManager {
    public ClientActionManager() {
        super(true);
    }

    public void HookClient(IEventBus modEventBus) {
        MinecraftForge.EVENT_BUS.addListener(this::ClientTick);
    }

    @Override
    @Nonnull
    protected EActionResult TryStartGroupInstance(@Nonnull ActionStack actionStack, @Nonnull ActionGroupContext context) {
        return actionStack.Client_TryStartGroupInstance(context);
    }

    @Override
    @Nonnull
    protected EActionResult TryUpdateGroupInstanceHeld(@Nonnull ActionStack actionStack, @Nonnull ActionGroupContext context) {
        return actionStack.Client_TryUpdateGroupInstanceHeld(context);
    }

    @Override
    @Nonnull
    protected EActionResult TryUpdateGroupInstanceNotHeld(@Nonnull ActionStack actionStack, @Nonnull ActionGroupContext context) {
        return actionStack.Client_TryUpdateGroupInstanceNotHeld(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ClientKeyPressed(@Nonnull Player player, @Nonnull EPlayerInput inputType) {
        this.KeyPressed(ShooterContext.of((Entity)player), inputType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ClientKeyHeld(@Nonnull Player player, @Nonnull EPlayerInput inputType) {
        this.KeyHeld(ShooterContext.of((Entity)player), inputType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ClientKeyReleased(@Nonnull Player player, @Nonnull EPlayerInput inputType, int ticksSinceHeld) {
        this.KeyReleased(ShooterContext.of((Entity)player), inputType, ticksSinceHeld);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void OnClientReceivedActionUpdate(ActionUpdateMessage.ToClient msg) {
        ActionGroupContext groupContext = msg.Data.GetActionGroupContext(true);
        if (groupContext.IsValid()) {
            if (groupContext.Gun.GetShooter().Entity() == Minecraft.m_91087_().f_91074_) {
                FlansMod.LOGGER.warn("OnClientReceivedActionUpdate received with data for myself");
                return;
            }
            ActionStack actionStack = groupContext.Gun.GetActionStack();
            ActionGroupInstance groupInstance = actionStack.TryGetGroupInstance(groupContext);
            EPressType pressTypeToProcess = msg.Data.GetPressType();
            if (groupInstance == null) {
                if (pressTypeToProcess != EPressType.Press) {
                    FlansMod.LOGGER.warn("Received ActionUpdateMessage with wrong press type for action that was not already running");
                    if (pressTypeToProcess == EPressType.Hold) {
                        pressTypeToProcess = EPressType.Press;
                    }
                }
                groupInstance = actionStack.GetOrCreateGroupInstance(groupContext);
                groupInstance.OnStartClientFromNetwork(msg.Data.GetStartTick());
                switch (pressTypeToProcess) {
                    case Press: {
                        for (Map.Entry<Integer, ActionUpdateMessage.ActionTriggerInfo> kvp : msg.Data.GetTriggers()) {
                            int triggerIndex = kvp.getKey();
                            int actionIndex = 0;
                            for (ActionInstance action : groupInstance.GetActions()) {
                                ActionInstance.NetData netData = msg.Data.GetNetData(triggerIndex, actionIndex);
                                action.UpdateFromNetData(netData, triggerIndex);
                                action.OnTriggerClient(triggerIndex);
                                ++actionIndex;
                            }
                        }
                        break;
                    }
                    case Release: {
                        switch (groupContext.RepeatMode()) {
                            case FullAuto: 
                            case Minigun: {
                                long numTicks = msg.Data.GetLastTriggerTick() - groupInstance.GetStartedTick();
                                int expectedTriggerCount = Maths.floor(numTicks / (long)groupContext.RepeatDelayTicks()) + 1;
                                int serverTriggerCount = groupInstance.GetTriggerCount();
                                if (expectedTriggerCount > serverTriggerCount) {
                                    FlansMod.LOGGER.info("Client expected to trigger " + expectedTriggerCount + " repeat(s), but server only triggered " + serverTriggerCount + " repeat(s)");
                                    break;
                                }
                                if (expectedTriggerCount >= serverTriggerCount) break;
                                FlansMod.LOGGER.info("Client expected to trigger " + expectedTriggerCount + " repeat(s), but server triggered " + serverTriggerCount + " many repeat(s)");
                            }
                        }
                        groupInstance.UpdateInputHeld(false);
                        groupInstance.OnFinishClient();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void OnClientVerifyShots() {
    }

    public void ClientTick(TickEvent.ClientTickEvent tickEvent) {
        if (tickEvent.phase == TickEvent.Phase.START) {
            GunContext gunContext;
            ArrayList<UUID> invalidIDs = new ArrayList<UUID>();
            for (Map.Entry kvp : this.ActionStacks.entrySet()) {
                UUID gunID = (UUID)kvp.getKey();
                ActionStack actionStack = (ActionStack)kvp.getValue();
                gunContext = GunContext.of(gunID);
                if (gunContext.IsValid()) {
                    if (!actionStack.IsValid()) continue;
                    actionStack.OnTick((Level)Minecraft.m_91087_().f_91073_, gunContext);
                    continue;
                }
                actionStack.Clear(gunContext);
                invalidIDs.add(gunID);
            }
            for (UUID invalidID : invalidIDs) {
                this.ActionStacks.remove(invalidID);
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                ShooterContext shooterContext = ShooterContext.of((Entity)player);
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    UUID gunID;
                    if (!(player.m_150109_().m_8020_(i).m_41720_() instanceof GunItem) || (gunID = FlanItem.GetGunID(player.m_150109_().m_8020_(i))) == FlanItem.InvalidGunUUID) continue;
                    gunContext = GunContext.of(shooterContext, gunID);
                    ActionStack actionStack = this.GetActionStack(gunID);
                    boolean equipped = i == player.m_150109_().f_35977_ || i == 40;
                    actionStack.UpdateEquipped(gunContext, equipped);
                }
            }
        }
    }
}

