/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.crafting;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.gui.crafting.WorkbenchScreenTab;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.menus.WorkbenchMenuModification;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.common.types.elements.EFilterType;
import com.flansmod.common.types.elements.LocationFilterDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.guns.GunDefinition;
import com.flansmod.common.types.guns.elements.MagazineSlotSettingsDefinition;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.common.util.Maths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WorkbenchScreenTabModification
extends WorkbenchScreenTab<WorkbenchMenuModification> {
    private static final ResourceLocation MOD_BG = new ResourceLocation("flansmod", "textures/gui/gun_modification_table.png");
    private static final int MOD_W = 256;
    private static final int MOD_H = 256;
    private static final int ATTACHMENT_SLOTS_ORIGIN_X = 49;
    private static final int ATTACHMENT_SLOTS_ORIGIN_Y = 17;
    private static final int MAG_UPGRADE_SLOT_ORIGIN_X = 7;
    private static final int MAG_UPGRADE_SLOT_ORIGIN_Y = 93;
    private static final int MAGAZINE_SELECTOR_ORIGIN_X = 29;
    private static final int MAGAZINE_SELECTOR_ORIGIN_Y = 93;
    private static final int MAGAZINES_PER_ROW = 7;
    private static final int MAGAZINE_ROWS = 1;
    private final Button[] MagazineButtons = new Button[7];
    private float GunAngle = 2.0f;
    private float GunAngularVelocity = 5.0f;

    public WorkbenchScreenTabModification(@Nonnull WorkbenchMenuModification menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
    }

    @Override
    protected boolean IsTabPresent() {
        return ((WorkbenchMenuModification)this.Workbench).Def.gunModifying.isActive;
    }

    @Override
    @Nonnull
    protected Component GetTitle() {
        return Component.m_237115_((String)"workbench.tab_modification");
    }

    @Override
    protected void InitTab() {
        if (this.IsTabPresent()) {
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 1; ++j) {
                    int index = i + j * 7;
                    this.MagazineButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.NetworkedButtonPress(0 + index)).m_252987_(this.xOrigin + 29 + 18 * i, this.yOrigin + 93 + 18 * j, 18, 18).m_253136_();
                    this.m_7787_((GuiEventListener)this.MagazineButtons[index]);
                }
            }
        }
    }

    @Override
    protected void OnTabSelected(boolean selected) {
        this.UpdateTab(selected);
    }

    @Override
    protected void UpdateTab(boolean selected) {
        this.GunAngularVelocity *= Maths.expF(-FlansModClient.FrameDeltaSeconds() * 0.25f);
        this.GunAngle += FlansModClient.FrameDeltaSeconds() * this.GunAngularVelocity;
        if (this.IsTabPresent()) {
            FlanItem flanItem;
            JsonDefinition jsonDefinition;
            Item item;
            int numMagButtons = 0;
            if (selected && ((WorkbenchMenuModification)this.Workbench).GunContainer.m_6643_() > 0 && (item = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem && (jsonDefinition = (flanItem = (FlanItem)item).Def()) instanceof GunDefinition) {
                GunDefinition gunDefinition = (GunDefinition)jsonDefinition;
                numMagButtons = gunDefinition.GetMagazineSettings("primary_fire").GetMatchingMagazines().size();
            }
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 1; ++j) {
                    int index = i + j * 7;
                    if (this.MagazineButtons[index] == null) continue;
                    this.MagazineButtons[index].f_93623_ = index < numMagButtons;
                }
            }
        }
    }

    @Override
    protected boolean OnMouseScroll(int xMouse, int yMouse, double scroll) {
        if (scroll != 0.0 && xMouse >= this.xOrigin + this.f_97726_) {
            this.GunAngularVelocity = (float)((double)this.GunAngularVelocity + scroll * 2.0);
            return true;
        }
        return false;
    }

    @Override
    protected boolean RenderTooltip(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        Item item;
        if (WorkbenchScreenTabModification.InBox(xMouse, yMouse, this.xOrigin + 7, 18, this.yOrigin + 93, 18)) {
            graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"workbench.slot.mag_upgrade"), xMouse, yMouse);
            return true;
        }
        if (WorkbenchScreenTabModification.InBox(xMouse, yMouse, this.xOrigin + 49 + 26, 24, this.yOrigin + 17 + 26, 24)) {
            graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"workbench.slot.gun"), xMouse, yMouse);
            return true;
        }
        if (((WorkbenchMenuModification)this.Workbench).GunContainer.m_6643_() >= 0 && !((WorkbenchMenuModification)this.Workbench).GunContainer.m_7983_() && (item = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
            ItemStack gunStack = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0);
            for (WorkbenchMenuModification.ModSlot modSlot : WorkbenchMenuModification.ModSlot.values()) {
                boolean hasSlot = flanItem.HasAttachmentSlot(modSlot.attachType, modSlot.attachIndex);
                if (!WorkbenchScreenTabModification.InBox(xMouse, yMouse, this.xOrigin + 49 + modSlot.x * 26, 24, this.yOrigin + 17 + modSlot.y * 26, 24)) continue;
                graphics.m_280557_(this.font, (Component)Component.m_237115_((String)("workbench.slot.attachments." + modSlot.attachType.toString().toLowerCase() + (hasSlot ? "" : ".missing"))), xMouse, yMouse);
                return true;
            }
            JsonDefinition jsonDefinition = flanItem.Def();
            if (jsonDefinition instanceof GunDefinition) {
                GunDefinition gunDef = (GunDefinition)jsonDefinition;
                MagazineSlotSettingsDefinition magSettings = gunDef.GetMagazineSettings("primary_fire");
                List<MagazineDefinition> matchingMags = magSettings.GetMatchingMagazines();
                for (int j = 0; j < 1; ++j) {
                    for (int i = 0; i < 7; ++i) {
                        int index = j * 7 + i;
                        if (index >= matchingMags.size() || !WorkbenchScreenTabModification.InBox(xMouse, yMouse, this.xOrigin + 29 + 18 * i, 18, this.yOrigin + 93 + 18 * j, 18)) continue;
                        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                        lines.add(Component.m_237115_((String)("magazine." + matchingMags.get((int)i).Location.m_135827_() + "." + matchingMags.get((int)i).Location.m_135815_())).m_7532_());
                        lines.add(Component.m_237110_((String)"magazine.num_rounds", (Object[])new Object[]{matchingMags.get((int)i).numRounds}).m_7532_());
                        for (LocationFilterDefinition idFilter : matchingMags.get((int)i).matchingBullets.itemIDFilters) {
                            if (idFilter.filterType != EFilterType.Allow) continue;
                            for (ResourceLocation resLoc : idFilter.matchResourceLocations) {
                                lines.add(Component.m_237110_((String)"magazine.match_bullet_name", (Object[])new Object[]{resLoc}).m_7532_());
                            }
                        }
                        for (LocationFilterDefinition tagFilter : matchingMags.get((int)i).matchingBullets.itemTagFilters) {
                            for (ResourceLocation resLoc : tagFilter.matchResourceLocations) {
                                String line = tagFilter.filterType == EFilterType.Allow ? "magazine.required_bullet_tag" : "magazine.disallowed_bullet_tag";
                                lines.add(Component.m_237110_((String)line, (Object[])new Object[]{resLoc.toString()}).m_7532_());
                            }
                        }
                        int magCost = AbstractWorkbench.GetMagUpgradeCost(((WorkbenchMenuModification)this.Workbench).GunContainer, index);
                        if (magCost == 1) {
                            lines.add(Component.m_237115_((String)"magazine.cost.1").m_7532_());
                        } else {
                            lines.add(Component.m_237110_((String)"magazine.cost", (Object[])new Object[]{magCost}).m_7532_());
                        }
                        for (ModifierDefinition modifier : matchingMags.get((int)i).modifiers) {
                            for (Component modString : modifier.GetModifierStrings()) {
                                lines.add(modString.m_7532_());
                            }
                        }
                        graphics.m_280245_(this.font, lines, xMouse, yMouse);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void RenderBG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        if (((WorkbenchMenuModification)this.Workbench).GunContainer.m_6643_() > 0) {
            this.Render3DGun(graphics, this.xOrigin + this.f_97726_ + 64, this.yOrigin + 64, this.GunAngle, -45.0f, ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0));
        }
        graphics.m_280163_(MOD_BG, this.xOrigin, this.yOrigin, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        if (((WorkbenchMenuModification)this.Workbench).GunContainer.m_6643_() >= 0) {
            Item item;
            graphics.m_280163_(MOD_BG, this.xOrigin + 49 + 26, this.yOrigin + 17 + 26, 198.0f, 26.0f, 22, 22, 256, 256);
            graphics.m_280163_(MOD_BG, this.xOrigin + 7, this.yOrigin + 93, 190.0f, 201.0f, 18, 18, 256, 256);
            if (!((WorkbenchMenuModification)this.Workbench).GunContainer.m_7983_() && (item = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem) {
                FlanItem flanItem = (FlanItem)item;
                ItemStack gunStack = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0);
                for (WorkbenchMenuModification.ModSlot modSlot : WorkbenchMenuModification.ModSlot.values()) {
                    if (!flanItem.HasAttachmentSlot(modSlot.attachType, modSlot.attachIndex)) continue;
                    int srcX = 172 + 26 * modSlot.x;
                    int srcY = 26 * modSlot.y;
                    if (modSlot.attachType == EAttachmentType.Charm) {
                        srcX = 44;
                        srcY = 218;
                    } else if (modSlot.attachType == EAttachmentType.Generic) {
                        srcX = 66;
                        srcY = 218;
                    }
                    graphics.m_280163_(MOD_BG, this.xOrigin + 49 + 26 * modSlot.x, this.yOrigin + 17 + 26 * modSlot.y, (float)srcX, (float)srcY, 22, 22, 256, 256);
                }
                if (flanItem instanceof GunItem) {
                    GunItem gunItem = (GunItem)flanItem;
                    MagazineSlotSettingsDefinition magSettings = gunItem.Def().GetMagazineSettings("primary_fire");
                    List<MagazineDefinition> matchingMags = magSettings.GetMatchingMagazines();
                    MagazineDefinition currentMagType = gunItem.GetMagazineType(gunStack, "primary_fire", 0);
                    for (int i = 0; i < matchingMags.size(); ++i) {
                        int xIndex = i % 7;
                        int yIndex = i / 7;
                        if (matchingMags.get(i) == currentMagType) {
                            graphics.m_280163_(MOD_BG, this.xOrigin + 29 + xIndex * 18, this.yOrigin + 93 + yIndex * 18, 172.0f, 201.0f, 18, 18, 256, 256);
                            continue;
                        }
                        graphics.m_280163_(MOD_BG, this.xOrigin + 29 + xIndex * 18, this.yOrigin + 93 + yIndex * 18, 172.0f, 165.0f, 18, 18, 256, 256);
                    }
                }
            }
        }
    }

    @Override
    protected void RenderFG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        Item item;
        if (((WorkbenchMenuModification)this.Workbench).GunContainer.m_6643_() >= 0 && !((WorkbenchMenuModification)this.Workbench).GunContainer.m_7983_() && (item = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
            ItemStack gunStack = ((WorkbenchMenuModification)this.Workbench).GunContainer.m_8020_(0);
            JsonDefinition jsonDefinition = flanItem.Def();
            if (jsonDefinition instanceof GunDefinition) {
                GunDefinition gunDef = (GunDefinition)jsonDefinition;
                MagazineSlotSettingsDefinition magSettings = gunDef.GetMagazineSettings("primary_fire");
                List<MagazineDefinition> matchingMags = magSettings.GetMatchingMagazines();
                for (int i = 0; i < matchingMags.size(); ++i) {
                    int xIndex = i % 7;
                    int yIndex = i / 7;
                    TextureAtlasSprite sprite = FlansModClient.MAGAZINE_ATLAS.GetIcon(matchingMags.get((int)i).Location);
                    graphics.m_280159_(30 + xIndex * 18, 94 + yIndex * 18, 0, 16, 16, sprite);
                }
            }
        }
    }
}

