/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.render.animation.FlanimationDefinition;
import com.flansmod.client.render.guns.AttachmentItemRenderer;
import com.flansmod.client.render.guns.GunItemRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.nodes.AimDownSightAction;
import com.flansmod.common.gunshots.PlayerSnapshot;
import com.flansmod.common.gunshots.Raytracer;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class FirstPersonManager {
    public static float ADS_BLEND = 0.0f;
    public static HashMap<String, AdsInstance> ADS_INSTANCES = new HashMap();
    public static int NUM_LOAD_ANIMS_TO_PLAY = 0;
    private static final Transform MC_FIRST_PERSON_OFFSET_RIGHT = Transform.fromPos(new Vec3(-0.06, 1.0, 1.0));
    private static final Transform MC_FIRST_PERSON_OFFSET_LEFT = Transform.fromPos(new Vec3(1.06, 1.0, 1.0));
    private static final Transform MC_THIRD_PERSON_OFFSET = Transform.fromPosAndEuler(new Vec3(0.5, 0.5, 0.5), new Vector3f(0.0f, 90.0f, 0.0f));
    private static final Transform MC_GROUND_OFFSET = Transform.fromPos(new Vec3(0.5, 0.5, 0.5));

    public static void LocalPlayerStartReload(int count) {
        NUM_LOAD_ANIMS_TO_PLAY = count;
    }

    public static boolean ConsumeLoadOne() {
        if (NUM_LOAD_ANIMS_TO_PLAY > 0) {
            --NUM_LOAD_ANIMS_TO_PLAY;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Transform GetModelSpaceAPTransform(@Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType, @Nonnull String apName) {
        TransformStack transformStack = TransformStack.empty();
        FirstPersonManager.ApplyModelToAP(transformStack, gunContext, apName, true);
        return transformStack.top();
    }

    @Nonnull
    public static Transform GetWorldSpaceAPTransform(@Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType, @Nonnull String apName) {
        float dt = Minecraft.m_91087_().getPartialTick();
        TransformStack transformStack = TransformStack.empty();
        switch (transformType) {
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                FirstPersonManager.ApplyWorldToEye(transformStack, gunContext, transformType);
                TransformStack inScreenSpace = TransformStack.empty();
                FirstPersonManager.ApplyEyeToRoot(inScreenSpace, gunContext, transformType);
                FirstPersonManager.ApplyRootToModel(inScreenSpace, gunContext, transformType);
                FirstPersonManager.ApplyModelToAP(inScreenSpace, gunContext, apName, true);
                Transform eyeToAP = inScreenSpace.top();
                Vec3 eyePos = eyeToAP.positionVec3();
                Matrix4f firstPersonProjection = FirstPersonManager.GetFirstPersonProjection();
                Matrix4f levelProjectionInv = FirstPersonManager.GetLevelProjection().invert();
                Vec3 pos = FirstPersonManager.ReprojectVector(eyePos, firstPersonProjection, levelProjectionInv);
                Vec3 fwd = FirstPersonManager.ReprojectVector(eyeToAP.forward().m_82549_(eyePos), firstPersonProjection, levelProjectionInv).m_82546_(pos).m_82541_();
                Vec3 up = FirstPersonManager.ReprojectVector(eyeToAP.up().m_82549_(eyePos), firstPersonProjection, levelProjectionInv).m_82546_(pos).m_82541_();
                transformStack.add(Transform.fromPositionAndLookDirection(pos, fwd, up));
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                Entity eyeToAP = gunContext.GetShooter().Entity();
                if (!(eyeToAP instanceof Player)) break;
                Player player = (Player)eyeToAP;
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level == null) break;
                Raytracer raytracer = Raytracer.ForLevel((LevelAccessor)Minecraft.m_91087_().f_91073_);
                PlayerSnapshot currentSnap = raytracer.GetSnapshot(player, 0);
                PlayerSnapshot prevSnap = raytracer.GetSnapshot(player, 1);
                if (!currentSnap.valid || !prevSnap.valid) break;
                Transform currentArmRoot = currentSnap.GetArmTransform(MinecraftHelpers.getArm(transformType));
                Transform previousArmRoot = prevSnap.GetArmTransform(MinecraftHelpers.getArm(transformType));
                transformStack.add(Transform.interpolate(previousArmRoot, currentArmRoot, dt));
                transformStack.add(Transform.fromEuler(180.0f, 180.0f, 0.0f));
                transformStack.add(Transform.fromEuler(-90.0f, 0.0f, 180.0f));
                transformStack.add(Transform.fromPos(-0.03125, 0.125, -0.375));
                transformStack.add(Transform.fromPos(-0.5, -0.5, -0.5));
                FirstPersonManager.ApplyRootToModel(transformStack, gunContext, transformType);
                FirstPersonManager.ApplyModelToAP(transformStack, gunContext, apName, true);
            }
        }
        return transformStack.top();
    }

    @Nonnull
    private static Vec3 ReprojectVector(@Nonnull Vec3 src, @Nonnull Matrix4f from, @Nonnull Matrix4f toInverse) {
        Vector4f scratch = new Vector4f((float)src.f_82479_, (float)src.f_82480_, (float)src.f_82481_, 1.0f);
        scratch.mul((Matrix4fc)from);
        float w = scratch.w;
        if (w > 1.0E-6f) {
            scratch.mul(1.0f / w);
            float w2 = 1.0f / (scratch.z * toInverse.m23() + toInverse.m33());
            scratch.mul(w2);
            scratch.mul((Matrix4fc)toInverse);
            if (!Maths.approx(scratch.w, 1.0f, 0.001f)) {
                FlansMod.LOGGER.warn("Un-projection to world space was not normalized. w=" + scratch.w);
            }
            return new Vec3((double)scratch.x, (double)scratch.y, (double)scratch.z);
        }
        return src;
    }

    private static Matrix4f GetFirstPersonProjection() {
        float dt = Minecraft.m_91087_().getPartialTick();
        double fov = FlansModClient.GetFOV(Minecraft.m_91087_().f_91063_.m_109153_(), dt, false);
        return Minecraft.m_91087_().f_91063_.m_253088_(fov);
    }

    private static Matrix4f GetLevelProjection() {
        float dt = Minecraft.m_91087_().getPartialTick();
        PoseStack posestack = new PoseStack();
        double d0 = FlansModClient.GetFOV(Minecraft.m_91087_().f_91063_.m_109153_(), dt, true);
        posestack.m_252931_(Minecraft.m_91087_().f_91063_.m_253088_(d0));
        TransformStack transformStack = TransformStack.empty();
        return posestack.m_85850_().m_252922_();
    }

    public static Transform GetWorldSpaceRootTransform(@Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType) {
        TransformStack transformStack = TransformStack.empty();
        FirstPersonManager.ApplyWorldToEye(transformStack, gunContext, transformType);
        FirstPersonManager.ApplyEyeToRoot(transformStack, gunContext, transformType);
        return transformStack.top();
    }

    public static Transform GetRootSpaceModelTransform(@Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType) {
        TransformStack transformStack = TransformStack.empty();
        FirstPersonManager.ApplyRootToModel(transformStack, gunContext, transformType);
        return transformStack.top();
    }

    public static void ApplyWorldToEye(@Nonnull TransformStack transformStack, @Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType) {
        float dt = Minecraft.m_91087_().getPartialTick();
        switch (transformType) {
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) break;
                transformStack.add(Transform.fromPos(player.m_20299_(dt)));
                transformStack.add(Transform.fromEuler(player.m_5686_(dt), 180.0f + player.m_5675_(dt), 0.0f));
                break;
            }
            default: {
                transformStack.add(gunContext.GetShootOrigin(dt));
            }
        }
    }

    public static void ApplyEyeToRoot(@Nonnull TransformStack transformStack, @Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType) {
        float dt = Minecraft.m_91087_().getPartialTick();
        switch (transformType) {
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    FirstPersonManager.Vanilla_ApplyHurtBobbing(transformStack, dt);
                    FirstPersonManager.Vanilla_ApplyWalkBobbing(transformStack, dt);
                    FirstPersonManager.Vanilla_ApplyViewBobbing(transformStack, dt);
                    FirstPersonManager.Vanilla_ApplyHandAnimation(transformStack, transformType, dt);
                    transformStack.add(Transform.fromPos(new Vec3(-0.5, -0.5, -0.5)));
                    break;
                }
                transformStack.add(Transform.error("Trying to render first person with no current player"));
            }
        }
    }

    public static void ApplyRootToModel(@Nonnull TransformStack transformStack, @Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType) {
        float dt = Minecraft.m_91087_().getPartialTick();
        ITurboRenderer turboRenderer = FlansModelRegistry.GetItemRenderer(gunContext.Stack);
        if (turboRenderer instanceof GunItemRenderer) {
            GunItemRenderer gunRenderer = (GunItemRenderer)turboRenderer;
            Transform defaultPose = gunRenderer.getOrDefault(rig -> rig.getTransform(transformType), Transform.IDENTITY);
            switch (transformType) {
                case FIRST_PERSON_RIGHT_HAND: 
                case FIRST_PERSON_LEFT_HAND: {
                    if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                        transformStack.add(MC_FIRST_PERSON_OFFSET_RIGHT);
                    } else {
                        transformStack.add(MC_FIRST_PERSON_OFFSET_LEFT);
                    }
                    Transform adsBlendTransform = FirstPersonManager.CalculateADSPosition(defaultPose, gunContext, transformType);
                    transformStack.add(adsBlendTransform);
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: 
                case THIRD_PERSON_LEFT_HAND: {
                    transformStack.add(MC_THIRD_PERSON_OFFSET);
                    transformStack.add(defaultPose);
                    break;
                }
                case GROUND: {
                    transformStack.add(MC_GROUND_OFFSET);
                    transformStack.add(defaultPose);
                    break;
                }
                default: {
                    transformStack.add(defaultPose);
                    break;
                }
            }
        } else {
            transformStack.add(Transform.error("Could not find gun renderer for " + gunContext));
        }
    }

    public static void ApplyItemTransforms(@Nonnull TransformStack transformStack, @Nonnull GunContext gunContext) {
        ITurboRenderer gunRenderer = FlansModelRegistry.GetItemRenderer(gunContext.Stack);
        if (gunRenderer != null) {
            // empty if block
        }
    }

    public static void ApplyModelToAP(@Nonnull TransformStack transformStack, @Nonnull GunContext gunContext, @Nonnull String apName, boolean animated) {
        ITurboRenderer turboRenderer = FlansModelRegistry.GetItemRenderer(gunContext.Stack);
        if (turboRenderer instanceof GunItemRenderer) {
            GunItemRenderer gunRenderer = (GunItemRenderer)turboRenderer;
            FlanimationDefinition animationSet = animated ? (FlanimationDefinition)FlansModClient.ANIMATIONS.Get(new ResourceLocation(gunContext.Def.animationSet)) : null;
            ActionStack actionStack = animated ? gunContext.GetActionStack() : null;
            EAttachmentType attachmentType = ActionGroupContext.GetAttachmentType(apName);
            int attachmentIndex = ActionGroupContext.GetAttachmentIndex(apName);
            String gunAPName = gunRenderer.getAPKey(attachmentType, attachmentIndex);
            String childAPName = ActionGroupContext.GetActionGroupKey(apName);
            if (attachmentIndex == -1) {
                gunRenderer.ApplyAPOffsetInternal(transformStack, apName, animationSet, actionStack);
            } else {
                gunRenderer.ApplyAPOffsetInternal(transformStack, gunAPName, animationSet, actionStack);
                AttachmentDefinition attachDef = gunContext.GetAttachmentDefinition(attachmentType, attachmentIndex);
                if (attachDef.IsValid()) {
                    ITurboRenderer turboRenderer1 = FlansModelRegistry.GetItemRenderer(attachDef.Location);
                    if (turboRenderer1 instanceof AttachmentItemRenderer) {
                        AttachmentItemRenderer attachmentRenderer = (AttachmentItemRenderer)turboRenderer1;
                        attachmentRenderer.ApplyAPOffsetInternal(transformStack, childAPName, null, null);
                    } else {
                        transformStack.add(Transform.error("Could not find attachment renderer for " + attachDef + " at '" + attachDef + "'"));
                    }
                } else {
                    transformStack.add(Transform.error("There is no attachment at path " + attachmentType + "/" + attachmentIndex));
                }
            }
        } else {
            transformStack.add(Transform.error("Could not find gun renderer for " + gunContext.Def));
        }
    }

    private static void Vanilla_ApplyViewBobbing(@Nonnull TransformStack transformStack, float dt) {
        Entity entity;
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue() && (entity = Minecraft.m_91087_().m_91288_()) instanceof LocalPlayer) {
            LocalPlayer playerCamera = (LocalPlayer)entity;
            float f = playerCamera.m_21324_(dt);
            float f1 = Mth.m_14179_((float)dt, (float)playerCamera.f_19860_, (float)playerCamera.m_146909_());
            float f2 = Mth.m_14179_((float)dt, (float)playerCamera.f_108588_, (float)playerCamera.f_108586_);
            float f3 = Mth.m_14179_((float)dt, (float)playerCamera.f_108587_, (float)playerCamera.f_108585_);
            float xAngle = (playerCamera.m_5686_(dt) - f2) * 0.1f;
            float yAngle = (playerCamera.m_5675_(dt) - f3) * 0.1f;
            if (!Maths.approx(xAngle, 0.0f) && !Maths.approx(yAngle, 0.0f)) {
                transformStack.add(Transform.fromEuler(-xAngle, -yAngle, 0.0f));
            }
        }
    }

    private static void Vanilla_ApplyHurtBobbing(@Nonnull TransformStack transformStack, float dt) {
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingCamera = (LivingEntity)entity;
            float hurtTime = (float)livingCamera.f_20916_ - dt;
            if (livingCamera.m_21224_()) {
                float f1 = Math.min((float)livingCamera.f_20919_ + dt, 20.0f);
                transformStack.add(Transform.fromEuler(0.0f, 0.0f, 40.0f - 8000.0f / (f1 + 200.0f)));
            }
            if (hurtTime < 0.0f) {
                return;
            }
            float hurtParameter = hurtTime / (float)livingCamera.f_20917_;
            float f = Mth.m_14031_((float)(hurtParameter * hurtParameter * hurtParameter * hurtParameter * (float)Math.PI));
            float f2 = livingCamera.m_264297_();
            transformStack.add(Transform.fromEuler(0.0f, -f2, 0.0f));
            transformStack.add(Transform.fromEuler(0.0f, 0.0f, -f * 14.0f));
            transformStack.add(Transform.fromEuler(0.0f, f2, 0.0f));
        }
    }

    private static void Vanilla_ApplyWalkBobbing(@Nonnull TransformStack transformStack, float dt) {
        Entity entity;
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue() && (entity = Minecraft.m_91087_().m_91288_()) instanceof Player) {
            Player player = (Player)entity;
            float f = player.f_19787_ - player.f_19867_;
            float f1 = -(player.f_19787_ + f * dt);
            float f2 = Mth.m_14179_((float)dt, (float)player.f_36099_, (float)player.f_36100_);
            transformStack.add(Transform.fromPos(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2), 0.0));
            transformStack.add(Transform.fromEuler(0.0f, 0.0f, Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            transformStack.add(Transform.fromEuler(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f, 0.0f, 0.0f));
        }
    }

    private static void Vanilla_ApplyHandAnimation(@Nonnull TransformStack transformStack, ItemDisplayContext transformType, float dt) {
        boolean rightHand = transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        int i = rightHand ? 1 : -1;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float atkSwing = player.m_21324_(dt);
        InteractionHand attackingHand = (InteractionHand)MoreObjects.firstNonNull((Object)player.f_20912_, (Object)InteractionHand.MAIN_HAND);
        if (attackingHand != MinecraftHelpers.getHand(transformType)) {
            atkSwing = 0.0f;
        }
        float attackSwing = atkSwing;
        float handRaise = 1.0f - FlansModClient.GetHandHeight(MinecraftHelpers.getHand(transformType), dt);
        float f5 = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)handRaise) * (float)Math.PI));
        float f6 = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)handRaise) * ((float)Math.PI * 2)));
        float f10 = -0.2f * Mth.m_14031_((float)(handRaise * (float)Math.PI));
        transformStack.add(Transform.fromPos((float)i * f5, f6, f10));
        transformStack.add(Transform.fromPos((float)i * 0.56f, -0.52f + handRaise * -0.6f, -0.72f));
        float f = Mth.m_14031_((float)(attackSwing * attackSwing * (float)Math.PI));
        transformStack.add(Transform.fromEuler(0.0f, (float)i * (45.0f + f * -20.0f), 0.0f));
        float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)attackSwing) * (float)Math.PI));
        transformStack.add(Transform.fromEuler(f1 * -80.0f, (float)i * -45.0f, (float)i * f1 * -20.0f));
    }

    public static Transform CalculateADSPosition(@Nonnull Transform defaultPose, @Nonnull GunContext gunContext, @Nonnull ItemDisplayContext transformType) {
        ArrayList<Transform> posesAppliedToMe = new ArrayList<Transform>();
        ArrayList<Float> weights = new ArrayList<Float>();
        ArrayList<Transform> posesAppliedToOthers = new ArrayList<Transform>();
        for (AdsInstance instance : ADS_INSTANCES.values()) {
            String eyeLinePath = instance.AttachmentIndex >= 0 ? ActionGroupContext.CreateGroupPath(instance.AttachmentType, instance.AttachmentIndex, instance.EyeLineName) : instance.EyeLineName;
            GunContext animlessContext = GunContext.of(gunContext.GetItemStack());
            Transform eyeLine = FirstPersonManager.GetModelSpaceAPTransform(animlessContext, transformType, eyeLinePath);
            if (instance.TransformType == transformType) {
                posesAppliedToMe.add(eyeLine);
                weights.add(Float.valueOf(instance.BlendAmount));
                continue;
            }
            posesAppliedToOthers.add(eyeLine);
        }
        float[] weightArray = new float[weights.size()];
        float totalWeight = 0.0f;
        for (int i = 0; i < weights.size(); ++i) {
            weightArray[i] = ((Float)weights.get(i)).floatValue();
            totalWeight += ((Float)weights.get(i)).floatValue();
        }
        TransformStack eyeLineStack = TransformStack.empty();
        Transform eyeLinePos = Transform.interpolate(posesAppliedToMe, weightArray);
        float blendWeight = Maths.clamp(totalWeight, 0.0f, 1.0f);
        if (posesAppliedToOthers.size() > 0) {
            blendWeight *= 0.5f;
            boolean leftHanded = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            eyeLineStack.add(Transform.fromEuler(0.0f, 0.0f, leftHanded ? 30.0f : -30.0f));
        }
        eyeLineStack.add(Transform.fromPos(new Vec3(0.0, 0.0, -0.5)));
        eyeLineStack.add(Transform.extractOrientation(defaultPose, false));
        eyeLineStack.add(Transform.extractOrientation(eyeLinePos, true));
        eyeLineStack.add(Transform.extractPosition(eyeLinePos, -1.0));
        Transform lookDownEyeLineTransform = eyeLineStack.top();
        return Transform.interpolate(defaultPose, lookDownEyeLineTransform, blendWeight);
    }

    public static void RenderTick() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ShooterContext playerContext = ShooterContext.of((Entity)Minecraft.m_91087_().f_91074_);
            for (AdsInstance instance : ADS_INSTANCES.values()) {
                instance.IsActive = false;
            }
            for (GunContext gunContext : playerContext.GetAllGunContexts()) {
                if (!gunContext.IsValid()) continue;
                for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                    for (ActionInstance action : actionGroup.GetActions()) {
                        ItemDisplayContext itemDisplayContext;
                        if (!(action instanceof AimDownSightAction)) continue;
                        AimDownSightAction adsAction = (AimDownSightAction)action;
                        GunContext gunContext2 = actionGroup.Context.Gun;
                        if (gunContext2 instanceof GunContextPlayer) {
                            GunContextPlayer gunContextPlayer = (GunContextPlayer)gunContext2;
                            itemDisplayContext = MinecraftHelpers.getFirstPersonTransformType(gunContextPlayer.GetHand());
                        } else {
                            itemDisplayContext = ItemDisplayContext.FIXED;
                        }
                        ItemDisplayContext transformType = itemDisplayContext;
                        String key = transformType + "/" + actionGroup.Context.GroupPath;
                        if (!ADS_INSTANCES.containsKey(key)) {
                            AdsInstance newInst = new AdsInstance();
                            newInst.IsActive = true;
                            newInst.BlendAmount = 0.0f;
                            newInst.TransformType = transformType;
                            newInst.EyeLineName = adsAction.EyeLineName();
                            if (actionGroup.Context.IsAttachment()) {
                                newInst.AttachmentType = actionGroup.Context.GetAttachmentType();
                                newInst.AttachmentIndex = actionGroup.Context.GetAttachmentIndex();
                            } else {
                                newInst.AttachmentType = EAttachmentType.Generic;
                                newInst.AttachmentIndex = -1;
                            }
                            ADS_INSTANCES.put(key, newInst);
                            continue;
                        }
                        FirstPersonManager.ADS_INSTANCES.get((Object)key).IsActive = true;
                    }
                }
            }
            ArrayList<String> keys = new ArrayList<String>(ADS_INSTANCES.keySet());
            for (String key : keys) {
                AdsInstance instance = ADS_INSTANCES.get(key);
                instance.BlendAmount = instance.IsActive ? Maths.lerpF(instance.BlendAmount, 1.0f, FlansModClient.FrameDeltaSeconds() * 8.0f) : Maths.lerpF(instance.BlendAmount, 0.0f, FlansModClient.FrameDeltaSeconds() * 10.0f);
                if (!(instance.BlendAmount < 0.01f) || instance.IsActive) continue;
                ADS_INSTANCES.remove(key);
            }
        }
    }

    public static class AdsInstance {
        public ItemDisplayContext TransformType;
        public float BlendAmount;
        public EAttachmentType AttachmentType;
        public int AttachmentIndex;
        public boolean IsActive;
        public String EyeLineName;
    }
}

