/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.bullets;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.bullets.BulletItemRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.GunshotContext;
import com.flansmod.common.item.FlanItem;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class ShotRenderer {
    private ArrayList<ShotRenderInstance> shots = new ArrayList(128);

    private static TextureManager textureManager() {
        return Minecraft.m_91087_().f_90987_;
    }

    public ShotRenderer() {
        MinecraftForge.EVENT_BUS.addListener(this::RenderTick);
        MinecraftForge.EVENT_BUS.addListener(this::ClientTick);
    }

    public int AddLocalPlayerTrail(Vec3 origin, Vec3 endpoint, GunshotContext gunshotContext) {
        GunContext gunContext;
        if (Minecraft.m_91087_().f_91074_ != null && (gunContext = gunshotContext.ActionGroup.Gun) instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            Transform shootOrigin = FirstPersonManager.GetWorldSpaceAPTransform(gunshotContext.ActionGroup.Gun, MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand()), "shoot_origin");
            ShotRenderInstance shot = new ShotRenderInstance(shootOrigin.positionVec3(), endpoint, 0.05f, 10.0f, 10.0f, null, this.GetBulletRenderer(gunshotContext));
            this.shots.add(shot);
            return shot.GetLifetime();
        }
        ShotRenderInstance shot = new ShotRenderInstance(origin, endpoint, 0.05f, 10.0f, 10.0f, null, this.GetBulletRenderer(gunshotContext));
        this.shots.add(shot);
        return shot.GetLifetime();
    }

    @Nullable
    private BulletItemRenderer GetBulletRenderer(GunshotContext gunshotContext) {
        FlanItem flanItem;
        ITurboRenderer itemRenderer;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(gunshotContext.Bullet.Location);
        if (item instanceof FlanItem && (itemRenderer = FlansModelRegistry.GetItemRenderer(flanItem = (FlanItem)item)) instanceof BulletItemRenderer) {
            BulletItemRenderer bulletRenderer = (BulletItemRenderer)itemRenderer;
            return bulletRenderer;
        }
        return null;
    }

    public int AddTrail(Vec3 origin, Vec3 endpoint) {
        ShotRenderInstance shot = new ShotRenderInstance(origin, endpoint, 0.05f, 10.0f, 10.0f, null, null);
        this.shots.add(shot);
        return shot.GetLifetime();
    }

    public int AddTrail(Vec3 origin, Vec3 endpoint, ResourceLocation texture) {
        ShotRenderInstance shot = new ShotRenderInstance(origin, endpoint, 0.05f, 10.0f, 10.0f, texture, null);
        this.shots.add(shot);
        return shot.GetLifetime();
    }

    public void ClientTick(TickEvent.ClientTickEvent event) {
        for (int i = this.shots.size() - 1; i >= 0; --i) {
            this.shots.get(i).Update();
            if (!this.shots.get(i).Finished()) continue;
            this.shots.remove(i);
        }
    }

    public void RenderTick(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            PoseStack poseStack = event.getPoseStack();
            Camera camera = event.getCamera();
            Vec3 pos = camera.m_90583_();
            Tesselator tesselator = Tesselator.m_85913_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            for (ShotRenderInstance shot : this.shots) {
                shot.Render(tesselator, poseStack, pos, event.getPartialTick());
            }
        }
    }

    private static class ShotRenderInstance {
        private final Vec3 origin;
        private final Vec3 endPoint;
        private final float width;
        private final float length;
        @Nullable
        private final ResourceLocation trailTexture;
        @Nullable
        private final BulletItemRenderer bulletModel;
        private final double bulletSpeed;
        private final double distanceToTarget;
        private int ticksExisted = 0;
        private final int lifetime;
        private static final Vector4f WHITE_COLOUR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        private static final Vector4f DEFAULT_TRAIL_COLOUR = new Vector4f(1.0f, 1.0f, 0.5f, 1.0f);

        public int GetLifetime() {
            return this.lifetime;
        }

        public ShotRenderInstance(Vec3 start, Vec3 end, float w, float l, float speed, @Nullable ResourceLocation trail, @Nullable BulletItemRenderer model) {
            this.origin = start;
            this.endPoint = end;
            this.width = w;
            this.length = l;
            this.bulletSpeed = speed;
            this.trailTexture = trail;
            this.distanceToTarget = start.m_82554_(end);
            this.lifetime = this.bulletSpeed <= 1.0E-4 ? 1 : Maths.floor((this.distanceToTarget - (double)this.length) / this.bulletSpeed);
            this.bulletModel = model;
        }

        public boolean Finished() {
            return this.ticksExisted >= this.lifetime;
        }

        public void Update() {
            ++this.ticksExisted;
        }

        public void Render(Tesselator tesselator, PoseStack poseStack, Vec3 cameraPos, float dt) {
            Vector4f colour = WHITE_COLOUR;
            if (this.trailTexture != null) {
                ShotRenderer.textureManager().m_174784_(this.trailTexture);
            } else {
                colour = DEFAULT_TRAIL_COLOUR;
            }
            Vec3 startPos = this.origin;
            double centerT = (double)(this.length * 0.5f) + (double)((float)this.ticksExisted + dt) * this.bulletSpeed;
            Vec3 bulletDirection = this.endPoint.m_82546_(startPos).m_82541_();
            Vec3 centerPos = startPos.m_82549_(bulletDirection.m_82490_(centerT));
            Vec3 cameraToTrailDirection = centerPos.m_82546_(cameraPos).m_82541_();
            Vec3 trailYAxis = bulletDirection.m_82537_(cameraToTrailDirection).m_82541_();
            Vec3 trailXAxis = bulletDirection.m_82490_((double)(this.length * 0.5f));
            Vec3 trailNormal = trailXAxis.m_82537_(trailYAxis).m_82541_();
            trailYAxis = trailYAxis.m_82490_((double)(this.width * 0.5f));
            poseStack.m_85836_();
            poseStack.m_85837_(centerPos.f_82479_ - cameraPos.f_82479_, centerPos.f_82480_ - cameraPos.f_82480_, centerPos.f_82481_ - cameraPos.f_82481_);
            BufferBuilder buf = tesselator.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Vec3 v0 = trailYAxis.m_82549_(trailXAxis);
            Vec3 v1 = trailYAxis.m_82546_(trailXAxis);
            Vec3 v2 = trailYAxis.m_82490_(-1.0).m_82546_(trailXAxis);
            Vec3 v3 = trailYAxis.m_82490_(-1.0).m_82549_(trailXAxis);
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v0.f_82479_, (float)v0.f_82480_, (float)v0.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }

        public void RenderModel(MultiBufferSource buffers, PoseStack pose, Vec3 cameraPos, float dt) {
            if (this.bulletModel != null) {
                Vec3 startPos = this.origin;
                double frontT = (double)this.length + (double)((float)this.ticksExisted + dt) * this.bulletSpeed;
                Vec3 bulletDirection = this.endPoint.m_82546_(startPos).m_82541_();
                Vec3 centerPos = startPos.m_82549_(bulletDirection.m_82490_(frontT));
                pose.m_85836_();
                pose.m_85837_(centerPos.f_82479_ - cameraPos.f_82479_, centerPos.f_82480_ - cameraPos.f_82480_, centerPos.f_82481_ - cameraPos.f_82481_);
                pose.m_252781_(new Quaternionf().lookAlong((float)bulletDirection.f_82481_, (float)bulletDirection.f_82480_, (float)bulletDirection.f_82479_, 0.0f, 1.0f, 0.0f));
                this.bulletModel.renderDirect(null, null, new RenderContext(buffers, ItemDisplayContext.FIXED, pose, 0xFFFFFF, 0));
                pose.m_85849_();
            }
        }
    }
}

