/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.effects;

import com.flansmod.physics.common.util.Maths;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.joml.Quaternionf;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class DecalRenderer {
    private final HashMap<ResourceLocation, DecalLayerInfo> DecalsByTexture = new HashMap();
    private static TextureManager textureManager;
    private static final int MAX_DECALS_PER_TEXTURE = 512;

    public DecalRenderer() {
        textureManager = Minecraft.m_91087_().f_90987_;
        MinecraftForge.EVENT_BUS.addListener(this::RenderTick);
        MinecraftForge.EVENT_BUS.addListener(this::ClientTick);
    }

    public void AddDecal(@Nonnull ResourceLocation texture, @Nonnull Vec3 position, @Nonnull Direction direction, float yaw, int lifetime) {
        this.AddDecal(texture, position, new Vec3((double)direction.m_122436_().m_123341_(), (double)direction.m_122436_().m_123342_(), (double)direction.m_122436_().m_123343_()), yaw, lifetime);
    }

    public void AddDecal(@Nonnull ResourceLocation texture, @Nonnull Vec3 position, @Nonnull Vec3 normal, float yaw, int lifetime) {
        if (!this.DecalsByTexture.containsKey(texture)) {
            this.DecalsByTexture.put(texture, new DecalLayerInfo());
        }
        this.DecalsByTexture.get(texture).AddDecal(position, normal, yaw, lifetime);
    }

    public void AddOrUpdateDecal(@Nonnull ResourceLocation texture, @Nullable UUID uuid, @Nonnull Vec3 position, @Nonnull Vec3 normal, float yaw, int lifetime) {
        if (!this.DecalsByTexture.containsKey(texture)) {
            this.DecalsByTexture.put(texture, new DecalLayerInfo());
        }
        this.DecalsByTexture.get(texture).AddOrUpdateDecal(uuid, position, normal, yaw, lifetime);
    }

    public void AddOrUpdateDecal(@Nonnull ResourceLocation texture, @Nullable UUID uuid, @Nonnull Vec3 position, @Nonnull Vec3 normal, @Nonnull Vector4f colour, float yaw, int lifetime) {
        if (!this.DecalsByTexture.containsKey(texture)) {
            this.DecalsByTexture.put(texture, new DecalLayerInfo());
        }
        this.DecalsByTexture.get(texture).AddOrUpdateDecal(uuid, position, normal, colour, yaw, lifetime);
    }

    public void ClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (DecalLayerInfo list : this.DecalsByTexture.values()) {
                list.ClientTick();
            }
        }
    }

    public void RenderTick(@Nonnull RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            RenderSystem.setShader(GameRenderer::m_172820_);
            for (Map.Entry<ResourceLocation, DecalLayerInfo> kvp : this.DecalsByTexture.entrySet()) {
                if (kvp.getKey() == null || !kvp.getValue().HasAnyDecals()) continue;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)kvp.getKey());
                kvp.getValue().RenderTick(Tesselator.m_85913_(), event.getPoseStack(), event.getCamera().m_90583_(), event.getPartialTick());
            }
        }
    }

    public static class DecalLayerInfo {
        public final ArrayList<DecalInfo> StaticDecals = new ArrayList();
        public final HashMap<UUID, DecalInfo> DynamicDecals = new HashMap();

        public boolean HasAnyDecals() {
            return this.StaticDecals.size() + this.DynamicDecals.size() > 0;
        }

        public void AddDecal(@Nonnull Vec3 position, @Nonnull Vec3 normal, float yaw, int lifetime) {
            if (this.StaticDecals.size() >= 512) {
                this.StaticDecals.remove(0);
            }
            this.StaticDecals.add(new DecalInfo(position, normal, yaw, lifetime));
        }

        public void AddOrUpdateDecal(@Nullable UUID uuid, @Nonnull Vec3 position, @Nonnull Vec3 normal, float yaw, int lifetime) {
            if (uuid != null) {
                this.DynamicDecals.put(uuid, new DecalInfo(position, normal, yaw, lifetime));
            } else {
                this.StaticDecals.add(new DecalInfo(position, normal, yaw, lifetime));
            }
        }

        public void AddOrUpdateDecal(@Nullable UUID uuid, @Nonnull Vec3 position, @Nonnull Vec3 normal, @Nonnull Vector4f colour, float yaw, int lifetime) {
            if (uuid != null) {
                this.DynamicDecals.put(uuid, new DecalInfo(position, normal, colour, yaw, lifetime));
            } else {
                this.StaticDecals.add(new DecalInfo(position, normal, colour, yaw, lifetime));
            }
        }

        public void ClientTick() {
            for (int i = this.StaticDecals.size() - 1; i >= 0; --i) {
                this.StaticDecals.get(i).Update();
                if (!this.StaticDecals.get(i).Finished()) continue;
                this.StaticDecals.remove(i);
            }
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            for (Map.Entry<UUID, DecalInfo> kvp : this.DynamicDecals.entrySet()) {
                kvp.getValue().Update();
                if (!kvp.getValue().Finished()) continue;
                toRemove.add(kvp.getKey());
            }
            for (UUID remove : toRemove) {
                this.DynamicDecals.remove(remove);
            }
        }

        public void RenderTick(@Nonnull Tesselator tesselator, @Nonnull PoseStack poseStack, @Nonnull Vec3 pos, float partialTick) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            for (DecalInfo decal : this.StaticDecals) {
                decal.Render(tesselator, poseStack, pos, partialTick);
            }
            for (DecalInfo decal : this.DynamicDecals.values()) {
                decal.Render(tesselator, poseStack, pos, partialTick);
            }
        }
    }

    public static class DecalInfo {
        @Nonnull
        private final Vec3 Position;
        @Nonnull
        private final Vec3 Normal;
        @Nonnull
        private final Vector4f Colour;
        private final float Yaw;
        private final int Lifetime;
        private int TicksExisted = 0;

        public DecalInfo(@Nonnull Vec3 pos, @Nonnull Vec3 norm, @Nonnull Vector4f colour, float yaw, int life) {
            this.Position = pos;
            this.Normal = norm;
            this.Colour = colour;
            this.Yaw = yaw;
            this.Lifetime = life;
        }

        public DecalInfo(@Nonnull Vec3 pos, @Nonnull Vec3 norm, float yaw, int life) {
            this(pos, norm, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), yaw, life);
        }

        public void Update() {
            ++this.TicksExisted;
        }

        public boolean Finished() {
            return this.TicksExisted >= this.Lifetime;
        }

        public void Render(@Nonnull Tesselator tesselator, @Nonnull PoseStack poseStack, @Nonnull Vec3 cameraPos, float dt) {
            poseStack.m_85836_();
            Vec3 toCamera = Maths.sub(this.Position, cameraPos);
            poseStack.m_85837_(toCamera.f_82479_, toCamera.f_82480_, toCamera.f_82481_);
            poseStack.m_252781_(new Quaternionf().rotateAxis(this.Yaw, (Vector3fc)this.Normal.m_252839_()));
            Vec3 xAxis = Maths.cross(this.Normal, new Vec3(1.0, 0.0, 0.0));
            if (xAxis.m_82556_() < 0.01) {
                xAxis = Maths.cross(this.Normal, new Vec3(0.0, 0.0, 1.0));
            }
            Vec3 yAxis = Maths.cross(xAxis, this.Normal);
            BufferBuilder buf = tesselator.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            xAxis = xAxis.m_82541_().m_82490_(0.25);
            yAxis = yAxis.m_82541_().m_82490_(0.25);
            Vec3 smolNormal = this.Normal.m_82541_().m_82490_(0.001 * toCamera.m_82553_());
            Vec3 v0 = Maths.add(smolNormal, Maths.add(xAxis, yAxis));
            Vec3 v1 = Maths.add(smolNormal, Maths.sub(xAxis, yAxis));
            Vec3 v2 = Maths.add(smolNormal, Maths.sub(xAxis.m_82490_(-1.0), yAxis));
            Vec3 v3 = Maths.add(smolNormal, Maths.add(xAxis.m_82490_(-1.0), yAxis));
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v0.f_82479_, (float)v0.f_82480_, (float)v0.f_82481_).m_7421_(0.0f, 0.0f).m_85950_(this.Colour.x, this.Colour.y, this.Colour.z, this.Colour.w).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_7421_(0.0f, 1.0f).m_85950_(this.Colour.x, this.Colour.y, this.Colour.z, this.Colour.w).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_7421_(1.0f, 1.0f).m_85950_(this.Colour.x, this.Colour.y, this.Colour.z, this.Colour.w).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_7421_(1.0f, 0.0f).m_85950_(this.Colour.x, this.Colour.y, this.Colour.z, this.Colour.w).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
    }
}

