/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.render.models.baked.BakedTurboRig;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;

public class TurboRigWrapper {
    @Nonnull
    public final Supplier<ResourceLocation> modelLocationGetter;
    @Nullable
    public BakedModel bakedRef;
    @Nullable
    public BakedTurboRig bakedTurboRef;

    public TurboRigWrapper(@Nonnull Supplier<ResourceLocation> modelLoc) {
        this.modelLocationGetter = modelLoc;
        this.bakedRef = null;
        this.bakedTurboRef = null;
    }

    private void checkRef() {
        if (this.bakedRef == null) {
            BakedTurboRig turbo = FlansModClient.MODEL_REGISTRATION.getBakedRig(this.modelLocationGetter.get());
            if (turbo != null) {
                this.bakedTurboRef = turbo;
                this.bakedRef = this.bakedTurboRef;
            } else {
                BakedModel missing;
                BakedModel regular = Minecraft.m_91087_().m_91304_().getModel(this.modelLocationGetter.get());
                if (regular != (missing = Minecraft.m_91087_().m_91304_().m_119409_())) {
                    this.bakedRef = regular;
                }
            }
        }
    }

    @Nullable
    public <T> T getOrDefault(@Nonnull Function<BakedTurboRig, T> getFunc, @Nullable T defaultValue) {
        this.checkRef();
        if (this.bakedTurboRef != null) {
            return getFunc.apply(this.bakedTurboRef);
        }
        return defaultValue;
    }

    public void ifRigFound(@Nonnull Consumer<BakedTurboRig> func) {
        this.checkRef();
        if (this.bakedTurboRef != null) {
            func.accept(this.bakedTurboRef);
        }
    }

    public void ifAnyModelFound(@Nonnull Consumer<BakedModel> func) {
        this.checkRef();
        if (this.bakedRef != null) {
            func.accept(this.bakedRef);
        }
    }

    @Nullable
    public <T> T getRigOrOtherwise(@Nonnull Function<BakedTurboRig, T> rigGetFunc, @Nonnull Function<BakedModel, T> backupGetFunc, @Nullable T defaultValue) {
        this.checkRef();
        if (this.bakedTurboRef != null) {
            return rigGetFunc.apply(this.bakedTurboRef);
        }
        if (this.bakedRef != null) {
            return backupGetFunc.apply(this.bakedRef);
        }
        return defaultValue;
    }

    public void ifRigOrOtherwise(@Nonnull Consumer<BakedTurboRig> rigFunc, @Nonnull Consumer<BakedModel> backupFunc) {
        this.checkRef();
        if (this.bakedTurboRef != null) {
            rigFunc.accept(this.bakedTurboRef);
        } else if (this.bakedRef != null) {
            backupFunc.accept(this.bakedRef);
        }
    }
}

