/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.unbaked;

import com.flansmod.client.render.models.ITurboDeserializer;
import com.flansmod.client.render.models.baked.BakedAttachPoint;
import com.flansmod.client.render.models.baked.BakedModelProxy;
import com.flansmod.client.render.models.baked.BakedTurboRig;
import com.flansmod.client.render.models.baked.BakedTurboSection;
import com.flansmod.client.render.models.unbaked.AttachPoint;
import com.flansmod.client.render.models.unbaked.TurboElement;
import com.flansmod.client.render.models.unbaked.TurboFace;
import com.flansmod.client.render.models.unbaked.TurboSection;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.physics.common.util.Transform;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class TurboRig
implements IUnbakedGeometry<TurboRig>,
UnbakedModel {
    public static final Loader LOADER = new Loader();
    public static final ResourceLocation ICON_KEY_3D = new ResourceLocation("flansmod", "3d_icon");
    static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private final Map<String, TurboSection> Parts;
    private final Map<String, ResourceLocation> Textures;
    private final Map<String, ResourceLocation> Icons;
    private final ItemTransforms Transforms;
    private final Map<String, Float> FloatParams;
    private final Map<String, AttachPoint> AttachPoints;
    private final Vector2i TextureSize;

    public TurboRig(@Nonnull Map<String, TurboSection> parts, @Nonnull Map<String, ResourceLocation> textures, @Nonnull Map<String, ResourceLocation> icons, @Nonnull ItemTransforms transforms, @Nonnull Map<String, Float> floatParams, @Nonnull Map<String, AttachPoint> attachPoints, @Nonnull Vector2i textureSize) {
        this.Parts = parts;
        this.Textures = textures;
        this.Icons = icons;
        this.Transforms = transforms;
        this.FloatParams = floatParams;
        this.AttachPoints = attachPoints;
        this.TextureSize = textureSize;
    }

    public Set<Map.Entry<String, AttachPoint>> GetAttachmentPoints() {
        return this.AttachPoints.entrySet();
    }

    public AttachPoint GetAttachPoint(String attachmentName) {
        return this.AttachPoints.getOrDefault(attachmentName, AttachPoint.Invalid);
    }

    public AttachPoint GetAttachPoint(EAttachmentType attachmentType, int index) {
        if (index == 0 && this.AttachPoints.containsKey(attachmentType.name().toLowerCase())) {
            return this.AttachPoints.get(attachmentType.name().toLowerCase());
        }
        if (this.AttachPoints.containsKey(attachmentType.name().toLowerCase() + "_" + index)) {
            return this.AttachPoints.get(attachmentType.name().toLowerCase() + "_" + index);
        }
        return AttachPoint.Invalid;
    }

    public Map<String, Float> GetFloatParams() {
        return this.FloatParams;
    }

    public TurboSection GetPart(String partName) {
        return this.Parts.get(partName);
    }

    public ItemTransform GetTransforms(ItemDisplayContext transformType) {
        return this.Transforms.m_269404_(transformType);
    }

    @Nonnull
    public Collection<ResourceLocation> m_7970_() {
        return Collections.emptyList();
    }

    public void m_5500_(@Nonnull Function<ResourceLocation, UnbakedModel> modelLookup) {
    }

    @Nullable
    public BakedModel m_7611_(@Nonnull ModelBaker p_250133_, @Nonnull Function<Material, TextureAtlasSprite> p_119535_, @Nonnull ModelState p_119536_, @Nonnull ResourceLocation p_119537_) {
        return new BakedModelProxy();
    }

    @Nonnull
    public BakedTurboRig bake(@Nullable IGeometryBakingContext context, @Nonnull ModelBaker baker, @Nonnull Function<Material, TextureAtlasSprite> spriteGetter, @Nonnull ModelState modelState, @Nullable ItemOverrides overrides, @Nonnull ResourceLocation modelLocation) {
        ImmutableMap.Builder iconModels = new ImmutableMap.Builder();
        ImmutableMap.Builder sections = new ImmutableMap.Builder();
        ImmutableMap.Builder attachPoints = new ImmutableMap.Builder();
        for (Map.Entry<String, ResourceLocation> entry : this.Icons.entrySet()) {
            HashMap textureMap = Maps.newHashMap();
            Material material = new Material(TextureAtlas.f_118259_, entry.getValue());
            TextureAtlasSprite sprite = spriteGetter.apply(material);
            List elements = ITEM_MODEL_GENERATOR.m_111638_(0, "default", sprite.m_245424_());
            textureMap.put("default", Either.left((Object)material));
            textureMap.put("particle", Either.left((Object)material));
            BlockModel itemModel = new BlockModel((ResourceLocation)null, elements, (Map)textureMap, Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, List.of());
            iconModels.put((Object)entry.getKey(), (Object)itemModel.m_7611_(baker, spriteGetter, modelState, modelLocation));
        }
        for (Map.Entry<String, Object> entry : this.Parts.entrySet()) {
            sections.put((Object)entry.getKey(), (Object)((TurboSection)entry.getValue()).bake(context, baker, spriteGetter, modelState, overrides, modelLocation, this.TextureSize));
        }
        attachPoints.put((Object)"body", (Object)new BakedAttachPoint(null, Transform.identity()));
        for (Map.Entry<String, Object> entry : this.AttachPoints.entrySet()) {
            attachPoints.put((Object)entry.getKey(), (Object)((AttachPoint)entry.getValue()).bake());
        }
        return new BakedTurboRig((Map<String, BakedModel>)iconModels.build(), (Map<String, BakedTurboSection>)sections.build(), (Map<String, BakedAttachPoint>)attachPoints.build(), this.Textures, this.FloatParams, this.Transforms);
    }

    public static class Loader
    implements IGeometryLoader<TurboRig> {
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter(TurboRig.class, (Object)new Deserializer()).registerTypeAdapter(TurboSection.class, (Object)new TurboSection.Deserializer()).registerTypeAdapter(TurboElement.class, (Object)new TurboElement.Deserializer()).registerTypeAdapter(TurboFace.class, (Object)new TurboFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).create();

        public TurboRig read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return (TurboRig)GSON.fromJson((JsonElement)jsonObject, TurboRig.class);
        }
    }

    public static class Deserializer
    implements JsonDeserializer<TurboRig>,
    ITurboDeserializer {
        public TurboRig deserialize(JsonElement jElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Object kvp4;
            JsonObject jObject = jElement.getAsJsonObject();
            HashMap<String, TurboSection> parts = new HashMap<String, TurboSection>();
            if (jObject.has("parts")) {
                JsonObject jParts = jObject.getAsJsonObject("parts");
                for (Object kvp2 : jParts.entrySet()) {
                    String key = (String)kvp2.getKey();
                    TurboSection model = (TurboSection)context.deserialize((JsonElement)kvp2.getValue(), TurboSection.class);
                    if (model == null) continue;
                    parts.put(key, model);
                }
            }
            HashMap<String, Float> floatParams = new HashMap<String, Float>();
            if (jObject.has("animations")) {
                JsonObject jAnimObject = GsonHelper.m_13930_((JsonObject)jObject, (String)"animations");
                for (Object kvp3 : jAnimObject.entrySet()) {
                    try {
                        floatParams.put((String)kvp3.getKey(), Float.valueOf(((JsonElement)kvp3.getValue()).getAsFloat()));
                    }
                    catch (Exception exception) {
                        try {
                            floatParams.put((String)kvp3.getKey(), Float.valueOf(((JsonElement)kvp3.getValue()).getAsBoolean() ? 1.0f : 0.0f));
                        }
                        catch (Exception exception1) {
                            try {
                                JsonArray jArray = ((JsonElement)kvp3.getValue()).getAsJsonArray();
                                float x = jArray.size() > 0 ? jArray.get(0).getAsFloat() : 0.0f;
                                float y = jArray.size() > 1 ? jArray.get(1).getAsFloat() : 0.0f;
                                float z = jArray.size() > 2 ? jArray.get(2).getAsFloat() : 0.0f;
                                floatParams.put((String)kvp3.getKey() + "_x", Float.valueOf(x));
                                floatParams.put((String)kvp3.getKey() + "_y", Float.valueOf(y));
                                floatParams.put((String)kvp3.getKey() + "_z", Float.valueOf(z));
                            }
                            catch (Exception exception2) {
                                FlansMod.LOGGER.warn("Could not parse " + kvp3.getValue() + " into float anim params");
                            }
                        }
                    }
                }
            }
            HashMap<String, AttachPoint> attachPoints = new HashMap<String, AttachPoint>();
            if (jObject.has("attachPoints")) {
                JsonArray jAPArray = GsonHelper.m_13933_((JsonObject)jObject, (String)"attachPoints");
                for (Object jAPElement : jAPArray.asList()) {
                    JsonObject jAPObject = jAPElement.getAsJsonObject();
                    String name = jAPObject.get("name").getAsString();
                    String attachTo = jAPObject.get("attachTo").getAsString();
                    Vector3f offset = this.getOrDefaultVector3f(jAPObject, "offset", new Vector3f());
                    Vector3f euler = this.getOrDefaultVector3f(jAPObject, "euler", new Vector3f());
                    attachPoints.put(name, new AttachPoint(attachTo, offset, euler));
                }
            }
            HashMap<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
            if (jObject.has("textures")) {
                JsonObject jTextureObject = GsonHelper.m_13930_((JsonObject)jObject, (String)"textures");
                for (Object kvp4 : jTextureObject.entrySet()) {
                    ResourceLocation texLoc = ResourceLocation.m_135820_((String)((JsonElement)kvp4.getValue()).getAsString());
                    texLoc = texLoc.m_247449_("textures/" + texLoc.m_135815_() + ".png");
                    textures.put((String)kvp4.getKey(), texLoc);
                }
            }
            Vector2i textureSize = new Vector2i(16, 16);
            kvp4 = jObject.get("textureSize");
            if (kvp4 instanceof JsonArray) {
                JsonArray jTextureSize = (JsonArray)kvp4;
                textureSize = this.getVector2i(jTextureSize);
            }
            ItemTransforms itemTransforms = ItemTransforms.f_111786_;
            if (jObject.has("display")) {
                JsonObject jDisplayObject = GsonHelper.m_13930_((JsonObject)jObject, (String)"display");
                itemTransforms = (ItemTransforms)context.deserialize((JsonElement)jDisplayObject, ItemTransforms.class);
            }
            HashMap<String, ResourceLocation> iconMap = new HashMap<String, ResourceLocation>();
            if (jObject.has("icons")) {
                JsonObject jIcons = jObject.get("icons").getAsJsonObject();
                for (Map.Entry kvp5 : jIcons.entrySet()) {
                    iconMap.put((String)kvp5.getKey(), new ResourceLocation(((JsonElement)kvp5.getValue()).getAsString()));
                }
            }
            return new TurboRig(parts, textures, iconMap, itemTransforms, floatParams, attachPoints, textureSize);
        }
    }
}

