/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.abilities.AbilityEffectApplyAttribute;
import com.flansmod.common.abilities.AbilityEffectApplyDamage;
import com.flansmod.common.abilities.AbilityEffectApplyDecal;
import com.flansmod.common.abilities.AbilityEffectApplyMobEffect;
import com.flansmod.common.abilities.AbilityEffectBreakBlock;
import com.flansmod.common.abilities.AbilityEffectDamageArmour;
import com.flansmod.common.abilities.AbilityEffectDeleteEntity;
import com.flansmod.common.abilities.AbilityEffectExplode;
import com.flansmod.common.abilities.AbilityEffectFeedEntity;
import com.flansmod.common.abilities.AbilityEffectHealEntity;
import com.flansmod.common.abilities.AbilityEffectKnockback;
import com.flansmod.common.abilities.AbilityEffectNone;
import com.flansmod.common.abilities.AbilityEffectPlaceBlock;
import com.flansmod.common.abilities.AbilityEffectProvideEnchantment;
import com.flansmod.common.abilities.AbilityEffectSetFireToEntity;
import com.flansmod.common.abilities.AbilityEffectSpawnEntity;
import com.flansmod.common.abilities.AbilityEffectStartActionGroup;
import com.flansmod.common.abilities.AbilityEffectSummonNpc;
import com.flansmod.common.abilities.AbilityInstanceApplyModifier;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import javax.annotation.Nonnull;

public class Abilities {
    public static final IAbilityEffect None = new AbilityEffectNone();

    @Nonnull
    public static IAbilityEffect CreateEffectProcessor(@Nonnull AbilityEffectDefinition def) {
        switch (def.effectType) {
            case ApplyDamage: {
                return new AbilityEffectApplyDamage(def);
            }
            case ApplyMobEffect: {
                return new AbilityEffectApplyMobEffect(def);
            }
            case ApplyAttribute: {
                return new AbilityEffectApplyAttribute(def);
            }
            case ApplyModifier: {
                return new AbilityInstanceApplyModifier(def);
            }
            case ApplyEnchantment: {
                return new AbilityEffectProvideEnchantment(def);
            }
            case BreakBlock: {
                return new AbilityEffectBreakBlock(def);
            }
            case PlaceBlock: {
                return new AbilityEffectPlaceBlock(def);
            }
            case SummonNpc: {
                return new AbilityEffectSummonNpc(def);
            }
            case SpawnEntity: {
                return new AbilityEffectSpawnEntity(def);
            }
            case DeleteEntity: {
                return new AbilityEffectDeleteEntity(def);
            }
            case HealEntity: {
                return new AbilityEffectHealEntity(def);
            }
            case FeedEntity: {
                return new AbilityEffectFeedEntity(def);
            }
            case StartActionGroup: {
                return new AbilityEffectStartActionGroup(def);
            }
            case Knockback: {
                return new AbilityEffectKnockback(def);
            }
            case SetFire: {
                return new AbilityEffectSetFireToEntity(def);
            }
            case Explode: {
                return new AbilityEffectExplode(def);
            }
            case ApplyDecal: {
                return new AbilityEffectApplyDecal(def);
            }
            case DamageArmour: {
                return new AbilityEffectDamageArmour(def);
            }
        }
        return None;
    }
}

