/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.stats.StatCalculationContext;
import com.flansmod.common.types.abilities.elements.AbilityStackingDefinition;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;

public class AbilityStack {
    @Nonnull
    public final AbilityStackingDefinition Def;
    public final int Level;
    private int StackCount;
    private int TicksSinceStackedOrDecayed;

    public AbilityStack(@Nonnull AbilityStackingDefinition def, int level) {
        this.Def = def;
        this.Level = level;
        this.StackCount = 0;
        this.TicksSinceStackedOrDecayed = 0;
    }

    public boolean IsActive() {
        return this.StackCount > 0;
    }

    public int GetStackCount() {
        return this.StackCount;
    }

    public float GetDecayTimeSeconds(@Nonnull GunContext gunContext) {
        return this.Def.GetDecayTimeSeconds(StatCalculationContext.of(this.Level, this.StackCount, gunContext));
    }

    public int GetDecayTimeTicks(@Nonnull GunContext gunContext) {
        return this.Def.GetDecayTimeTicks(StatCalculationContext.of(this.Level, this.StackCount, gunContext));
    }

    public void AddStack() {
        this.TicksSinceStackedOrDecayed = 0;
        ++this.StackCount;
        this.StackCount = Maths.clamp(this.StackCount, 0, this.Def.maxStacks);
    }

    public void Tick(@Nonnull GunContext gunContext) {
        gunContext.ModifyFloat("decay_time");
        ++this.TicksSinceStackedOrDecayed;
        if (this.StackCount > 0 && this.TicksSinceStackedOrDecayed >= this.GetDecayTimeTicks(gunContext)) {
            this.Decay();
        }
    }

    public void Decay() {
        this.TicksSinceStackedOrDecayed = 0;
        this.StackCount = this.Def.decayAllAtOnce ? 0 : --this.StackCount;
    }

    public void DecayAll() {
        this.TicksSinceStackedOrDecayed = 0;
        this.StackCount = 0;
    }
}

