/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.nodes.ShootAction;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.ActionGroupDefinition;
import com.flansmod.common.types.guns.elements.ERepeatMode;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class ActionGroupInstance {
    public static final float TICK_RATE = 0.05f;
    public static final int NO_NET_SYNC = -1;
    private static final long TIMEOUT_AUTO_RATIO = 2L;
    private static final long TIMEOUT_AUTO_MIN = 20L;
    private static final long TIMEOUT_AFTER_NO_NETSYNC = 100L;
    private final List<ActionInstance> Actions;
    @Nonnull
    public final ActionGroupContext Context;
    @Nonnull
    public final ActionGroupDefinition Def;
    protected boolean Finished = false;
    protected int Progress = 0;
    protected int Duration = 0;
    protected long StartedTick = -1000L;
    protected int TriggerCount = 0;
    protected long NetSyncTick = -1000L;
    protected int NetSyncedTriggers = 0;
    protected float Charge = 0.0f;
    protected boolean IsCharging = false;
    protected int NumBurstsRemaining = 0;

    private long FullAutoTimeout() {
        return Maths.max((long)this.RepeatDelayTicks() * 2L, 20L);
    }

    public boolean HasStarted() {
        return this.StartedTick >= 0L;
    }

    public long GetStartedTick() {
        return this.StartedTick;
    }

    public long GetTicksSinceStart() {
        return MinecraftHelpers.getTick() - this.StartedTick;
    }

    public boolean HasReceivedNetSync() {
        return this.NetSyncTick >= 0L;
    }

    public long GetLastNetSyncTick() {
        return this.NetSyncTick;
    }

    public long GetTicksSinceLastNetSync() {
        return MinecraftHelpers.getTick() - this.NetSyncTick;
    }

    public int GetProgressTicks() {
        return this.Progress;
    }

    public int GetDurationPerTriggerTicks() {
        return this.Duration;
    }

    public float GetProgressSeconds() {
        return (float)this.Progress * 0.05f;
    }

    public float GetDurationPerTriggerSeconds() {
        return (float)this.Duration * 0.05f;
    }

    public int GetTriggerCount() {
        return this.TriggerCount;
    }

    public ActionGroupInstance(@Nonnull ActionGroupContext context) {
        this.Context = context;
        this.Def = context.Def;
        this.Duration = Maths.floor(this.Def.repeatDelay * 20.0f);
        for (ActionDefinition actionDefinition : this.Def.actions) {
            if (!(actionDefinition.duration * 20.0f > (float)this.Duration)) continue;
            this.Duration = Maths.floor(actionDefinition.duration * 20.0f);
        }
        this.Actions = new ArrayList<ActionInstance>();
    }

    public void AddAction(ActionInstance action) {
        this.Actions.add(action);
    }

    public List<ActionInstance> GetActions() {
        return this.Actions;
    }

    @Nullable
    public ShootAction GetShootAction() {
        for (ActionInstance action : this.Actions) {
            if (!(action instanceof ShootAction)) continue;
            ShootAction shootAction = (ShootAction)action;
            return shootAction;
        }
        return null;
    }

    public void SetStarted() {
        this.Finished = false;
        this.Progress = 0;
        this.StartedTick = 0L;
        Level level = this.Context.Gun.GetLevel();
        if (level != null) {
            this.StartedTick = level.m_6106_().m_6793_();
        }
    }

    public void SetTriggerAuthored(int index) {
        if (index == this.TriggerCount) {
            ++this.TriggerCount;
        } else {
            FlansMod.LOGGER.error("Authoring triggers out of order");
        }
    }

    public void SetTriggerProcessed(int index) {
    }

    public void OnStartClient() {
        if (!this.HasStarted()) {
            this.Finished = false;
            this.Progress = 0;
            this.StartedTick = 0L;
            Level level = this.Context.Gun.GetLevel();
            if (level != null) {
                this.StartedTick = level.m_6106_().m_6793_();
            }
            for (ActionInstance action : this.Actions) {
                action.OnStartClient();
            }
        }
        this.DoInitialTrigger(() -> {
            this.OnTriggerClient(this.TriggerCount);
            ++this.TriggerCount;
            return null;
        });
    }

    public void OnStartClientFromNetwork(long startedTick) {
        this.StartedTick = startedTick;
        for (ActionInstance action : this.Actions) {
            action.OnStartClient();
        }
    }

    public void OnTickClient() {
        ++this.Progress;
        for (ActionInstance action : this.Actions) {
            action.OnTickClient();
        }
        this.CheckRetrigger(() -> {
            this.OnTriggerClient(this.TriggerCount);
            ++this.TriggerCount;
            return null;
        });
    }

    public void OnFinishClient() {
        for (ActionInstance action : this.Actions) {
            action.OnFinishClient();
        }
    }

    private void OnTriggerClient(int triggerIndex) {
        for (ActionInstance action : this.Actions) {
            action.OnTriggerClient(triggerIndex);
        }
    }

    public void OnStartServer(boolean doInitialTrigger) {
        if (!this.HasStarted()) {
            this.Finished = false;
            this.Progress = 0;
            this.StartedTick = 0L;
            Level level = this.Context.Gun.GetLevel();
            if (level != null) {
                this.StartedTick = level.m_6106_().m_6793_();
            }
            for (ActionInstance action : this.Actions) {
                action.OnStartServer();
            }
        }
        if (doInitialTrigger) {
            this.DoInitialTrigger(() -> {
                this.OnTriggerServer(this.TriggerCount);
                ++this.TriggerCount;
                return null;
            });
        }
    }

    public void OnStartServerFromNetwork(long startedTick) {
        this.StartedTick = startedTick;
        for (ActionInstance action : this.Actions) {
            action.OnStartServer();
        }
    }

    public void OnTickServer() {
        ++this.Progress;
        for (ActionInstance action : this.Actions) {
            action.OnTickServer();
        }
        this.CheckRetrigger(() -> {
            this.OnTriggerServer(this.TriggerCount);
            ++this.TriggerCount;
            return null;
        });
    }

    public void OnFinishServer() {
        for (ActionInstance action : this.Actions) {
            action.OnFinishServer();
        }
    }

    private void OnTriggerServer(int triggerIndex) {
        for (ActionInstance action : this.Actions) {
            action.OnTriggerServer(triggerIndex);
        }
    }

    public EActionResult CanStart() {
        if (this.Def.twoHanded && !this.Context.Gun.CanPerformTwoHandedAction()) {
            return EActionResult.TryNextAction;
        }
        if (!this.Def.canActUnderwater && this.Context.Gun.GetShooter().Level().m_46801_(this.Context.Gun.GetShootOrigin().blockPos())) {
            return EActionResult.TryNextAction;
        }
        if (!this.Def.canActUnderOtherLiquid && this.Context.Gun.GetShooter().Level().m_142433_(this.Context.Gun.GetShootOrigin().blockPos(), fluidState -> !fluidState.m_76178_() && !fluidState.m_164512_((Fluid)Fluids.f_76193_))) {
            return EActionResult.TryNextAction;
        }
        EActionResult result = EActionResult.CanProcess;
        for (ActionInstance action : this.Actions) {
            EActionResult actionResult = action.CanStart();
            if (actionResult.ordinal() <= result.ordinal()) continue;
            result = actionResult;
        }
        return result;
    }

    public void SkipTicks(int ticks) {
        for (ActionInstance action : this.Actions) {
            action.SkipTicks(ticks);
        }
        this.Progress += ticks;
    }

    public boolean Finished() {
        if (this.Finished) {
            return true;
        }
        switch (this.RepeatMode()) {
            case Toggle: 
            case FullAuto: 
            case WaitUntilNextAction: {
                return this.Finished;
            }
            case Minigun: {
                return !this.IsCharging && this.Charge <= 0.0f;
            }
            case SemiAuto: 
            case BurstFire: {
                return this.Progress > this.Duration * this.TriggerCount;
            }
        }
        return false;
    }

    public void UpdateInputHeld(boolean held) {
        switch (this.RepeatMode()) {
            case FullAuto: {
                if (held) break;
                this.SetFinished();
                break;
            }
            case Minigun: {
                this.IsCharging = held;
            }
        }
    }

    public void SetFinished() {
        this.Finished = true;
    }

    private void DoInitialTrigger(Supplier<Void> triggerFunc) {
        float repeatDelay = this.RepeatDelaySeconds();
        if (repeatDelay <= 0.0f) {
            triggerFunc.get();
        } else {
            int count = this.Context.Gun.GetActionStack().TryShootMultiple(repeatDelay);
            for (int i = 0; i < count; ++i) {
                triggerFunc.get();
            }
            this.NumBurstsRemaining = this.RepeatMode() == ERepeatMode.BurstFire ? this.RepeatCount() - 1 : 0;
        }
    }

    private void CheckRetrigger(Supplier<Void> triggerFunc) {
        boolean tryRetrigger = false;
        switch (this.RepeatMode()) {
            case FullAuto: {
                tryRetrigger = true;
                break;
            }
            case BurstFire: {
                if (this.NumBurstsRemaining <= 0) break;
                --this.NumBurstsRemaining;
                tryRetrigger = true;
                break;
            }
            case Minigun: {
                this.Charge = this.IsCharging ? (this.Charge += 0.05f) : (this.Charge -= 0.05f);
                if (!(this.Charge >= this.SpinUpDuration())) break;
                tryRetrigger = true;
                this.Charge = this.SpinUpDuration();
            }
        }
        if (tryRetrigger) {
            boolean canRetrigger = true;
            for (ActionInstance action : this.Actions) {
                if (action.CanRetrigger()) continue;
                canRetrigger = false;
            }
            if (canRetrigger) {
                float repeatDelay = this.RepeatDelaySeconds();
                repeatDelay = repeatDelay <= 0.0f ? 0.05f : repeatDelay;
                int count = this.Context.Gun.GetActionStack().TryShootMultiple(repeatDelay);
                for (int i = 0; i < count; ++i) {
                    triggerFunc.get();
                }
            }
        }
    }

    public int GetRequiredNetSyncMin() {
        if (this.NetSyncedTriggers < this.TriggerCount) {
            return this.NetSyncedTriggers;
        }
        return -1;
    }

    public int GetRequiredNetSyncMax() {
        if (this.NetSyncedTriggers < this.TriggerCount) {
            return this.TriggerCount - 1;
        }
        return -1;
    }

    public boolean NeedsNetSync() {
        return this.NetSyncedTriggers != this.TriggerCount;
    }

    public void OnPerformedNetSync(int triggerMin, int triggerMax) {
        if (triggerMin != this.GetRequiredNetSyncMin() || triggerMax != this.GetRequiredNetSyncMax()) {
            FlansMod.LOGGER.warn("Action was NetSynced, but not for the required range");
        }
        this.NetSyncedTriggers = triggerMax + 1;
        this.NetSyncTick = MinecraftHelpers.getTick();
    }

    public void CheckTimeout() {
        if (this.HasStarted()) {
            switch (this.RepeatMode()) {
                case FullAuto: 
                case Minigun: {
                    if (this.HasReceivedNetSync()) {
                        if (this.GetTicksSinceLastNetSync() <= this.FullAutoTimeout()) break;
                        FlansMod.LOGGER.warn(this.Context + " timed out [" + MinecraftHelpers.getTick() + "] after " + this.FullAutoTimeout() + " ticks because it stopped receiving NetSyncs");
                        this.SetFinished();
                        break;
                    }
                    if (this.GetTicksSinceStart() < 100L) break;
                    FlansMod.LOGGER.warn(this.Context + " timed out [" + MinecraftHelpers.getTick() + "] after 100 ticks because it was never given a NetSync");
                    this.SetFinished();
                }
            }
        }
    }

    public boolean PropogateToServer() {
        for (ActionInstance action : this.Actions) {
            if (!action.PropogateToServer() && this.Context.Gun.GetReloadDefinitionContaining(this.Context) == null) continue;
            return true;
        }
        return false;
    }

    public boolean ShouldFallBackToReload() {
        for (ActionInstance action : this.Actions) {
            if (!action.ShouldFallBackToReload()) continue;
            return true;
        }
        return false;
    }

    public double GetPropogationRadius() {
        double furthest = 0.0;
        for (ActionInstance action : this.Actions) {
            double radius = action.GetPropogationRadius();
            if (!(radius > furthest)) continue;
            furthest = radius;
        }
        return furthest;
    }

    public void AddExtraPositionsForNetSync(int triggerIndex, List<Vec3> positions) {
        for (ActionInstance action : this.Actions) {
            action.AddExtraPositionsForNetSync(triggerIndex, positions);
        }
    }

    public boolean ShouldAddPlayerPosForNetSync() {
        if (!this.Context.Gun.GetShooter().IsValid()) {
            return false;
        }
        for (ActionInstance action : this.Actions) {
            if (action.ShouldNetSyncAroundPlayer()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ERepeatMode RepeatMode() {
        return this.Context.RepeatMode();
    }

    public int RepeatCount() {
        return this.Context.RepeatCount();
    }

    public float RepeatDelaySeconds() {
        return this.Context.RepeatDelaySeconds();
    }

    public int RepeatDelayTicks() {
        return this.Context.RepeatDelayTicks();
    }

    public float SpinUpDuration() {
        return this.Context.SpinUpDuration();
    }
}

