/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions;

import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.gunshots.GunshotCollection;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public abstract class ActionInstance {
    public static final float TICK_RATE = 0.05f;
    @Nonnull
    public final ActionGroupInstance Group;
    @Nonnull
    public final ActionDefinition Def;

    public boolean Finished() {
        return this.Group.Finished;
    }

    public float GetCharge() {
        return this.Group.Charge;
    }

    public boolean IsCharging() {
        return this.Group.IsCharging;
    }

    public int GetProgressTicks() {
        return this.Group.Progress;
    }

    public float GetProgressSeconds() {
        return (float)this.Group.Progress * 0.05f;
    }

    public int GetDurationPerTriggerTicks() {
        return this.Group.Duration;
    }

    public float GetDurationPerTriggerSeconds() {
        return (float)this.Group.Duration * 0.05f;
    }

    public int GetDurationTotalTicks() {
        return this.Group.Duration * this.Group.TriggerCount;
    }

    public float GetDurationTotalSeconds() {
        return (float)(this.Group.Duration * this.Group.TriggerCount) * 0.05f;
    }

    public int GetTriggerCount() {
        return this.Group.TriggerCount;
    }

    public int GetNumBurstsRemaining() {
        return this.Group.NumBurstsRemaining;
    }

    public ActionInstance(@Nonnull ActionGroupInstance group, @Nonnull ActionDefinition def) {
        this.Group = group;
        this.Def = def;
    }

    public boolean ShouldRender(GunContext context) {
        return true;
    }

    public boolean PropogateToServer() {
        return true;
    }

    public boolean ShouldFallBackToReload() {
        return false;
    }

    public EActionResult CanStart() {
        return EActionResult.CanProcess;
    }

    public boolean CanRetrigger() {
        return true;
    }

    public abstract void OnTriggerClient(int var1);

    public abstract void OnTriggerServer(int var1);

    public void OnStartServer() {
    }

    public void OnTickServer() {
    }

    public void OnFinishServer() {
    }

    public void OnStartClient() {
    }

    public void OnTickClient() {
    }

    public void OnFinishClient() {
    }

    public void SkipTicks(int ticks) {
    }

    public double GetPropogationRadius() {
        return 200.0;
    }

    public void AddExtraPositionsForNetSync(int triggerIndex, List<Vec3> positions) {
    }

    public boolean ShouldNetSyncAroundPlayer() {
        return true;
    }

    @Nonnull
    public NetData GetNetDataForTrigger(int triggerIndex) {
        return NetData.Invalid;
    }

    public void UpdateFromNetData(NetData netData, int triggerIndex) {
    }

    public boolean VerifyServer(GunshotCollection shots) {
        return true;
    }

    public float GetFloat(@Nonnull String stat) {
        return this.Group.Context.ModifyFloat(stat).get();
    }

    public float ModifyFloat(@Nonnull String stat, float defaultValue) {
        return this.Group.Context.ModifyFloat(stat).apply(defaultValue);
    }

    @Nonnull
    public String ModifyString(@Nonnull String stat, @Nonnull String defaultValue) {
        return this.Group.Context.ModifyString(stat, defaultValue);
    }

    public float Duration() {
        return this.ModifyFloat("duration", this.Def.duration);
    }

    public float ToolLevel() {
        return this.GetFloat("tool_level");
    }

    public float HarvestSpeed() {
        return this.GetFloat("harvest_speed");
    }

    public float Reach() {
        return this.GetFloat("reach");
    }

    public static abstract class NetData {
        public static final int INVALID_ID = -1;
        public static final NetData Invalid = new NetData(){

            @Override
            public int GetID() {
                return -1;
            }

            @Override
            public void Encode(FriendlyByteBuf buf) {
            }

            @Override
            public void Decode(FriendlyByteBuf buf) {
            }
        };

        public abstract int GetID();

        public abstract void Encode(FriendlyByteBuf var1);

        public abstract void Decode(FriendlyByteBuf var1);
    }
}

