/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunInputContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.common.types.guns.elements.ERepeatMode;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;

public abstract class ActionManager {
    protected final boolean IsClient;
    protected HashMap<UUID, ActionStack> ActionStacks = new HashMap();

    public ActionManager(boolean client) {
        this.IsClient = client;
    }

    public void Clear() {
        this.ActionStacks.clear();
    }

    public void ClearGun(@Nonnull UUID gunID) {
        this.ActionStacks.remove(gunID);
    }

    @Nonnull
    public ActionStack GetActionStack(GunContext context) {
        return this.GetActionStack(context.GetUUID());
    }

    @Nonnull
    public ActionStack GetActionStack(UUID gunID) {
        if (gunID.equals(FlanItem.InvalidGunUUID)) {
            FlansMod.LOGGER.warn("Tried to get action stack for invalid context");
            return ActionStack.Invalid;
        }
        ActionStack entitysActionStack = this.ActionStacks.get(gunID);
        if (entitysActionStack == null) {
            entitysActionStack = new ActionStack(this.IsClient);
            this.ActionStacks.put(gunID, entitysActionStack);
        }
        return entitysActionStack;
    }

    @Nonnull
    public static ActionStack SafeGetActionStack(GunContext context) {
        Level level = context.GetLevel();
        if (level != null) {
            if (level.f_46443_) {
                return FlansModClient.ACTIONS_CLIENT.GetActionStack(context);
            }
            return FlansMod.ACTIONS_SERVER.GetActionStack(context);
        }
        FlansMod.LOGGER.warn("Could not get ActionStack for GunContext " + context.toString());
        return ActionStack.Invalid;
    }

    @Nonnull
    protected abstract EActionResult TryStartGroupInstance(@Nonnull ActionStack var1, @Nonnull ActionGroupContext var2);

    @Nonnull
    protected abstract EActionResult TryUpdateGroupInstanceHeld(@Nonnull ActionStack var1, @Nonnull ActionGroupContext var2);

    @Nonnull
    protected abstract EActionResult TryUpdateGroupInstanceNotHeld(@Nonnull ActionStack var1, @Nonnull ActionGroupContext var2);

    public void KeyPressed(@Nonnull ShooterContext shooter, @Nonnull EPlayerInput inputType) {
        if (!shooter.IsValid()) {
            return;
        }
        for (GunContext gunContext : shooter.GetAllGunContexts()) {
            if (!gunContext.IsValid()) continue;
            ActionStack actionStack = gunContext.GetActionStack();
            GunInputContext inputContext = GunInputContext.CreateFrom(gunContext, inputType);
            this.IteratePossibleActionGroups(inputContext, actionStack, this::TryStartGroupInstance);
        }
    }

    public void KeyHeld(@Nonnull ShooterContext shooter, @Nonnull EPlayerInput inputType) {
        if (!shooter.IsValid()) {
            return;
        }
        for (GunContext gunContext : shooter.GetAllGunContexts()) {
            if (!gunContext.IsValid()) continue;
            ActionStack actionStack = gunContext.GetActionStack();
            GunInputContext inputContext = GunInputContext.CreateFrom(gunContext, inputType);
            this.IterateActionGroupsThatRespondToHeld(inputContext, actionStack, this::TryUpdateGroupInstanceHeld);
        }
    }

    public void KeyReleased(@Nonnull ShooterContext shooter, @Nonnull EPlayerInput inputType, int ticksSinceHeld) {
        if (!shooter.IsValid()) {
            return;
        }
        for (GunContext gunContext : shooter.GetAllGunContexts()) {
            if (!gunContext.IsValid()) continue;
            ActionStack actionStack = gunContext.GetActionStack();
            GunInputContext inputContext = GunInputContext.CreateFrom(gunContext, inputType);
            this.IterateActiveActionGroups(inputContext, actionStack, this::TryUpdateGroupInstanceNotHeld);
        }
    }

    protected void IteratePossibleActionGroups(@Nonnull GunInputContext inputContext, @Nonnull ActionStack actionStack, @Nonnull BiFunction<ActionStack, ActionGroupContext, EActionResult> func) {
        List<Pair<ActionGroupContext, Boolean>> actionGroups = inputContext.Gun.EvaluateInputHandler(inputContext);
        for (Pair<ActionGroupContext, Boolean> kvp : actionGroups) {
            ActionGroupInstance groupInstance = actionStack.GetOrCreateGroupInstance((ActionGroupContext)kvp.getFirst());
            EActionResult funcResult = func.apply(actionStack, (ActionGroupContext)kvp.getFirst());
            boolean keepEvaluating = true;
            switch (funcResult) {
                case CanProcess: {
                    keepEvaluating = (Boolean)kvp.getSecond();
                    break;
                }
                case TryNextAction: {
                    actionStack.CancelGroupInstance((ActionGroupContext)kvp.getFirst());
                    break;
                }
                case Wait: {
                    actionStack.CancelGroupInstance((ActionGroupContext)kvp.getFirst());
                    keepEvaluating = false;
                }
            }
            if (keepEvaluating) continue;
            return;
        }
    }

    protected void IterateActionGroupsThatRespondToHeld(@Nonnull GunInputContext inputContext, @Nonnull ActionStack actionStack, @Nonnull BiFunction<ActionStack, ActionGroupContext, EActionResult> func) {
        this.IterateActiveActionGroups(inputContext, actionStack, func);
        this.IteratePossibleActionGroups(inputContext, actionStack, (actionStackInner, possibleActionGroup) -> {
            EActionResult baseResult = (EActionResult)((Object)((Object)func.apply((ActionStack)actionStackInner, (ActionGroupContext)possibleActionGroup)));
            if (baseResult == EActionResult.CanProcess) {
                if (possibleActionGroup.RepeatMode() == ERepeatMode.FullAuto || possibleActionGroup.RepeatMode() == ERepeatMode.Minigun) {
                    return EActionResult.CanProcess;
                }
                return EActionResult.TryNextAction;
            }
            return baseResult;
        });
    }

    protected void IterateActiveActionGroups(@Nonnull GunInputContext inputContext, @Nonnull ActionStack actionStack, @Nonnull BiFunction<ActionStack, ActionGroupContext, EActionResult> func) {
        List<Pair<ActionGroupContext, Boolean>> actionGroups = inputContext.Gun.EvaluateInputHandler(inputContext);
        for (Pair<ActionGroupContext, Boolean> kvp : actionGroups) {
            ActionGroupInstance groupInstance = actionStack.TryGetGroupInstance((ActionGroupContext)kvp.getFirst());
            if (groupInstance == null) continue;
            func.apply(actionStack, (ActionGroupContext)kvp.getFirst());
        }
    }
}

