/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.common.FlansMod;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.Actions;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.gunshots.EPressType;
import com.flansmod.common.network.FlansModPacketHandler;
import com.flansmod.common.network.bidirectional.ActionUpdateMessage;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.common.types.abilities.elements.AbilityStackingDefinition;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.EReloadStage;
import com.flansmod.common.types.guns.elements.ERepeatMode;
import com.flansmod.common.types.guns.elements.ReloadDefinition;
import com.flansmod.common.types.magazines.EAmmoLoadMode;
import com.flansmod.physics.common.util.Maths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ActionStack {
    public static final ActionStack Invalid = new ActionStack(false){

        @Override
        public void OnTick(Level level, GunContext gunContext) {
        }

        @Override
        public void EvaluateTrigger(@Nonnull EAbilityTrigger triggerType, @Nonnull GunContext gunContext, @Nullable ActionGroupContext actionGroupContext, @Nonnull TriggerContext triggerContext) {
        }

        @Override
        public boolean IsValid() {
            return false;
        }
    };
    private final List<ActionGroupInstance> ActiveActionGroups = new ArrayList<ActionGroupInstance>();
    private final Map<String, AbilityStack> AbilityStacks = new HashMap<String, AbilityStack>();
    private float ShotCooldown = 0.0f;
    private boolean cancelActionRequested = false;
    public final boolean IsClient;
    public boolean IsEquipped = false;
    private static int LOOP_CHECK = 0;
    private static final int LOOP_MAX = 4;

    public ActionStack(boolean client) {
        this.IsClient = client;
    }

    public int TryShootMultiple(float timeBetweenShotsInSeconds) {
        int shotCount = 0;
        while (this.ShotCooldown < 1.0f) {
            ++shotCount;
            this.ShotCooldown += timeBetweenShotsInSeconds * 20.0f;
        }
        return shotCount;
    }

    public float GetShotCooldown() {
        return this.ShotCooldown;
    }

    public List<ActionGroupInstance> GetActiveActionGroups() {
        return this.ActiveActionGroups;
    }

    public void RequestCancel() {
        this.cancelActionRequested = true;
    }

    public boolean IsValid() {
        return true;
    }

    public boolean IsActionGroupActive(ActionGroupContext groupContext) {
        for (ActionGroupInstance instance : this.ActiveActionGroups) {
            if (!instance.Def.key.equals(groupContext.Def.key)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private ActionGroupInstance CreateGroupInstance(ActionGroupContext groupContext) {
        ActionGroupInstance groupInstance = new ActionGroupInstance(groupContext);
        for (ActionDefinition actionDef : groupContext.Def.actions) {
            ActionInstance actionInstance = Actions.InstanceAction(groupInstance, actionDef);
            if (actionInstance == null) continue;
            groupInstance.AddAction(actionInstance);
        }
        this.ActiveActionGroups.add(groupInstance);
        return groupInstance;
    }

    @Nullable
    public ActionGroupInstance TryGetGroupInstance(ActionGroupContext groupContext) {
        for (ActionGroupInstance instance : this.ActiveActionGroups) {
            if (!instance.Def.key.equals(groupContext.Def.key)) continue;
            return instance;
        }
        return null;
    }

    @Nonnull
    public ActionGroupInstance GetOrCreateGroupInstance(ActionGroupContext groupContext) {
        ActionGroupInstance instance = this.TryGetGroupInstance(groupContext);
        if (instance == null) {
            instance = this.CreateGroupInstance(groupContext);
        }
        return instance;
    }

    private EActionResult TryStartGroupInstance(ActionGroupContext groupContext, boolean doInitialTrigger) {
        Object stage;
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance == null) {
            return EActionResult.TryNextAction;
        }
        EActionResult result = groupInstance.CanStart();
        ReloadDefinition reload = groupContext.Gun.GetReloadDefinitionContaining(groupContext);
        if (reload != null && (stage = reload.GetStage(groupContext.GroupPath)) == EReloadStage.Start && !groupContext.CanPerformReloadFromAttachedInventory(0)) {
            result = EActionResult.TryNextAction;
        }
        if (result == EActionResult.CanProcess) {
            if (groupContext.RepeatMode() == ERepeatMode.Toggle && groupInstance.HasStarted()) {
                groupInstance.SetFinished();
                return result;
            }
            for (ActionGroupInstance existingGroup : this.ActiveActionGroups) {
                if (existingGroup.RepeatMode() != ERepeatMode.WaitUntilNextAction) continue;
                existingGroup.SetFinished();
            }
            if (this.IsClient) {
                groupInstance.OnStartClient();
            } else {
                groupInstance.OnStartServer(doInitialTrigger);
            }
            this.OnActionGroupStarted(groupContext);
            this.EvaluateTrigger(EAbilityTrigger.StartActionGroup, groupContext, TriggerContext.self(groupContext));
            if (reload != null) {
                stage = reload.GetStage(groupContext.GroupPath);
                this.EvaluateTrigger(EAbilityTrigger.FromReloadStage(stage), groupContext, TriggerContext.self(groupContext));
            }
        }
        return result;
    }

    @Nonnull
    private EActionResult TryUpdateInputHeld(@Nonnull ActionGroupContext groupContext, boolean held) {
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance == null) {
            return EActionResult.TryNextAction;
        }
        groupInstance.UpdateInputHeld(held);
        return EActionResult.CanProcess;
    }

    public void CancelGroupInstance(@Nonnull ActionGroupContext context) {
        this.StopActionGroup(context);
    }

    public void UpdateEquipped(@Nonnull GunContext gunContext, boolean isEquipped) {
        if (isEquipped && !this.IsEquipped) {
            this.EvaluateTrigger(EAbilityTrigger.Equip, gunContext, TriggerContext.self(gunContext));
        } else if (!isEquipped && this.IsEquipped) {
            this.EvaluateTrigger(EAbilityTrigger.Unequip, gunContext, TriggerContext.self(gunContext));
        }
        this.IsEquipped = isEquipped;
    }

    private void TickActions() {
        for (int i = this.ActiveActionGroups.size() - 1; i >= 0; --i) {
            ActionGroupInstance actionGroup = this.ActiveActionGroups.get(i);
            if (actionGroup.HasStarted()) {
                if (this.IsClient) {
                    actionGroup.OnTickClient();
                    if (!actionGroup.Context.Gun.GetShooter().IsLocalPlayerOwner()) {
                        actionGroup.CheckTimeout();
                    }
                } else {
                    actionGroup.OnTickServer();
                }
            } else {
                FlansMod.LOGGER.error("Action " + this.ActiveActionGroups.get((int)i).Def.key + " was left in the system without being started");
                this.StopActionGroup(actionGroup.Context);
            }
            if (!actionGroup.Finished()) continue;
            this.StopActionGroup(actionGroup.Context);
        }
    }

    private void StopActionGroup(ActionGroupContext groupContext) {
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance != null) {
            boolean stillFinished = true;
            if (groupInstance.HasStarted()) {
                this.OnActionGroupFinished(groupContext);
                stillFinished = groupInstance.Finished();
            }
            if (stillFinished) {
                this.EvaluateTrigger(EAbilityTrigger.EndActionGroup, groupContext, TriggerContext.self(groupContext));
                if (this.IsClient) {
                    groupInstance.OnFinishClient();
                } else {
                    groupInstance.OnFinishServer();
                }
                for (int i = this.ActiveActionGroups.size() - 1; i >= 0; --i) {
                    if (!this.ActiveActionGroups.get((int)i).Def.key.equals(groupContext.Def.key)) continue;
                    this.ActiveActionGroups.remove(i);
                }
                this.DebugLog("StopActionGroup called on " + groupContext.GroupPath);
            } else {
                this.DebugLog("StopActionGroup retriggered itself, not removing " + groupContext.GroupPath);
            }
        }
    }

    private void OnActionGroupStarted(ActionGroupContext groupContext) {
        EReloadStage stage;
        ReloadDefinition reload = groupContext.Gun.GetReloadDefinitionContaining(groupContext);
        if (reload != null && (stage = reload.GetStage(groupContext.GroupPath)) == EReloadStage.Start) {
            this.OnStartReload(groupContext, 0);
        }
    }

    private void OnActionGroupFinished(ActionGroupContext groupContext) {
        ReloadDefinition reload = groupContext.Gun.GetReloadDefinitionContaining(groupContext);
        if (reload != null) {
            EReloadStage endedStage = reload.GetStage(groupContext.GroupPath);
            EReloadStage nextStage = null;
            if (this.cancelActionRequested && endedStage != EReloadStage.End) {
                this.cancelActionRequested = false;
                if (!reload.endActionKey.isEmpty()) {
                    nextStage = EReloadStage.End;
                }
            } else {
                switch (endedStage) {
                    case Start: {
                        if (!reload.ejectActionKey.isEmpty()) {
                            nextStage = EReloadStage.Eject;
                            break;
                        }
                        if (!reload.loadOneActionKey.isEmpty()) {
                            nextStage = EReloadStage.LoadOne;
                            break;
                        }
                        if (reload.endActionKey.isEmpty()) break;
                        nextStage = EReloadStage.End;
                        break;
                    }
                    case Eject: 
                    case LoadOne: {
                        if (this.CanReloadOne(groupContext, 0) && !reload.loadOneActionKey.isEmpty()) {
                            nextStage = EReloadStage.LoadOne;
                            break;
                        }
                        if (reload.endActionKey.isEmpty()) break;
                        nextStage = EReloadStage.End;
                    }
                }
            }
            if (nextStage != null) {
                this.EnterReloadState(reload, nextStage, groupContext);
            }
        }
    }

    private void EnterReloadState(ReloadDefinition reload, EReloadStage reloadStage, ActionGroupContext triggeringActionGroup) {
        this.DebugLog("EnterReloadState - " + reloadStage + " in " + reload.key);
        ActionGroupContext newGroupContext = triggeringActionGroup.Gun.GetActionGroupContextSibling(triggeringActionGroup, reload.GetReloadActionKey(reloadStage));
        ActionGroupInstance groupInstance = this.GetOrCreateGroupInstance(newGroupContext);
        this.TryStartGroupInstance(newGroupContext, true);
        if (reloadStage == EReloadStage.LoadOne) {
            newGroupContext.LoadOne(0, newGroupContext.Gun.GetAttachedInventory());
        }
    }

    public boolean IsReloading() {
        for (ActionGroupInstance activeGroup : this.ActiveActionGroups) {
            if (activeGroup.Context.Gun.GetReloadDefinitionContaining(activeGroup.Context) == null || !activeGroup.HasStarted()) continue;
            return true;
        }
        return false;
    }

    public void OnStartReload(ActionGroupContext groupContext, int magIndex) {
        if (this.IsClient && groupContext.Gun.GetShooter().IsLocalPlayerOwner()) {
            this.Client_LocalPlayerStartReload(groupContext, magIndex);
        }
    }

    private void Client_LocalPlayerStartReload(ActionGroupContext groupContext, int magIndex) {
        if (groupContext.CanPerformReloadFromAttachedInventory(magIndex)) {
            int bulletsInMag = groupContext.GetNumBulletsInMag(magIndex);
            int magSize = groupContext.GetMagazineSize(magIndex);
            if (groupContext.GetMagazineType((int)magIndex).ammoLoadMode == EAmmoLoadMode.FullMag) {
                FirstPersonManager.LocalPlayerStartReload(1);
            } else {
                FirstPersonManager.LocalPlayerStartReload(magSize - bulletsInMag);
            }
        }
    }

    public boolean CanReloadOne(ActionGroupContext groupContext, int magIndex) {
        if (this.IsClient && groupContext.Gun.GetShooter().IsLocalPlayerOwner()) {
            return this.Client_LocalPlayerCanReloadOne(groupContext);
        }
        return groupContext.CanPerformReloadFromAttachedInventory(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean Client_LocalPlayerCanReloadOne(ActionGroupContext groupContext) {
        return FirstPersonManager.ConsumeLoadOne();
    }

    public void OnTick(@Nullable Level level, @Nonnull GunContext gunContext) {
        if (level == null) {
            return;
        }
        this.ShotCooldown -= 1.0f;
        if (this.ShotCooldown < 0.0f) {
            this.ShotCooldown = 0.0f;
        }
        this.TickActions();
        this.TickAbilities(gunContext);
    }

    protected void DebugLog(@Nonnull String string) {
    }

    public void Clear(@Nonnull GunContext gunContext) {
        for (ActionGroupInstance actionGroup : this.ActiveActionGroups) {
            actionGroup.SetFinished();
        }
        this.ActiveActionGroups.clear();
        for (AbilityStack stacks : this.AbilityStacks.values()) {
            stacks.DecayAll();
        }
        this.AbilityStacks.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public EActionResult Client_TryStartGroupInstance(ActionGroupContext groupContext) {
        if (!this.IsClient) {
            FlansMod.LOGGER.error("Called Client function on server in ActionStack!");
            return EActionResult.TryNextAction;
        }
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance == null) {
            return EActionResult.TryNextAction;
        }
        EActionResult result = this.TryStartGroupInstance(groupContext, true);
        if (result == EActionResult.CanProcess && (groupInstance.PropogateToServer() || groupInstance.NeedsNetSync())) {
            ActionUpdateMessage updateMsg = new ActionUpdateMessage(groupContext, EPressType.Press, groupInstance.GetStartedTick());
            updateMsg.AddTriggers(groupInstance, groupInstance.GetRequiredNetSyncMin(), groupInstance.GetRequiredNetSyncMax());
            FlansModPacketHandler.SendToServer(new ActionUpdateMessage.ToServer(updateMsg));
            groupInstance.OnPerformedNetSync(groupInstance.GetRequiredNetSyncMin(), groupInstance.GetRequiredNetSyncMax());
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public EActionResult Client_TryUpdateGroupInstanceHeld(@Nonnull ActionGroupContext groupContext) {
        return this.Client_TryUpdateGroupInstance(groupContext, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public EActionResult Client_TryUpdateGroupInstanceNotHeld(@Nonnull ActionGroupContext groupContext) {
        return this.Client_TryUpdateGroupInstance(groupContext, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public EActionResult Client_TryUpdateGroupInstance(@Nonnull ActionGroupContext groupContext, boolean held) {
        if (!this.IsClient) {
            FlansMod.LOGGER.error("Called Client function on server in ActionStack!");
            return EActionResult.TryNextAction;
        }
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance == null || !groupInstance.HasStarted() && groupInstance.RepeatMode() == ERepeatMode.FullAuto) {
            if (held) {
                return this.Client_TryStartGroupInstance(groupContext);
            }
            return EActionResult.TryNextAction;
        }
        EActionResult result = this.TryUpdateInputHeld(groupContext, held);
        if (result == EActionResult.CanProcess && (groupInstance.NeedsNetSync() || !held)) {
            ActionUpdateMessage updateMsg = new ActionUpdateMessage(groupContext, held ? EPressType.Hold : EPressType.Release, groupInstance.GetStartedTick());
            updateMsg.AddTriggers(groupInstance, groupInstance.GetRequiredNetSyncMin(), groupInstance.GetRequiredNetSyncMax());
            FlansModPacketHandler.SendToServer(new ActionUpdateMessage.ToServer(updateMsg));
            groupInstance.OnPerformedNetSync(groupInstance.GetRequiredNetSyncMin(), groupInstance.GetRequiredNetSyncMax());
        }
        return result;
    }

    @Nonnull
    public EActionResult Server_TryHandleMessage(@Nonnull ActionUpdateMessage.ToServer msg, @Nonnull ServerPlayer from) {
        if (this.IsClient) {
            FlansMod.LOGGER.error("Called Server function on client in ActionStack!");
            return EActionResult.TryNextAction;
        }
        ActionGroupContext groupContext = msg.Data.GetActionGroupContext(false);
        if (!groupContext.IsValid()) {
            FlansMod.LOGGER.warn("OnServerReceivedActionUpdate had invalid action");
            return EActionResult.TryNextAction;
        }
        if (!groupContext.Gun.GetShooter().IsValid()) {
            FlansMod.LOGGER.warn("OnServerReceivedActionUpdate had invalid shooter");
            return EActionResult.TryNextAction;
        }
        EActionResult startResult = EActionResult.CanProcess;
        ActionGroupInstance groupInstance = this.GetOrCreateGroupInstance(groupContext);
        if (!groupInstance.HasStarted()) {
            if (msg.Data.GetPressType() != EPressType.Press) {
                FlansMod.LOGGER.warn("Received ActionUpdateMessage with wrong press type for action that was not already running");
            }
            startResult = this.TryStartGroupInstance(groupContext, false);
        }
        if (startResult == EActionResult.CanProcess) {
            for (Map.Entry<Integer, ActionUpdateMessage.ActionTriggerInfo> kvp : msg.Data.GetTriggers()) {
                int serverTriggerCount;
                int triggerIndex = kvp.getKey();
                if (triggerIndex >= groupInstance.TriggerCount + 30) continue;
                int actionIndex = 0;
                for (ActionInstance action : groupInstance.GetActions()) {
                    if (!action.VerifyServer(null)) {
                        startResult = EActionResult.Wait;
                    }
                    ActionInstance.NetData netData = msg.Data.GetNetData(triggerIndex, actionIndex);
                    action.UpdateFromNetData(netData, triggerIndex);
                    ++actionIndex;
                }
                while (groupInstance.TriggerCount <= triggerIndex) {
                    for (ActionInstance action : groupInstance.GetActions()) {
                        action.OnTriggerServer(triggerIndex);
                    }
                    ++groupInstance.TriggerCount;
                }
                if (msg.Data.GetPressType() != EPressType.Release) continue;
                long numTicks = msg.Data.GetLastTriggerTick() - groupInstance.GetStartedTick();
                int expectedTriggerCount = Maths.floor(numTicks / (long)groupContext.RepeatDelayTicks()) + 1;
                if (expectedTriggerCount > (serverTriggerCount = groupInstance.GetTriggerCount()) + 1) {
                    FlansMod.LOGGER.info("Client expected to trigger " + expectedTriggerCount + " repeat(s), but server only triggered " + serverTriggerCount + " repeat(s)");
                } else if (expectedTriggerCount < serverTriggerCount - 1) {
                    FlansMod.LOGGER.info("Client expected to trigger " + expectedTriggerCount + " repeat(s), but server triggered " + serverTriggerCount + " many repeat(s)");
                }
                groupInstance.UpdateInputHeld(false);
            }
            if (groupInstance.PropogateToServer() || groupInstance.NeedsNetSync()) {
                this.Send_ServerToClient(groupContext, groupInstance, msg.Data, from);
            }
        } else {
            FlansMod.LOGGER.warn("Server believes we cannot start " + groupContext + " that client sent us");
            this.CancelGroupInstance(groupContext);
            groupContext.Gun.SetItemStack(groupContext.Gun.GetItemStack());
        }
        return startResult;
    }

    @Nonnull
    public EActionResult Server_TryStartGroupInstance(@Nonnull ActionGroupContext groupContext) {
        if (this.IsClient) {
            FlansMod.LOGGER.error("Called Server function on client in ActionStack!");
            return EActionResult.TryNextAction;
        }
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance == null) {
            return EActionResult.TryNextAction;
        }
        EActionResult result = this.TryStartGroupInstance(groupContext, true);
        if (result == EActionResult.CanProcess && (groupInstance.PropogateToServer() || groupInstance.NeedsNetSync())) {
            this.Send_ServerToClient_ActionGroupStart(groupContext, groupInstance, null);
        }
        return result;
    }

    @Nonnull
    public EActionResult Server_TryUpdateGroupInstanceHeld(@Nonnull ActionGroupContext groupContext) {
        return this.Server_TryUpdateGroupInstance(groupContext, true);
    }

    @Nonnull
    public EActionResult Server_TryUpdateGroupInstanceNotHeld(@Nonnull ActionGroupContext groupContext) {
        return this.Server_TryUpdateGroupInstance(groupContext, false);
    }

    @Nonnull
    public EActionResult Server_TryUpdateGroupInstance(@Nonnull ActionGroupContext groupContext, boolean held) {
        if (this.IsClient) {
            FlansMod.LOGGER.error("Called Server function on client in ActionStack!");
            return EActionResult.TryNextAction;
        }
        ActionGroupInstance groupInstance = this.TryGetGroupInstance(groupContext);
        if (groupInstance == null || !groupInstance.HasStarted() && groupInstance.RepeatMode() == ERepeatMode.FullAuto) {
            if (held) {
                return this.Server_TryStartGroupInstance(groupContext);
            }
            return EActionResult.TryNextAction;
        }
        EActionResult result = this.TryUpdateInputHeld(groupContext, held);
        if (result == EActionResult.CanProcess && (groupInstance.NeedsNetSync() || !held)) {
            if (held) {
                this.Send_ServerToClient_ActionGroupHeld(groupContext, groupInstance, null);
            } else {
                this.Send_ServerToClient_ActionGroupReleased(groupContext, groupInstance, null);
            }
        }
        return result;
    }

    protected void Send_ServerToClient_ActionGroupStart(@Nonnull ActionGroupContext groupContext, @Nonnull ActionGroupInstance groupInstance, @Nullable ServerPlayer triggeredByPlayer) {
        this.Send_ServerToClient(groupContext, groupInstance, EPressType.Press, triggeredByPlayer);
    }

    protected void Send_ServerToClient_ActionGroupHeld(@Nonnull ActionGroupContext groupContext, @Nonnull ActionGroupInstance groupInstance, @Nullable ServerPlayer triggeredByPlayer) {
        this.Send_ServerToClient(groupContext, groupInstance, EPressType.Hold, triggeredByPlayer);
    }

    protected void Send_ServerToClient_ActionGroupReleased(@Nonnull ActionGroupContext groupContext, @Nonnull ActionGroupInstance groupInstance, @Nullable ServerPlayer triggeredByPlayer) {
        this.Send_ServerToClient(groupContext, groupInstance, EPressType.Release, triggeredByPlayer);
    }

    protected void Send_ServerToClient(@Nonnull ActionGroupContext groupContext, @Nonnull ActionGroupInstance groupInstance, @Nonnull EPressType pressType, @Nullable ServerPlayer triggeredByPlayer) {
        ActionUpdateMessage updateMsg = new ActionUpdateMessage(groupContext, pressType, groupInstance.GetStartedTick());
        updateMsg.AddTriggers(groupInstance, groupInstance.GetRequiredNetSyncMin(), groupInstance.GetRequiredNetSyncMax());
        this.Send_ServerToClient(groupContext, groupInstance, updateMsg, triggeredByPlayer);
    }

    protected void Send_ServerToClient(@Nonnull ActionGroupContext groupContext, @Nonnull ActionGroupInstance groupInstance, @Nonnull ActionUpdateMessage updateMsg, @Nullable ServerPlayer triggeredByPlayer) {
        Level level = groupContext.Gun.GetLevel();
        if (level != null) {
            double radius = groupInstance.GetPropogationRadius();
            ArrayList<Vec3> positions = new ArrayList<Vec3>(2);
            for (Map.Entry<Integer, ActionUpdateMessage.ActionTriggerInfo> kvp : updateMsg.GetTriggers()) {
                groupInstance.AddExtraPositionsForNetSync(kvp.getKey(), positions);
            }
            if (groupInstance.ShouldAddPlayerPosForNetSync()) {
                positions.add(groupContext.Gun.GetShootOrigin().positionVec3());
            }
            FlansModPacketHandler.SendToAllAroundPoints(new ActionUpdateMessage.ToClient(updateMsg), (ResourceKey<Level>)level.m_46472_(), positions, radius, (Entity)triggeredByPlayer);
        }
    }

    public void ForEachNonZeroStack(@Nonnull Consumer<AbilityStack> func) {
        for (AbilityStack stacks : this.AbilityStacks.values()) {
            if (!stacks.IsActive()) continue;
            func.accept(stacks);
        }
    }

    private void TickAbilities(@Nonnull GunContext gunContext) {
        for (AbilityStack stacks : this.AbilityStacks.values()) {
            stacks.Tick(gunContext);
        }
    }

    @Nullable
    public AbilityStack GetStacks(@Nonnull AbilityStackingDefinition stackingDef) {
        if (this.AbilityStacks.containsKey(stackingDef.stackingKey)) {
            return this.AbilityStacks.get(stackingDef.stackingKey);
        }
        return null;
    }

    @Nonnull
    public AbilityStack GetOrCreateStacks(@Nonnull AbilityStackingDefinition stackingDef, int tier) {
        if (this.AbilityStacks.containsKey(stackingDef.stackingKey)) {
            return this.AbilityStacks.get(stackingDef.stackingKey);
        }
        AbilityStack stack = new AbilityStack(stackingDef, tier);
        this.AbilityStacks.put(stackingDef.stackingKey, stack);
        return stack;
    }

    public void EvaluateTrigger(@Nonnull EAbilityTrigger triggerType, @Nonnull ActionGroupContext actionGroupContext, @Nonnull TriggerContext triggerContext) {
        this.EvaluateTrigger(triggerType, actionGroupContext.Gun, actionGroupContext, triggerContext);
    }

    public void EvaluateTrigger(@Nonnull EAbilityTrigger triggerType, @Nonnull GunContext gunContext, @Nonnull TriggerContext triggerContext) {
        this.EvaluateTrigger(triggerType, gunContext, null, triggerContext);
    }

    public void EvaluateTrigger(@Nonnull EAbilityTrigger triggerType, @Nonnull GunContext gunContext, @Nullable ActionGroupContext actionGroupContext, @Nonnull TriggerContext triggerContext) {
        if (++LOOP_CHECK >= 4) {
            return;
        }
        gunContext.ForEachAbility((ability, tier) -> {
            TargetsContext targetsContext;
            if (ability.IsValid() && ability.MatchTrigger(triggerType, triggerContext) && !(targetsContext = ability.MatchTargets(triggerContext)).IsEmpty()) {
                AbilityStack stacks = null;
                if (ability.IsStackable()) {
                    stacks = this.GetOrCreateStacks(ability.stacking, (int)tier);
                    stacks.AddStack();
                }
                for (AbilityEffectDefinition effectDef : ability.effects) {
                    if (this.IsClient) {
                        effectDef.GetEffectProcessor().TriggerClient(gunContext.GetActionGroupContext("base"), triggerContext, targetsContext, stacks);
                        continue;
                    }
                    effectDef.GetEffectProcessor().TriggerServer(gunContext.GetActionGroupContext("base"), triggerContext, targetsContext, stacks);
                }
            }
        });
        --LOOP_CHECK;
    }
}

