/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionManager;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.network.bidirectional.ActionUpdateMessage;
import com.flansmod.physics.common.util.MinecraftHelpers;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerActionManager
extends ActionManager {
    private static final double RELOAD_MSG_RADIUS = 50.0;

    public ServerActionManager() {
        super(false);
    }

    public void HookServer(IEventBus modEventBus) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @Nonnull
    protected EActionResult TryStartGroupInstance(@Nonnull ActionStack actionStack, @Nonnull ActionGroupContext context) {
        return actionStack.Server_TryStartGroupInstance(context);
    }

    @Override
    @Nonnull
    protected EActionResult TryUpdateGroupInstanceHeld(@Nonnull ActionStack actionStack, @Nonnull ActionGroupContext context) {
        return actionStack.Server_TryUpdateGroupInstanceHeld(context);
    }

    @Override
    @Nonnull
    protected EActionResult TryUpdateGroupInstanceNotHeld(@Nonnull ActionStack actionStack, @Nonnull ActionGroupContext context) {
        return actionStack.Server_TryUpdateGroupInstanceNotHeld(context);
    }

    public void OnServerReceivedActionUpdate(ActionUpdateMessage.ToServer msg, ServerPlayer from) {
        ActionGroupContext groupContext = msg.Data.GetActionGroupContext(false);
        if (!groupContext.IsValid() || !groupContext.Gun.GetShooter().IsValid()) {
            FlansMod.LOGGER.warn("OnServerReceivedActionUpdate had invalid action");
            return;
        }
        FlansMod.LOGGER.info("Received server: " + msg.Data.GetPressType() + msg.Data.GetActionGroupContext(false));
        ActionStack actionStack = groupContext.Gun.GetActionStack();
        actionStack.Server_TryHandleMessage(msg, from);
    }

    @SubscribeEvent
    public void ServerTick(TickEvent.ServerTickEvent tickEvent) {
        if (tickEvent.phase == TickEvent.Phase.START) {
            ArrayList<UUID> invalidIDs = new ArrayList<UUID>();
            for (Map.Entry entry : this.ActionStacks.entrySet()) {
                UUID gunID = (UUID)entry.getKey();
                ActionStack actionStack = (ActionStack)entry.getValue();
                GunContext gunContext = GunContext.of(gunID);
                if (gunContext.IsValid()) {
                    if (!actionStack.IsValid()) continue;
                    actionStack.OnTick(gunContext.GetLevel(), gunContext);
                    continue;
                }
                actionStack.Clear(gunContext);
                invalidIDs.add(gunID);
            }
            for (UUID uUID : invalidIDs) {
                this.ActionStacks.remove(uUID);
            }
            for (Level level : MinecraftHelpers.serverGetLoadedLevels()) {
                for (Player player : level.m_6907_()) {
                    ShooterContext shooterContext = ShooterContext.of((Entity)player);
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        if (!(player.m_150109_().m_8020_(i).m_41720_() instanceof GunItem)) continue;
                        UUID gunID = FlanItem.Server_GetOrSetNewGunID(player.m_150109_().m_8020_(i));
                        GunContext gunContext = GunContext.of(shooterContext, gunID);
                        ActionStack actionStack = this.GetActionStack(gunID);
                        boolean equipped = i == player.m_150109_().f_35977_ || i == 40;
                        actionStack.UpdateEquipped(gunContext, equipped);
                    }
                }
            }
        }
    }
}

