/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.ActionManager;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextHistory;
import com.flansmod.common.actions.contexts.GunContextItem;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextHistory;
import com.flansmod.common.actions.contexts.ShooterContextPlayer;
import com.flansmod.common.item.FlanItem;
import com.flansmod.physics.common.util.EContextSide;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class ContextCache {
    private final HashMap<UUID, ShooterContextHistory> ShooterContexts = new HashMap();
    private final HashMap<UUID, GunContextHistory> GunContextCache = new HashMap();
    protected final EContextSide Side;

    public ContextCache(EContextSide side) {
        this.Side = side;
    }

    public void OnLevelUnloaded(@Nonnull ActionManager actionManager) {
        actionManager.Clear();
        this.ShooterContexts.clear();
        this.GunContextCache.clear();
    }

    public void ClearPlayer(@Nonnull UUID playerID, @Nonnull ActionManager actionManager) {
    }

    @Nonnull
    private ShooterContextHistory HistoryOfShooter(@Nonnull UUID shooterID) {
        if (shooterID.equals(ShooterContext.InvalidID)) {
            return ShooterContextHistory.INVALID;
        }
        ShooterContextHistory history = this.ShooterContexts.get(shooterID);
        if (history == null) {
            history = new ShooterContextHistory(shooterID);
            this.ShooterContexts.put(shooterID, history);
        }
        return history;
    }

    @Nonnull
    public ShooterContext GetShooter(@Nonnull Entity shooter) {
        return this.HistoryOfShooter(shooter.m_20148_()).ContextualizeWith(shooter);
    }

    @Nonnull
    public ShooterContext GetShooter(@Nonnull ShooterBlockEntity shooter) {
        return this.HistoryOfShooter(shooter.GetShooterID()).ContextualizeWith(shooter);
    }

    @Nonnull
    public ShooterContext GetShooter(@Nonnull Entity shooter, @Nullable Entity owner) {
        return this.GetShooter(shooter.m_20148_(), owner != null ? owner.m_20148_() : ShooterContext.InvalidID, null);
    }

    @Nonnull
    public ShooterContext GetShooter(@Nonnull UUID shooterID, @Nonnull UUID ownerID, @Nullable Level checkLevel) {
        return this.HistoryOfShooter(shooterID).ContextualizeWith(ownerID, shooterID, checkLevel, this::TryFindEntity, this::TryFindBlockEntity);
    }

    @Nullable
    protected abstract Entity TryFindEntity(@Nonnull UUID var1);

    @Nonnull
    protected abstract Optional<ShooterBlockEntity> TryFindBlockEntity(@Nonnull UUID var1);

    @Nonnull
    public GunContextHistory HistoryOfGun(@Nonnull UUID gunID) {
        if (gunID.equals(GunContext.INVALID.GetUUID())) {
            return GunContextHistory.INVALID;
        }
        GunContextHistory history = this.GunContextCache.get(gunID);
        if (history == null) {
            history = new GunContextHistory(gunID);
            this.GunContextCache.put(gunID, history);
        }
        return history;
    }

    @Nonnull
    public static GunContextItem CreateWithoutCaching(@Nonnull ItemStack stack) {
        return new GunContextItem(stack);
    }

    @Nonnull
    public GunContext GetLastKnownAppearanceOfGun(@Nonnull UUID gunID) {
        return this.HistoryOfGun(gunID).WithoutContext();
    }

    @Nullable
    public GunContext GetContextIfStillValid(@Nonnull UUID gunID) {
        return this.HistoryOfGun(gunID).GetMostRecentValidContext(GunContext::IsValid);
    }

    @Nonnull
    public GunContext Create(@Nonnull ItemStack stack) {
        UUID gunID = FlanItem.GetGunID(stack);
        if (gunID != FlanItem.InvalidGunUUID) {
            return this.HistoryOfGun(gunID).ContextualizeWith(stack);
        }
        return GunContext.INVALID;
    }

    @Nonnull
    public GunContext Create(@Nonnull Container container, int slot) {
        ItemStack stack = container.m_8020_(slot);
        UUID gunID = FlanItem.GetGunID(stack);
        if (gunID != FlanItem.InvalidGunUUID) {
            return this.HistoryOfGun(gunID).ContextualizeWith(container, slot);
        }
        return GunContext.INVALID;
    }

    @Nonnull
    public GunContext Create(@Nonnull BlockEntity blockEntity, @Nonnull Container container, int slot) {
        ItemStack stack = container.m_8020_(slot);
        UUID gunID = FlanItem.GetGunID(stack);
        if (gunID != FlanItem.InvalidGunUUID) {
            return this.HistoryOfGun(gunID).ContextualizeWith(blockEntity, container, slot);
        }
        return GunContext.INVALID;
    }

    @Nonnull
    public GunContext Create(@Nonnull ItemEntity itemEntity) {
        UUID gunID = FlanItem.GetGunID(itemEntity.m_32055_());
        if (gunID != FlanItem.InvalidGunUUID) {
            return this.HistoryOfGun(gunID).ContextualizeWith(itemEntity);
        }
        return GunContext.INVALID;
    }

    @Nonnull
    public GunContext Create(@Nonnull ShooterContext shooter, @Nonnull InteractionHand hand) {
        int slot;
        if (!this.VerifyCallingFromCorrectSide(shooter)) {
            return GunContext.INVALID;
        }
        if (!shooter.IsValid()) {
            return GunContext.INVALID;
        }
        if (shooter instanceof ShooterContextPlayer) {
            ShooterContextPlayer player = (ShooterContextPlayer)shooter;
            slot = hand == InteractionHand.MAIN_HAND ? player.Player.m_150109_().f_35977_ : 40;
        } else {
            slot = hand == InteractionHand.MAIN_HAND ? 0 : 1;
        }
        return this.Create(shooter, shooter.GetGunIDForSlot(slot));
    }

    @Nonnull
    public GunContext Create(@Nonnull ShooterContext shooter, int gunSlotIndex) {
        UUID gunID;
        if (this.VerifyCallingFromCorrectSide(shooter) && (gunID = shooter.GetGunIDForSlot(gunSlotIndex)) != FlanItem.InvalidGunUUID) {
            return this.HistoryOfGun(gunID).ContextualizeWith(shooter, gunSlotIndex);
        }
        return GunContext.INVALID;
    }

    @Nonnull
    public GunContext Create(@Nonnull ShooterContext shooter, @Nonnull UUID gunID) {
        if (gunID != FlanItem.InvalidGunUUID) {
            return this.HistoryOfGun(gunID).ContextualizeWith(shooter);
        }
        return GunContext.INVALID;
    }

    private boolean VerifyCallingFromCorrectSide(@Nonnull ShooterContext shooter) {
        EContextSide side = shooter.GetSide();
        return side == this.Side || side == EContextSide.Unknown;
    }

    private boolean VerifyCallingFromCorrectSide(@Nonnull GunContext gun) {
        EContextSide side = gun.GetShooter().GetSide();
        return side == this.Side || side == EContextSide.Unknown;
    }
}

