/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.abilities.AbilityInstanceApplyModifier;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.Actions;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.ContextCache;
import com.flansmod.common.actions.contexts.GunInputContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextLiving;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.common.actions.stats.IStatCalculatorContext;
import com.flansmod.common.actions.stats.ModifierCache;
import com.flansmod.common.actions.stats.StatAccumulator;
import com.flansmod.common.item.AttachmentItem;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.abilities.CraftingTraitDefinition;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.common.types.abilities.elements.EAbilityEffect;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.guns.GunDefinition;
import com.flansmod.common.types.guns.elements.AbilityDefinition;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.ActionGroupDefinition;
import com.flansmod.common.types.guns.elements.HandlerDefinition;
import com.flansmod.common.types.guns.elements.HandlerNodeDefinition;
import com.flansmod.common.types.guns.elements.ModeDefinition;
import com.flansmod.common.types.guns.elements.ReloadDefinition;
import com.flansmod.common.types.parts.PartDefinition;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.util.formulae.FloatAccumulation;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.LegacyRandomSource;

public abstract class GunContext
implements IStatCalculatorContext {
    public static final GunContext INVALID = new GunContext(ItemStack.f_41583_){

        @Override
        public void OnItemStackChanged(@Nonnull ItemStack stack) {
        }

        @Override
        @Nonnull
        public EItemStackLinkage CheckItemStackLink() {
            return EItemStackLinkage.NotConnected;
        }

        @Override
        @Nonnull
        public ItemStack GetLinkedItemStack() {
            return ItemStack.f_41583_;
        }

        @Override
        @Nullable
        public DamageSource CreateDamageSource() {
            return null;
        }

        @Override
        @Nonnull
        public ShooterContext GetShooter() {
            return ShooterContext.INVALID;
        }

        @Nullable
        public Inventory GetAttachedInventory() {
            return null;
        }

        @Override
        public boolean CanPerformTwoHandedAction() {
            return false;
        }

        @Override
        @Nonnull
        public ActionStack GetActionStack() {
            return ActionStack.Invalid;
        }

        @Override
        public boolean CanPerformActions() {
            return false;
        }

        @Override
        public void BakeModifiers(@Nonnull IModifierBaker baker) {
        }
    };
    private final HashMap<EPlayerInput, GunInputContext> InputContextCache = new HashMap();
    private final HashMap<String, ActionGroupContext> ActionGroupContextCache = new HashMap();
    private final HashMap<Integer, String> CachedGroupPathNames = new HashMap();
    public ItemStack Stack;
    public Entity lockedOnTarget = null;
    @Nonnull
    public final GunDefinition Def;
    public float lockTime = 0.0f;
    private static final RandomSource BackupRandomGenerator = new LegacyRandomSource(8931145513320L);
    private final ModifierCache ModCache;

    @Nonnull
    public static GunContext of(@Nonnull ItemStack stack) {
        return GunContext.unknownSide(stack);
    }

    @Nonnull
    public static GunContext of(@Nonnull ItemStack stack, EContextSide side) {
        return switch (side) {
            case EContextSide.Client -> GunContext.client(stack);
            case EContextSide.Server -> GunContext.server(stack);
            default -> GunContext.unknownSide(stack);
        };
    }

    @Nonnull
    public static GunContext of(@Nonnull ShooterContext shooter, @Nonnull UUID gunID) {
        switch (shooter.GetSide()) {
            case Client: {
                return GunContext.client(shooter, gunID);
            }
            case Server: {
                return GunContext.server(shooter, gunID);
            }
        }
        return GunContext.unknownSide(gunID);
    }

    @Nonnull
    public static GunContext of(@Nonnull ShooterContext shooter, int index) {
        switch (shooter.GetSide()) {
            case Client: {
                return GunContext.client(shooter, index);
            }
            case Server: {
                return GunContext.server(shooter, index);
            }
        }
        return GunContext.unknownSide(shooter.GetGunIDForSlot(index));
    }

    @Nonnull
    public static GunContext of(@Nonnull ShooterContext shooter, @Nonnull InteractionHand hand) {
        if (shooter instanceof ShooterContextLiving) {
            ShooterContextLiving livingContext = (ShooterContextLiving)shooter;
            switch (shooter.GetSide()) {
                case Client: {
                    return GunContext.client(livingContext, hand);
                }
                case Server: {
                    return GunContext.server(livingContext, hand);
                }
            }
            return GunContext.unknownSide(livingContext.GetGunID(hand));
        }
        return INVALID;
    }

    @Nonnull
    public static GunContext of(@Nonnull UUID gunID) {
        switch (MinecraftHelpers.getLogicalSide()) {
            case Client: {
                return GunContext.client(gunID);
            }
            case Server: {
                return GunContext.server(gunID);
            }
        }
        return GunContext.unknownSide(gunID);
    }

    @Nonnull
    public static GunContext of(@Nonnull ItemEntity itemEntity) {
        return itemEntity.m_9236_().f_46443_ ? GunContext.client(itemEntity) : GunContext.server(itemEntity);
    }

    @Nonnull
    public static GunContext of(@Nonnull Container container, int slotIndex, boolean isClient) {
        return isClient ? GunContext.client(container, slotIndex) : GunContext.server(container, slotIndex);
    }

    @Nonnull
    public static GunContext of(@Nonnull BlockEntity blockEntity, @Nonnull Container container, int slotIndex) {
        switch (EContextSide.of(blockEntity)) {
            case Client: {
                return GunContext.client(blockEntity, container, slotIndex);
            }
            case Server: {
                return GunContext.server(blockEntity, container, slotIndex);
            }
        }
        return GunContext.unknownSide(blockEntity, container, slotIndex);
    }

    @Nonnull
    private static GunContext client(@Nonnull UUID gunID) {
        return FlansModClient.CONTEXT_CACHE.GetLastKnownAppearanceOfGun(gunID);
    }

    @Nonnull
    private static GunContext client(@Nonnull ItemStack stack) {
        return FlansModClient.CONTEXT_CACHE.Create(stack);
    }

    @Nonnull
    private static GunContext client(@Nonnull Container container, int slotIndex) {
        return FlansModClient.CONTEXT_CACHE.Create(container, slotIndex);
    }

    @Nonnull
    private static GunContext client(@Nonnull BlockEntity blockEntity, @Nonnull Container container, int slotIndex) {
        return FlansModClient.CONTEXT_CACHE.Create(blockEntity, container, slotIndex);
    }

    @Nonnull
    private static GunContext client(@Nonnull ShooterContext shooter, int slotIndex) {
        return FlansModClient.CONTEXT_CACHE.Create(shooter, slotIndex);
    }

    @Nonnull
    private static GunContext client(@Nonnull ShooterContext shooter, @Nonnull UUID gunID) {
        return FlansModClient.CONTEXT_CACHE.Create(shooter, gunID);
    }

    @Nonnull
    private static GunContext client(@Nonnull ShooterContextLiving living, @Nonnull InteractionHand hand) {
        return FlansModClient.CONTEXT_CACHE.Create((ShooterContext)living, hand);
    }

    @Nonnull
    private static GunContext client(@Nonnull ItemEntity itemEntity) {
        return FlansModClient.CONTEXT_CACHE.Create(itemEntity);
    }

    @Nonnull
    private static GunContext server(@Nonnull UUID gunID) {
        return FlansMod.CONTEXT_CACHE.GetLastKnownAppearanceOfGun(gunID);
    }

    @Nonnull
    private static GunContext server(@Nonnull ItemStack stack) {
        return FlansMod.CONTEXT_CACHE.Create(stack);
    }

    @Nonnull
    private static GunContext server(@Nonnull Container container, int slotIndex) {
        return FlansMod.CONTEXT_CACHE.Create(container, slotIndex);
    }

    @Nonnull
    private static GunContext server(@Nonnull BlockEntity blockEntity, @Nonnull Container container, int slotIndex) {
        return FlansMod.CONTEXT_CACHE.Create(blockEntity, container, slotIndex);
    }

    @Nonnull
    private static GunContext server(@Nonnull ShooterContext shooter, int slotIndex) {
        return FlansMod.CONTEXT_CACHE.Create(shooter, slotIndex);
    }

    @Nonnull
    private static GunContext server(@Nonnull ShooterContext shooter, @Nonnull UUID gunID) {
        return FlansMod.CONTEXT_CACHE.Create(shooter, gunID);
    }

    @Nonnull
    private static GunContext server(@Nonnull ShooterContextLiving living, @Nonnull InteractionHand hand) {
        return FlansMod.CONTEXT_CACHE.Create((ShooterContext)living, hand);
    }

    @Nonnull
    private static GunContext server(@Nonnull ItemEntity itemEntity) {
        return FlansMod.CONTEXT_CACHE.Create(itemEntity);
    }

    @Nonnull
    private static GunContext unknownSide(@Nonnull BlockEntity blockEntity, @Nonnull Container container, int slotIndex) {
        return ContextCache.CreateWithoutCaching(container.m_8020_(slotIndex));
    }

    @Nonnull
    private static GunContext unknownSide(@Nonnull ItemStack stack) {
        return ContextCache.CreateWithoutCaching(stack);
    }

    @Nonnull
    private static GunContext unknownSide(@Nonnull UUID gunID) {
        return INVALID;
    }

    @Nonnull
    public GunInputContext GetInputContext(EPlayerInput inputType) {
        if (this.InputContextCache.containsKey((Object)inputType)) {
            return this.InputContextCache.get((Object)inputType);
        }
        GunInputContext context = new GunInputContext(this, inputType);
        this.InputContextCache.put(inputType, context);
        return context;
    }

    @Nonnull
    public ActionGroupContext GetActionGroupContext(String groupPath) {
        if (groupPath == null) {
            return ActionGroupContext.INVALID;
        }
        if (this.ActionGroupContextCache.containsKey(groupPath)) {
            return this.ActionGroupContextCache.get(groupPath);
        }
        ActionGroupContext context = new ActionGroupContext(this, groupPath);
        this.ActionGroupContextCache.put(groupPath, context);
        return context;
    }

    @Nonnull
    public ActionGroupContext GetActionGroupContextByHash(int groupPathHash) {
        if (!this.CachedGroupPathNames.containsKey(groupPathHash)) {
            for (ActionGroupDefinition actionGroupDefinition : this.Def.actionGroups) {
                String groupPath = ActionGroupContext.CreateGroupPath(actionGroupDefinition.key);
                this.CachedGroupPathNames.put(groupPath.hashCode(), groupPath);
            }
            for (EAttachmentType eAttachmentType : EAttachmentType.values()) {
                for (int i = 0; i < this.GetNumAttachmentStacks(eAttachmentType); ++i) {
                    AttachmentDefinition attachmentDefintion = this.GetAttachmentDefinition(eAttachmentType, i);
                    if (!attachmentDefintion.IsValid()) continue;
                    for (ActionGroupDefinition agDef : attachmentDefintion.actionOverrides) {
                        String groupPath = ActionGroupContext.CreateGroupPath(eAttachmentType, i, agDef.key);
                        this.CachedGroupPathNames.put(groupPath.hashCode(), groupPath);
                    }
                }
            }
        }
        return this.GetActionGroupContext(this.CachedGroupPathNames.get(groupPathHash));
    }

    @Nonnull
    public ActionGroupContext GetActionGroupContextSibling(ActionGroupContext original, String newKey) {
        if (original.IsAttachment()) {
            ActionGroupContext.CreateGroupPath(original.GetAttachmentType(), original.GetAttachmentIndex(), newKey);
        }
        return this.GetActionGroupContext(newKey);
    }

    public abstract void OnItemStackChanged(ItemStack var1);

    @Nonnull
    public abstract EItemStackLinkage CheckItemStackLink();

    @Nonnull
    public abstract ItemStack GetLinkedItemStack();

    public abstract DamageSource CreateDamageSource();

    @Nonnull
    public abstract ShooterContext GetShooter();

    public abstract Container GetAttachedInventory();

    public abstract boolean CanPerformTwoHandedAction();

    public int GetInventorySlotIndex() {
        return -1;
    }

    public abstract void BakeModifiers(@Nonnull IModifierBaker var1);

    @Nonnull
    public abstract ActionStack GetActionStack();

    public abstract boolean CanPerformActions();

    @Nullable
    public Level GetLevel() {
        return null;
    }

    @Nullable
    public Transform GetPosition() {
        return null;
    }

    @Nonnull
    public ItemStack GetItemStack() {
        return this.Stack;
    }

    public void SetItemStack(@Nonnull ItemStack stack) {
        this.Stack = stack;
        this.OnItemStackChanged(stack);
    }

    public Entity GetLockTarget() {
        return this.lockedOnTarget;
    }

    public void SetLockTarget(Entity e) {
        this.lockedOnTarget = e;
        this.OnItemStackChanged(this.GetItemStack());
    }

    @Nonnull
    public Transform GetShootOrigin() {
        return this.GetShooter().GetShootOrigin(0.0f);
    }

    @Nonnull
    public Transform GetShootOrigin(float deltaTick) {
        return this.GetShooter().GetShootOrigin(deltaTick);
    }

    @Nonnull
    public RandomSource GetRandom() {
        Level level = this.GetLevel();
        return level != null ? level.f_46441_ : BackupRandomGenerator;
    }

    public boolean IsLinkedToItemStack() {
        return this.CheckItemStackLink() == EItemStackLinkage.Connected;
    }

    @Nonnull
    public static EItemStackValidity CompareGunStacks(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41720_() != b.m_41720_()) {
            return EItemStackValidity.Invalid_DifferentItem;
        }
        if (!FlanItem.GetGunID(a).equals(FlanItem.GetGunID(b))) {
            return EItemStackValidity.Invalid_GunIDChange;
        }
        if (!ItemStack.m_150942_((ItemStack)a, (ItemStack)b)) {
            return EItemStackValidity.Valid_TagChanges;
        }
        return EItemStackValidity.Valid_NoChanges;
    }

    @Nonnull
    public EItemStackValidity ValidateLinkedItemStack() {
        if (this.IsLinkedToItemStack()) {
            return GunContext.CompareGunStacks(this.GetLinkedItemStack(), this.Stack);
        }
        return EItemStackValidity.Invalid_Error;
    }

    public void UpdateFromItemStack() {
        EItemStackValidity validity;
        if (this.IsLinkedToItemStack() && (validity = this.ValidateLinkedItemStack()).IsValid() && !ItemStack.m_150942_((ItemStack)this.Stack, (ItemStack)this.GetLinkedItemStack())) {
            this.Stack = this.GetLinkedItemStack().m_41777_();
        }
    }

    public boolean IsValid() {
        if (this.IsLinkedToItemStack() && !this.ValidateLinkedItemStack().IsValid()) {
            return false;
        }
        if (this.Stack.m_41619_()) {
            return false;
        }
        return this.Def.IsValid();
    }

    @Nonnull
    public UUID GetUUID() {
        return FlanItem.GetGunID(this.Stack);
    }

    protected GunContext(@Nonnull ItemStack stackAtTimeOfCreation) {
        this.Stack = stackAtTimeOfCreation.m_41777_();
        this.Def = this.CacheGunDefinition();
        this.ModCache = new ModifierCache(this::BakeAllModifiers);
    }

    @Nonnull
    public GunDefinition CacheGunDefinition() {
        Item item = this.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.Def();
        }
        return GunDefinition.INVALID;
    }

    @Nonnull
    protected CompoundTag GetTags(@Nonnull String key) {
        CompoundTag root = this.GetItemStack().m_41784_();
        if (root.m_128441_(key)) {
            return root.m_128469_(key);
        }
        return new CompoundTag();
    }

    protected void SetTags(@Nonnull String key, @Nonnull CompoundTag tags) {
        ItemStack updatedStack = this.Stack.m_41777_();
        updatedStack.m_41784_().m_128365_(key, (Tag)tags);
        this.SetItemStack(updatedStack);
    }

    public PartDefinition[] GetCraftingInputs() {
        return FlanItem.GetCraftingInputs(this.GetItemStack());
    }

    public void SetCraftingInputs(ItemStack[] stacks) {
        ItemStack gunStack = this.GetItemStack();
        FlanItem.SetCraftingInputs(gunStack, stacks);
        this.SetItemStack(gunStack);
    }

    @Nonnull
    public List<ReloadDefinition> GetReloadDefintions() {
        ArrayList<ReloadDefinition> results = new ArrayList<ReloadDefinition>(Arrays.asList(this.Def.reloads));
        for (AttachmentDefinition attachmentDef : this.GetAttachmentDefinitions()) {
            results.addAll(Arrays.asList(attachmentDef.reloadOverrides));
        }
        return results;
    }

    @Nonnull
    private ReloadDefinition[] GetReloadDefinitionsForSubpath(ActionGroupContext groupContext) {
        if (groupContext.IsAttachment()) {
            return this.GetAttachmentDefinition((EAttachmentType)groupContext.GetAttachmentType(), (int)groupContext.GetAttachmentIndex()).reloadOverrides;
        }
        return this.Def.reloads;
    }

    @Nullable
    public ReloadDefinition GetReloadDefinitionContaining(ActionGroupContext groupContext) {
        for (ReloadDefinition reload : this.GetReloadDefinitionsForSubpath(groupContext)) {
            if (!reload.Contains(groupContext.GroupPath)) continue;
            return reload;
        }
        return null;
    }

    @Nonnull
    public List<ActionDefinition> GetPotentialPrimaryActions() {
        return this.GetPotentialActions(EPlayerInput.Fire1);
    }

    @Nonnull
    public List<ActionDefinition> GetPotentialSecondaryActions() {
        return this.GetPotentialActions(EPlayerInput.Fire2);
    }

    @Nonnull
    public List<ActionDefinition> GetPotentialActions(EPlayerInput inputType) {
        ArrayList<ActionDefinition> results = new ArrayList<ActionDefinition>();
        GunInputContext inputContext = this.GetInputContext(inputType);
        for (Pair<ActionGroupContext, Boolean> kvp : this.EvaluateInputHandler(inputContext)) {
            results.addAll(Arrays.asList(((ActionGroupContext)kvp.getFirst()).Def.actions));
        }
        return results;
    }

    public List<Pair<ActionGroupContext, Boolean>> EvaluateInputHandler(GunInputContext inputContext) {
        ArrayList<Pair<ActionGroupContext, Boolean>> results = new ArrayList<Pair<ActionGroupContext, Boolean>>();
        HandlerDefinition handler = this.Def.GetInputHandler(inputContext);
        for (HandlerNodeDefinition node : handler.nodes) {
            if (!node.modalCheck.isEmpty()) {
                String currentValue;
                String modeKey = node.modalCheck;
                String modeValue = "on";
                if (node.modalCheck.contains(":")) {
                    String[] split = node.modalCheck.split(":");
                    modeKey = split[0];
                    modeValue = split[1];
                }
                if (!(currentValue = inputContext.Gun.GetModeValue(modeKey)).equals(modeValue)) continue;
            }
            if (!node.canTriggerWhileReloading && inputContext.Gun.GetActionStack().IsReloading()) continue;
            if (node.deferToAttachment) {
                AttachmentDefinition attachmentDef = this.GetAttachmentDefinition(node.attachmentType, node.attachmentIndex);
                if (!attachmentDef.IsValid()) continue;
                this.EvaluateAttachmentInputHandler(inputContext, ActionGroupContext.CreateGroupPath(node.attachmentType, node.attachmentIndex, ""), attachmentDef, results);
                continue;
            }
            ActionGroupDefinition actionGroupDef = this.Def.GetActionGroup(node.actionGroupToTrigger);
            if (!actionGroupDef.IsValid()) continue;
            results.add((Pair<ActionGroupContext, Boolean>)Pair.of((Object)ActionGroupContext.CreateFrom(inputContext.Gun, node.actionGroupToTrigger), (Object)node.andContinueEvaluating));
        }
        return results;
    }

    public void EvaluateAttachmentInputHandler(GunInputContext inputContext, String prefix, AttachmentDefinition attachmentDef, List<Pair<ActionGroupContext, Boolean>> results) {
        HandlerDefinition attachmentInputHandler = attachmentDef.GetInputHandler(inputContext);
        for (HandlerNodeDefinition node : attachmentInputHandler.nodes) {
            boolean matched = false;
            if (!node.modalCheck.isEmpty()) {
                String currentValue;
                String modeKey = node.modalCheck;
                String modeValue = "on";
                if (node.modalCheck.contains(":")) {
                    String[] split = node.modalCheck.split(":");
                    modeKey = split[0];
                    modeValue = split[1];
                }
                if (!(currentValue = inputContext.Gun.GetModeValue(modeKey)).equals(modeValue)) continue;
            }
            if (node.deferToAttachment) {
                FlansMod.LOGGER.warn(inputContext.Gun + ": Attachment is deferring to attachment in handlerOverrides");
            } else {
                ActionGroupDefinition actionGroupDef = attachmentDef.GetActionGroup(node.actionGroupToTrigger);
                if (actionGroupDef.IsValid()) {
                    results.add((Pair<ActionGroupContext, Boolean>)Pair.of((Object)ActionGroupContext.CreateFrom(inputContext.Gun, prefix + node.actionGroupToTrigger), (Object)node.andContinueEvaluating));
                    matched = true;
                }
            }
            if (matched && !node.andContinueEvaluating) break;
        }
    }

    @Nonnull
    public ActionGroupInstance GetOrCreateActionGroup(ActionGroupContext context) {
        ActionStack stack = context.Gun.GetActionStack();
        for (ActionGroupInstance instance : stack.GetActiveActionGroups()) {
            if (!instance.Def.key.equals(context.GroupPath)) continue;
            return instance;
        }
        return this.CreateActionGroup(context);
    }

    @Nonnull
    public ActionGroupInstance CreateActionGroup(ActionGroupContext context) {
        ActionGroupInstance groupInstance = new ActionGroupInstance(context);
        for (ActionDefinition actionDef : context.Def.actions) {
            ActionInstance actionInstance = Actions.InstanceAction(groupInstance, actionDef);
            if (actionInstance == null) continue;
            groupInstance.AddAction(actionInstance);
        }
        return groupInstance;
    }

    @Nonnull
    public String GetPaintjobName() {
        return FlanItem.GetPaintjobName(this.GetItemStack());
    }

    public void SetPaintjobName(@Nonnull String paint) {
        ItemStack gunStack = this.GetItemStack();
        FlanItem.SetPaintjobName(gunStack, paint);
        this.SetItemStack(gunStack);
    }

    @Nonnull
    public AttachmentDefinition GetAttachmentDefinition(EAttachmentType attachType, int slot) {
        ItemStack attachmentStack = this.GetAttachmentStack(attachType, slot);
        Item item = attachmentStack.m_41720_();
        if (item instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)item;
            return attachmentItem.Def();
        }
        return AttachmentDefinition.INVALID;
    }

    @Nonnull
    public List<AttachmentDefinition> GetAttachmentDefinitions() {
        ArrayList<AttachmentDefinition> defs = new ArrayList<AttachmentDefinition>();
        for (ItemStack stack : this.GetAttachmentStacks()) {
            Item item = stack.m_41720_();
            if (!(item instanceof AttachmentItem)) continue;
            AttachmentItem attachmentItem = (AttachmentItem)item;
            defs.add(attachmentItem.Def());
        }
        return defs;
    }

    public int GetNumAttachmentStacks(EAttachmentType attachType) {
        return this.Def.GetAttachmentSettings((EAttachmentType)attachType).numAttachmentSlots;
    }

    @Nonnull
    public ItemStack GetAttachmentStack(EAttachmentType attachType, int slot) {
        return FlanItem.GetAttachmentInSlot(this.GetItemStack(), attachType, slot);
    }

    public void SetAttachmentStack(EAttachmentType attachType, int slot, ItemStack attachmentStack) {
        ItemStack gunStack = this.GetItemStack();
        FlanItem.SetAttachmentInSlot(gunStack, attachType, slot, attachmentStack);
        this.SetItemStack(gunStack);
    }

    @Nonnull
    public ItemStack RemoveAttachmentFromSlot(EAttachmentType attachType, int slot) {
        ItemStack gunStack = this.GetItemStack();
        ItemStack removedStack = FlanItem.RemoveAttachmentFromSlot(gunStack, attachType, slot);
        this.SetItemStack(gunStack);
        return removedStack;
    }

    @Nonnull
    public List<ItemStack> GetAttachmentStacks() {
        return FlanItem.GetAttachmentStacks(this.GetItemStack());
    }

    public void BakeAllModifiers(@Nonnull IModifierBaker baker) {
        this.BakeModifiers(baker);
        this.BakeAttachmentModifiers(baker);
        this.BakeAbilityModifiers(baker);
    }

    private void BakeAttachmentModifiers(@Nonnull IModifierBaker baker) {
        for (ItemStack stack : this.GetAttachmentStacks()) {
            ModifierDefinition[] modifierDefinitionArray = stack.m_41720_();
            if (!(modifierDefinitionArray instanceof AttachmentItem)) continue;
            AttachmentItem attachmentItem = (AttachmentItem)modifierDefinitionArray;
            for (ModifierDefinition modDef : attachmentItem.Def().modifiers) {
                baker.Bake(modDef);
            }
        }
    }

    private void BakeAbilityModifiers(@Nonnull IModifierBaker baker) {
        for (Map.Entry<AbilityInstanceApplyModifier, AbilityStack> kvp : this.GetActiveModifierAbilities().entrySet()) {
            for (ModifierDefinition modDef : kvp.getKey().Def.modifiers) {
                baker.Bake(modDef, kvp.getValue().Level, kvp.getValue().GetStackCount());
            }
        }
    }

    @Override
    public int GetNumAttachments() {
        return this.GetAttachmentStacks().size();
    }

    @Nonnull
    public StatAccumulator GetModifierFormula(@Nonnull String stat) {
        return this.ModCache.GetModifierFormula(stat);
    }

    @Nonnull
    public Optional<String> GetStringOverride(@Nonnull String stat) {
        return this.ModCache.GetStringOverride(stat);
    }

    @Nonnull
    public FloatAccumulation ModifyFloat(@Nonnull String stat) {
        return FloatAccumulation.compose(this.GetModifierFormula(stat).Calculate(this), this.GetShooter().GetModifierFormula(stat).Calculate(this));
    }

    @Nonnull
    public String ModifyString(@Nonnull String stat, @Nonnull String defaultValue) {
        return this.GetShooter().GetStringOverride(stat).orElse(this.GetStringOverride(stat).orElse(defaultValue));
    }

    @Nonnull
    public Map<CraftingTraitDefinition, Integer> GetTraits() {
        return FlanItem.GetTraits(this.GetItemStack());
    }

    @Nonnull
    public Map<AbilityInstanceApplyModifier, AbilityStack> GetActiveModifierAbilities() {
        HashMap<AbilityInstanceApplyModifier, AbilityStack> map = new HashMap<AbilityInstanceApplyModifier, AbilityStack>();
        this.ForEachActiveModifierAbility(map::put);
        return map;
    }

    public void ForEachActiveModifierAbility(@Nonnull BiConsumer<AbilityInstanceApplyModifier, AbilityStack> func) {
        ActionStack actionStack = this.GetActionStack();
        if (actionStack.IsValid()) {
            this.ForEachAbility((abilityDef, tier) -> {
                AbilityStack stacks;
                if (abilityDef.IsStackable() && (stacks = actionStack.GetStacks(abilityDef.stacking)) != null && stacks.IsActive()) {
                    for (AbilityEffectDefinition effectDef : abilityDef.effects) {
                        if (effectDef.effectType != EAbilityEffect.ApplyModifier) continue;
                        IAbilityEffect abilityEffect = effectDef.GetEffectProcessor();
                        if (abilityEffect instanceof AbilityInstanceApplyModifier) {
                            AbilityInstanceApplyModifier modifierAbility = (AbilityInstanceApplyModifier)abilityEffect;
                            func.accept(modifierAbility, stacks);
                            continue;
                        }
                        FlansMod.LOGGER.error("Ability was of type ApplyModifier, but had some other processor attached");
                    }
                }
            });
        }
    }

    @Nonnull
    public Map<AbilityDefinition, Integer> GetAbilities() {
        HashMap<AbilityDefinition, Integer> map = new HashMap<AbilityDefinition, Integer>();
        this.ForEachAbility(map::put);
        return map;
    }

    public void ForEachAbility(@Nonnull BiConsumer<AbilityDefinition, Integer> func) {
        for (AbilityDefinition staticDef : this.Def.staticAbilities) {
            func.accept(staticDef, 1);
        }
        for (Map.Entry entry : this.GetTraits().entrySet()) {
            for (AbilityDefinition traitAbility : ((CraftingTraitDefinition)entry.getKey()).abilities) {
                func.accept(traitAbility, (Integer)entry.getValue());
            }
        }
    }

    @Nonnull
    public ModeDefinition[] GetAllModeDefs() {
        return this.Def.modes;
    }

    @Nullable
    public ModeDefinition GetModeDef(@Nonnull String modeKey) {
        for (ModeDefinition modeDef : this.Def.modes) {
            if (!modeDef.key.equals(modeKey)) continue;
            return modeDef;
        }
        return null;
    }

    @Nonnull
    public String GetDefaultModeValue(@Nonnull String modeKey) {
        ModeDefinition modeDef = this.GetModeDef(modeKey);
        if (modeDef != null) {
            return modeDef.defaultValue;
        }
        return "";
    }

    @Nonnull
    public String GetModeValue(@Nonnull String modeKey) {
        return FlanItem.GetModeValue(this.GetItemStack(), modeKey, this.GetDefaultModeValue(modeKey));
    }

    public void SetModeValue(@Nonnull String modeKey, @Nonnull String modeValue) {
        ItemStack stack = this.GetItemStack();
        FlanItem.SetModeValue(stack, modeKey, modeValue);
        this.SetItemStack(stack);
        this.GetActionStack().EvaluateTrigger(EAbilityTrigger.SwitchMode, this, TriggerContext.self(this));
    }

    public boolean ExpelItems(@Nonnull List<ItemStack> stacks) {
        Level level = this.GetLevel();
        if (level == null) {
            return false;
        }
        if (level.f_46443_) {
            return false;
        }
        for (ItemStack stack : stacks) {
            ItemEntity itemEntity = new ItemEntity(EntityType.f_20461_, level);
            itemEntity.m_32045_(stack);
            itemEntity.m_146884_(this.GetShootOrigin().positionVec3());
            level.m_7967_((Entity)itemEntity);
        }
        return true;
    }

    public void Save(CompoundTag tags) {
        CompoundTag stackTags = new CompoundTag();
        this.Stack.m_41739_(stackTags);
        tags.m_128365_("stack", (Tag)stackTags);
        tags.m_128405_("slot", this.GetInventorySlotIndex());
        CompoundTag shooterTags = new CompoundTag();
        this.GetShooter().Save(shooterTags);
        tags.m_128365_("shooter", (Tag)shooterTags);
    }

    public static GunContext Load(CompoundTag tags, boolean client) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)tags.m_128469_("stack"));
        UUID gunID = FlanItem.GetGunID(stack);
        int slot = tags.m_128451_("slot");
        ShooterContext shooter = ShooterContext.Load(tags.m_128469_("shooter"), client);
        if (shooter.IsValid()) {
            return shooter.CreateContext(gunID);
        }
        return ContextCache.CreateWithoutCaching(stack);
    }

    public String toString() {
        return "GunContext:" + this.GetItemStack().toString();
    }

    public static enum EItemStackLinkage {
        NotConnected,
        LostConnection,
        Connected;

    }

    public static enum EItemStackValidity {
        Invalid_Error,
        Invalid_DifferentItem,
        Invalid_GunIDChange,
        Valid_NoChanges,
        Valid_TagChanges;


        public boolean IsValid() {
            return this == Valid_NoChanges || this == Valid_TagChanges;
        }
    }
}

