/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextLiving;
import com.flansmod.common.actions.contexts.ShooterContextPlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GunContextPlayer
extends GunContextLiving {
    private final Player Player;
    private final int InventorySlot;

    public GunContextPlayer(@Nonnull ShooterContextPlayer shooter, int inventorySlot) {
        super(shooter, inventorySlot == 40 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, inventorySlot);
        this.Player = (Player)shooter.Shooter;
        this.InventorySlot = inventorySlot;
    }

    @Override
    public void OnItemStackChanged(@Nonnull ItemStack stack) {
        ItemStack stackInSlot = this.Player.m_150109_().m_8020_(this.InventorySlot);
        this.Player.m_150109_().m_6836_(this.InventorySlot, stack);
        this.Player.m_150109_().m_6596_();
    }

    @Override
    @Nonnull
    public GunContext.EItemStackLinkage CheckItemStackLink() {
        return this.Player.m_6084_() ? GunContext.EItemStackLinkage.Connected : GunContext.EItemStackLinkage.LostConnection;
    }

    @Override
    @Nonnull
    public ItemStack GetLinkedItemStack() {
        return this.Player.m_150109_().m_8020_(this.InventorySlot);
    }

    @Nullable
    public Inventory GetAttachedInventory() {
        return this.Player.m_150109_();
    }

    @Override
    public int GetInventorySlotIndex() {
        return this.InventorySlot;
    }

    @Override
    @Nonnull
    public String toString() {
        return this.GetShooter() + " holding [" + this.GetItemStack().toString() + "] (Slot " + this.InventorySlot + ")";
    }
}

