/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextLiving;
import com.flansmod.common.item.FlanItem;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ShooterContextPlayer
extends ShooterContextLiving {
    public final Player Player;

    public ShooterContextPlayer(@Nonnull Player player) {
        super((LivingEntity)player);
        this.Player = player;
    }

    @Override
    public Container GetAttachedInventory() {
        return this.Player.m_150109_();
    }

    @Override
    public boolean IsCreative() {
        return this.Player.m_7500_();
    }

    @Override
    @Nonnull
    public UUID GetGunID(@Nonnull InteractionHand hand) {
        ItemStack handStack = hand == InteractionHand.MAIN_HAND ? this.Player.m_150109_().m_36056_() : this.Player.m_150109_().m_8020_(40);
        return FlanItem.GetGunID(handStack);
    }

    @Override
    @Nonnull
    public UUID GetGunIDForSlot(int gunSlotIndex) {
        ItemStack stackInSlot = this.Player.m_150109_().m_8020_(gunSlotIndex);
        return FlanItem.GetGunID(stackInSlot);
    }

    @Override
    @Nonnull
    public GunContext CreateContext(@Nonnull UUID gunID) {
        for (int i = 0; i < this.Player.m_150109_().m_6643_(); ++i) {
            ItemStack stackInSlot = this.Player.m_150109_().m_8020_(i);
            if (!FlanItem.GetGunID(stackInSlot).equals(gunID)) continue;
            return new GunContextPlayer(this, i);
        }
        return GunContext.INVALID;
    }

    @Override
    @Nonnull
    public GunContext[] GetAllGunContexts() {
        GunContext[] contexts = new GunContext[2];
        contexts[0] = GunContext.of((ShooterContext)this, this.Player.m_150109_().f_35977_);
        contexts[0].UpdateFromItemStack();
        contexts[1] = GunContext.of((ShooterContext)this, 40);
        contexts[1].UpdateFromItemStack();
        return contexts;
    }

    @Override
    public int m_6643_() {
        return this.Player.m_150109_().m_6643_();
    }

    @Override
    public boolean m_7983_() {
        return this.Player.m_150109_().m_7983_();
    }

    @Override
    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.Player.m_150109_().m_8020_(slot);
    }

    @Override
    @Nonnull
    public ItemStack m_7407_(int slotIndex, int count) {
        return this.Player.m_150109_().m_7407_(slotIndex, count);
    }

    @Override
    @Nonnull
    public ItemStack m_8016_(int slotIndex) {
        return this.Player.m_150109_().m_8016_(slotIndex);
    }

    @Override
    public void m_6836_(int slotIndex, @Nonnull ItemStack stack) {
        this.Player.m_150109_().m_6836_(slotIndex, stack);
    }

    @Override
    public void m_6596_() {
        this.Player.m_150109_().m_6596_();
    }

    @Override
    public boolean m_6542_(@Nonnull Player player) {
        return this.Player.m_150109_().m_6542_(player);
    }

    @Override
    public void m_6211_() {
        this.Player.m_150109_().m_6211_();
    }

    @Override
    public String toString() {
        return "Player:'" + this.Player.m_7755_().getString() + "'['" + this.Dimension().m_135782_().m_135815_() + "']";
    }
}

