/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.menus;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.menus.WorkbenchMenu;
import com.flansmod.common.crafting.slots.AttachmentSlot;
import com.flansmod.common.crafting.slots.RestrictedSlot;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.attachments.EAttachmentType;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WorkbenchMenuModification
extends WorkbenchMenu {
    public static final int BUTTON_SELECT_MAGAZINE_0 = 0;
    public static final int BUTTON_SELECT_MAGAZINE_MAX = 255;
    public final Container GunContainer;
    public final Container MagUpgradeContainer;
    private RestrictedSlot GunSlot;
    private RestrictedSlot MagUpgradeSlot;
    private AttachmentSlot[] AttachmentSlots;

    public WorkbenchMenuModification(int containerID, @Nonnull Inventory inventory, @Nonnull AbstractWorkbench workbench) {
        super((MenuType<? extends WorkbenchMenu>)((MenuType)FlansMod.WORKBENCH_MENU_MODIFICATION.get()), containerID, inventory, workbench);
        this.GunContainer = this.Workbench.GunContainer;
        this.MagUpgradeContainer = this.Workbench.MagUpgradeContainer;
        this.CreateSlots(inventory, 0);
    }

    public WorkbenchMenuModification(int containerID, @Nonnull Inventory inventory, @Nonnull FriendlyByteBuf data) {
        super((MenuType<? extends WorkbenchMenu>)((MenuType)FlansMod.WORKBENCH_MENU_MODIFICATION.get()), containerID, inventory, data);
        this.GunContainer = this.Workbench.GunContainer;
        this.MagUpgradeContainer = this.Workbench.MagUpgradeContainer;
        this.CreateSlots(inventory, 0);
    }

    public boolean m_6366_(@Nonnull Player player, int buttonID) {
        if (buttonID < 0) {
            buttonID += 256;
        }
        if (0 <= buttonID && buttonID <= 255) {
            int magIndex = buttonID - 0;
            if (!player.m_9236_().f_46443_) {
                AbstractWorkbench.SelectMagazine(player, this.GunContainer, this.MagUpgradeContainer, magIndex);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void CreateSlots(@Nonnull Inventory playerInventory, int inventorySlotOffsetX) {
        super.CreateSlots(playerInventory, inventorySlotOffsetX);
        if (this.GunContainer.m_6643_() > 0) {
            this.GunSlot = new RestrictedSlot(this.GunContainer, 0, 78, 46);
            this.m_38897_(this.GunSlot);
            this.MagUpgradeSlot = new RestrictedSlot(this.MagUpgradeContainer, 0, 8, 94);
            this.m_38897_(this.MagUpgradeSlot);
            this.AttachmentSlots = new AttachmentSlot[ModSlot.values().length];
            for (ModSlot modSlot : ModSlot.values()) {
                AttachmentSlot attachmentSlot = new AttachmentSlot(this.GunSlot, modSlot.attachType, modSlot.attachIndex, this.GunContainer, 52 + 26 * modSlot.x, 20 + 26 * modSlot.y);
                this.AttachmentSlots[modSlot.ordinal()] = attachmentSlot;
                this.m_38897_(attachmentSlot);
            }
        } else {
            this.AttachmentSlots = new AttachmentSlot[0];
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slot) {
        if (this.GunSlot != null && slot == this.GunSlot.f_40219_) {
            return this.QuickStackIntoInventory(player, this.GunSlot);
        }
        if (this.MagUpgradeSlot != null && slot == this.MagUpgradeSlot.f_40219_) {
            return this.QuickStackIntoInventory(player, this.MagUpgradeSlot);
        }
        if (this.AttachmentSlots.length > 0 && slot >= this.AttachmentSlots[0].f_40219_ && slot < this.AttachmentSlots[0].f_40219_ + this.AttachmentSlots.length) {
            int attachmentSlotIndex = slot - this.AttachmentSlots[0].f_40219_;
            return this.QuickStackIntoInventory(player, this.AttachmentSlots[attachmentSlotIndex]);
        }
        ItemStack stack = ((Slot)this.f_38839_.get(slot)).m_7993_();
        if (this.GunSlot != null && this.GunSlot.m_7993_().m_41619_() && stack.m_41720_() instanceof GunItem) {
            this.GunSlot.m_5852_(stack);
            ((Slot)this.f_38839_.get(slot)).m_5852_(ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        if (this.MagUpgradeSlot != null && this.MagUpgradeSlot.m_7993_().m_41619_() && stack.m_41720_() == FlansMod.MAG_UPGRADE_ITEM.get()) {
            this.MagUpgradeSlot.m_5852_(stack);
            ((Slot)this.f_38839_.get(slot)).m_5852_(ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        for (AttachmentSlot attachmentSlot : this.AttachmentSlots) {
            if (!attachmentSlot.m_7993_().m_41619_() || !attachmentSlot.m_5857_(stack)) continue;
            attachmentSlot.m_5852_(stack.m_255036_(1));
            ((Slot)this.f_38839_.get(slot)).m_5852_(stack.m_255036_(stack.m_41613_() - 1));
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static enum ModSlot {
        SIGHTS(1, 0, EAttachmentType.Sights, 0),
        BARREL(0, 1, EAttachmentType.Barrel, 0),
        GRIP(1, 2, EAttachmentType.Grip, 0),
        STOCK(2, 1, EAttachmentType.Stock, 0),
        SECONDARY_SIGHTS(2, 0, EAttachmentType.Sights, 1),
        SECONDARY_BARREL(0, 0, EAttachmentType.Barrel, 1),
        SECONDARY_GRIP(0, 2, EAttachmentType.Grip, 1),
        SECONDARY_STOCK(2, 2, EAttachmentType.Stock, 1),
        CHARM(-1, 0, EAttachmentType.Charm, 0),
        GENERIC_0(3, 0, EAttachmentType.Generic, 0),
        GENERIC_1(3, 1, EAttachmentType.Generic, 1),
        GENERIC_2(3, 2, EAttachmentType.Generic, 2);

        public int x;
        public int y;
        public EAttachmentType attachType;
        public int attachIndex;

        private ModSlot(int x, int y, EAttachmentType type, int index) {
            this.x = x;
            this.y = y;
            this.attachType = type;
            this.attachIndex = index;
        }
    }
}

