/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.recipes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.ingredients.IExtraIngredientTooltip;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.PartItem;
import com.flansmod.common.types.crafting.ERecipePart;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GunFabricationRecipe
implements Recipe<AbstractWorkbench> {
    @Nonnull
    public final RecipeType<?> Type;
    @Nonnull
    public final ERecipePart Part;
    @Nonnull
    public final ResourceLocation Loc;
    @Nonnull
    public final String Group;
    @Nonnull
    public final NonNullList<Ingredient> InputIngredients;
    @Nonnull
    public final ItemStack Result;
    public final int CraftTime;

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.Type;
    }

    @Nonnull
    public String m_6076_() {
        return this.Group;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        return this.Result;
    }

    public boolean m_8004_(int x, int y) {
        return true;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.Loc;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.InputIngredients;
    }

    public boolean m_142505_() {
        return this.InputIngredients.size() == 0;
    }

    public GunFabricationRecipe(@Nonnull RecipeType<?> type, @Nonnull ResourceLocation loc, @Nonnull String group, @Nonnull Ingredient[] inputIngredients, @Nonnull ItemStack result, @Nonnull ERecipePart part, int craftTime) {
        this.Type = type;
        this.Part = part;
        this.Loc = loc;
        this.Group = group;
        this.InputIngredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputIngredients);
        this.Result = result;
        this.CraftTime = craftTime;
    }

    public boolean matches(@Nonnull AbstractWorkbench workbench, @Nullable Level level) {
        if (!workbench.GunRecipeCanBeCraftedInThisWorkbench(this.Result)) {
            return false;
        }
        if (workbench.GunCraftingInputContainer.m_6643_() < this.InputIngredients.size()) {
            return false;
        }
        for (int slot = 0; slot < this.InputIngredients.size(); ++slot) {
            boolean match = ((Ingredient)this.InputIngredients.get(slot)).test(workbench.GunCraftingInputContainer.m_8020_(slot));
            if (match) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public List<Component> GenerateTooltip(int ingredientIndex) {
        ArrayList<Component> lines = new ArrayList<Component>();
        Ingredient ingredient = (Ingredient)this.InputIngredients.get(ingredientIndex);
        if (ingredient instanceof IExtraIngredientTooltip) {
            IExtraIngredientTooltip extraTooltip = (IExtraIngredientTooltip)ingredient;
            extraTooltip.GenerateTooltip(lines, false);
        }
        return lines;
    }

    @Nonnull
    public ItemStack GetResult(@Nonnull List<ItemStack> craftingInputs) {
        ItemStack output = this.Result.m_41777_();
        FlanItem.SetCraftingInputs(output, craftingInputs);
        return output;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull AbstractWorkbench workbench, @Nonnull RegistryAccess registryAccess) {
        ArrayList<ItemStack> craftingInputs = new ArrayList<ItemStack>();
        for (int slot = 0; slot < workbench.GunCraftingInputContainer.m_6643_(); ++slot) {
            ItemStack inputStack = workbench.GunCraftingInputContainer.m_8020_(slot);
            Item item = inputStack.m_41720_();
            if (!(item instanceof PartItem)) continue;
            PartItem part = (PartItem)item;
            craftingInputs.add(inputStack);
        }
        return this.GetResult(craftingInputs);
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FlansMod.GUN_FABRICATION_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<GunFabricationRecipe> {
        @Nonnull
        public GunFabricationRecipe fromJson(@Nonnull ResourceLocation loc, @Nonnull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonArray ingredientArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            Ingredient[] ingredients = new Ingredient[ingredientArray.size()];
            for (int i = 0; i < ingredientArray.size(); ++i) {
                ingredients[i] = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int craftTime = GsonHelper.m_13824_((JsonObject)json, (String)"craft_time", (int)20);
            ERecipePart recipePart = ERecipePart.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"part", (String)"generic"));
            return new GunFabricationRecipe((RecipeType)FlansMod.GUN_FABRICATION_RECIPE_TYPE.get(), loc, group, ingredients, output, recipePart, craftTime);
        }

        @Nullable
        public GunFabricationRecipe fromNetwork(@Nonnull ResourceLocation loc, @Nonnull FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            int count = buf.readInt();
            Ingredient[] inputs = new Ingredient[count];
            for (int i = 0; i < count; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.m_130267_();
            int time = buf.readInt();
            ERecipePart recipePart = ERecipePart.values()[buf.readInt()];
            return new GunFabricationRecipe((RecipeType)FlansMod.GUN_FABRICATION_RECIPE_TYPE.get(), loc, group, inputs, output, recipePart, time);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull GunFabricationRecipe recipe) {
            buf.m_130070_(recipe.Group);
            buf.writeInt(recipe.InputIngredients.size());
            for (int i = 0; i < recipe.InputIngredients.size(); ++i) {
                ((Ingredient)recipe.InputIngredients.get(i)).m_43923_(buf);
            }
            buf.m_130055_(recipe.Result);
            buf.writeInt(recipe.CraftTime);
            buf.writeInt(recipe.Part.ordinal());
        }
    }
}

