/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.recipes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.WorkbenchBlockEntity;
import com.flansmod.common.crafting.ingredients.IExtraIngredientTooltip;
import com.flansmod.common.crafting.ingredients.StackedIngredient;
import com.flansmod.common.crafting.ingredients.TieredMaterialIngredient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PartFabricationRecipe
implements Recipe<WorkbenchBlockEntity> {
    @Nonnull
    public final RecipeType<?> Type;
    @Nonnull
    public final ResourceLocation Loc;
    @Nonnull
    public final String Group;
    @Nonnull
    public final NonNullList<Ingredient> InputIngredients;
    @Nonnull
    public final ItemStack Result;
    public final int CraftTime;

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.Type;
    }

    @Nonnull
    public String m_6076_() {
        return this.Group;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        return this.Result;
    }

    public boolean m_8004_(int x, int y) {
        return true;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.Loc;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.InputIngredients;
    }

    public boolean m_142505_() {
        return this.InputIngredients.size() == 0;
    }

    public PartFabricationRecipe(@Nonnull RecipeType<?> type, @Nonnull ResourceLocation loc, @Nonnull String group, @Nonnull Ingredient[] inputIngredients, @Nonnull ItemStack result, int craftTime) {
        this.Type = type;
        this.Loc = loc;
        this.Group = group;
        this.InputIngredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputIngredients);
        this.Result = result;
        this.CraftTime = craftTime;
    }

    public static int CountInputMatching(@Nonnull Ingredient ingredient, @Nonnull Container container) {
        int count = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (ingredient instanceof StackedIngredient) {
                StackedIngredient stackedIngredient = (StackedIngredient)ingredient;
                count += stackedIngredient.Count(stack);
                continue;
            }
            if (!ingredient.test(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public int[] GetMatchingOfEachIngredient(@Nonnull Container container) {
        int[] matching = new int[this.InputIngredients.size()];
        for (int i = 0; i < this.InputIngredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.InputIngredients.get(i);
            matching[i] = PartFabricationRecipe.CountInputMatching(ingredient, container);
        }
        return matching;
    }

    public int[] GetRequiredOfEachIngredient() {
        int[] required = new int[this.InputIngredients.size()];
        for (int i = 0; i < this.InputIngredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.InputIngredients.get(i);
            if (ingredient instanceof StackedIngredient) {
                StackedIngredient stacked = (StackedIngredient)ingredient;
                required[i] = stacked.Count;
                continue;
            }
            required[i] = 1;
        }
        return required;
    }

    @Nonnull
    public List<Component> GenerateTooltip(int ingredientIndex, int numRequired, int numMatching) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxProduce = numMatching / numRequired;
        Ingredient ingredient = (Ingredient)this.InputIngredients.get(ingredientIndex);
        if (ingredient instanceof TieredMaterialIngredient) {
            TieredMaterialIngredient tiered = (TieredMaterialIngredient)ingredient;
            tiered.GenerateTooltip(lines, numMatching, false);
        } else if (ingredient instanceof IExtraIngredientTooltip) {
            IExtraIngredientTooltip extraTooltip = (IExtraIngredientTooltip)ingredient;
            extraTooltip.GenerateTooltip(lines, false);
        } else {
            if (ingredient.m_43908_().length == 1) {
                lines.add(ingredient.m_43908_()[0].m_41786_());
            } else {
                lines.add((Component)Component.m_237115_((String)"crafting.one_of"));
                for (ItemStack possible : ingredient.m_43908_()) {
                    lines.add(possible.m_41786_());
                }
            }
            lines.add((Component)Component.m_237113_((String)(numMatching + "/" + numRequired + " (Max: " + maxProduce + ")")));
        }
        return lines;
    }

    public boolean matches(WorkbenchBlockEntity workbench, @Nonnull Level level) {
        if (!workbench.Workbench.PartRecipeCanBeCraftedInThisWorkbench(this.Result)) {
            return false;
        }
        int[] amountsMatched = new int[this.InputIngredients.size()];
        block0: for (int slot = 0; slot < workbench.Workbench.PartCraftingInputContainer.m_6643_(); ++slot) {
            ItemStack inputStack = workbench.Workbench.PartCraftingInputContainer.m_8020_(slot);
            int countRemaining = inputStack.m_41613_();
            for (int i = 0; i < this.InputIngredients.size(); ++i) {
                Ingredient ingredientToTest = (Ingredient)this.InputIngredients.get(i);
                if (ingredientToTest.test(inputStack)) {
                    int n = i;
                    amountsMatched[n] = amountsMatched[n] + 1;
                    --countRemaining;
                }
                if (countRemaining <= 0) continue block0;
            }
        }
        for (int i = 0; i < this.InputIngredients.size(); ++i) {
            Ingredient ingredientToTest = (Ingredient)this.InputIngredients.get(i);
            if (amountsMatched[i] > 0) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull WorkbenchBlockEntity distiller, @Nonnull RegistryAccess registryAccess) {
        return this.Result.m_41777_();
    }

    public String toString() {
        return "PartFabRecipe: " + this.Loc;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FlansMod.PART_FABRICATION_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<PartFabricationRecipe> {
        @Nonnull
        public PartFabricationRecipe fromJson(@Nonnull ResourceLocation loc, @Nonnull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonArray ingredientArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            Ingredient[] ingredients = new Ingredient[ingredientArray.size()];
            for (int i = 0; i < ingredientArray.size(); ++i) {
                ingredients[i] = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int craftTime = GsonHelper.m_13824_((JsonObject)json, (String)"craft_time", (int)20);
            return new PartFabricationRecipe((RecipeType)FlansMod.PART_FABRICATION_RECIPE_TYPE.get(), loc, group, ingredients, output, craftTime);
        }

        @Nullable
        public PartFabricationRecipe fromNetwork(@Nonnull ResourceLocation loc, @Nonnull FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            int count = buf.readInt();
            Ingredient[] inputs = new Ingredient[count];
            for (int i = 0; i < count; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.m_130267_();
            int time = buf.readInt();
            StringBuilder sb = new StringBuilder("PartFab from Net: ");
            sb.append(loc).append(", ").append(group).append(", ").append(count).append(", ");
            for (Ingredient input : inputs) {
                sb.append(input.m_43942_()).append(", ");
            }
            FlansMod.LOGGER.info(sb.append(output).append(", ").append(time).toString());
            return new PartFabricationRecipe((RecipeType)FlansMod.PART_FABRICATION_RECIPE_TYPE.get(), loc, group, inputs, output, time);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull PartFabricationRecipe recipe) {
            buf.m_130070_(recipe.Group);
            buf.writeInt(recipe.InputIngredients.size());
            for (int i = 0; i < recipe.InputIngredients.size(); ++i) {
                ((Ingredient)recipe.InputIngredients.get(i)).m_43923_(buf);
            }
            buf.m_130055_(recipe.Result);
            buf.writeInt(recipe.CraftTime);
        }
    }
}

