/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity;

import com.flansmod.common.entity.ENpcRelationship;
import com.flansmod.common.entity.INpcRelationshipsCapability;
import com.flansmod.common.entity.NpcRelationshipsCapability;
import com.flansmod.common.types.elements.EDamageSourceType;
import com.flansmod.common.types.npc.NpcDefinition;
import com.flansmod.common.types.npc.elements.ENpcActionType;
import com.flansmod.common.types.npc.elements.EVoiceLineType;
import com.flansmod.common.types.npc.elements.MerchantOfferDefinition;
import com.flansmod.common.types.npc.elements.VoiceLineDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public abstract class ShopkeeperEntity
extends PathfinderMob
implements Npc,
Merchant {
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.m_135353_(ShopkeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);
    @Nullable
    private Player TradingWithPlayer;
    public List<Player> PlayersInRange = new ArrayList<Player>();
    @Nullable
    private MerchantOffers Offers;
    @Nullable
    private BlockPos WanderAroundBlock;
    private final NonNullList<ItemStack> HandItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> ArmourItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected static final double CHAT_RADIUS = 10.0;

    public abstract NpcDefinition GetDef();

    public ShopkeeperEntity(EntityType<? extends ShopkeeperEntity> entityType, Level level) {
        super(entityType, level);
        NpcDefinition def = this.GetDef();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35585_, 1));
    }

    public void m_7380_(@Nonnull CompoundTag tags) {
        super.m_7380_(tags);
        MerchantOffers merchantoffers = this.m_6616_();
        if (!merchantoffers.isEmpty()) {
            tags.m_128365_("Offers", (Tag)merchantoffers.m_45388_());
        }
        if (this.WanderAroundBlock != null) {
            tags.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.WanderAroundBlock));
        }
    }

    public void m_7378_(@Nonnull CompoundTag tags) {
        super.m_7378_(tags);
        if (tags.m_128425_("Offers", 10)) {
            this.Offers = new MerchantOffers(tags.m_128469_("Offers"));
        }
        if (tags.m_128441_("WanderTarget")) {
            this.WanderAroundBlock = NbtUtils.m_129239_((CompoundTag)tags.m_128469_("WanderTarget"));
        }
    }

    @Nonnull
    public Iterable<ItemStack> m_6168_() {
        return this.ArmourItems;
    }

    @Nonnull
    public ItemStack m_6844_(@Nonnull EquipmentSlot slot) {
        if (slot.m_254934_()) {
            return (ItemStack)this.ArmourItems.get(slot.m_20749_());
        }
        return (ItemStack)this.HandItems.get(slot.m_20749_());
    }

    public void m_8061_(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        if (slot.m_254934_()) {
            this.ArmourItems.set(slot.m_20749_(), (Object)stack);
        } else {
            this.HandItems.set(slot.m_20749_(), (Object)stack);
        }
    }

    @Nonnull
    public HumanoidArm m_5737_() {
        NpcDefinition def = this.GetDef();
        return def != null && !def.isRightHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public void m_7189_(@Nullable Player player) {
        this.TradingWithPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.TradingWithPlayer;
    }

    public boolean IsTrading() {
        return this.TradingWithPlayer != null;
    }

    @Nonnull
    public MerchantOffers m_6616_() {
        this.RefreshTrades();
        return this.Offers;
    }

    public void m_6255_(@Nonnull MerchantOffers offers) {
        this.Offers = offers;
    }

    public void m_6996_(@Nonnull MerchantOffer offer) {
        int resultCount;
        int inputCount = offer.m_45358_().m_41613_() + offer.m_45364_().m_41613_();
        if (inputCount >= (resultCount = offer.m_45368_().m_41613_())) {
            this.TryPlayVoiceLine(EVoiceLineType.SoldToPlayer);
        } else {
            this.TryPlayVoiceLine(EVoiceLineType.BoughtFromPlayer);
        }
    }

    public void m_7713_(@Nonnull ItemStack stack) {
    }

    private void RefreshTrades() {
        NpcDefinition def;
        if (this.Offers == null) {
            this.Offers = new MerchantOffers();
        }
        if ((def = this.GetDef()).IsValid() && def.maxMerchantLevel > 0) {
            ArrayList<MerchantOfferDefinition> validOffers = new ArrayList<MerchantOfferDefinition>();
            float totalWeight = 0.0f;
            for (MerchantOfferDefinition offerDef : def.offers) {
                validOffers.add(offerDef);
                totalWeight += offerDef.weighting;
            }
            block1: while (this.Offers.size() < def.maxOffersToGive && validOffers.size() > 0) {
                float pick = this.f_19796_.m_188501_() * totalWeight;
                for (int i = 0; i < validOffers.size(); ++i) {
                    MerchantOfferDefinition offerDef = (MerchantOfferDefinition)validOffers.get(i);
                    if (pick <= offerDef.weighting) {
                        ItemStack stackA = offerDef.inputs.length >= 1 ? offerDef.inputs[0].CreateStack() : ItemStack.f_41583_;
                        ItemStack stackB = offerDef.inputs.length >= 2 ? offerDef.inputs[1].CreateStack() : ItemStack.f_41583_;
                        this.Offers.add((Object)new MerchantOffer(stackA, stackB, offerDef.output.CreateStack(), 0, offerDef.maxUses, offerDef.merchantXP, offerDef.priceMultiplier, offerDef.demand));
                        validOffers.remove(i);
                        totalWeight -= offerDef.weighting;
                        continue block1;
                    }
                    pick -= offerDef.weighting;
                }
            }
        }
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xp) {
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }

    @Nullable
    private VoiceLineDefinition PickVoiceLine(EVoiceLineType voiceLineType) {
        ArrayList<VoiceLineDefinition> validVoiceLines = new ArrayList<VoiceLineDefinition>();
        NpcDefinition def = this.GetDef();
        if (def.IsValid()) {
            for (VoiceLineDefinition voiceLineDefinition : def.voiceLines) {
                if (voiceLineDefinition.type != voiceLineType) continue;
                validVoiceLines.add(voiceLineDefinition);
            }
        }
        if (validVoiceLines.size() > 0) {
            return (VoiceLineDefinition)validVoiceLines.get(this.f_19796_.m_188503_(validVoiceLines.size()));
        }
        return null;
    }

    private void TryPlayVoiceLine(@Nonnull EVoiceLineType voiceLineType) {
        this.TryPlayVoiceLineWithFallback(voiceLineType, null);
    }

    private void TryPlayVoiceLineWithFallback(@Nonnull EVoiceLineType voiceLineType, @Nullable SoundEvent fallbackSound) {
        VoiceLineDefinition voiceLine = this.PickVoiceLine(voiceLineType);
        if (voiceLine != null) {
            this.PlayVoiceLine(voiceLine);
        } else if (fallbackSound != null) {
            this.m_216990_(fallbackSound);
        }
    }

    private void PlayVoiceLine(VoiceLineDefinition voiceLine) {
        voiceLine.audioClip.PlayUnLODed(this.m_9236_(), this.m_20182_());
        for (Player player : this.m_9236_().m_45955_(TargetingConditions.m_148353_(), (LivingEntity)this, this.m_20191_().m_82400_(50.0))) {
            player.m_213846_((Component)Component.m_237115_((String)voiceLine.unlocalisedString));
        }
    }

    @Nonnull
    public SoundEvent m_7596_() {
        return SoundEvents.f_12538_;
    }

    public void m_8032_() {
    }

    protected void m_6677_(@Nonnull DamageSource source) {
        this.TryPlayVoiceLine(EVoiceLineType.Hurt);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public void m_6667_(@Nonnull DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player playerKilledMe = (Player)entity;
            this.SetRelationshipTo(playerKilledMe, ENpcRelationship.Hostile);
        }
        this.TryPlayVoiceLine(EVoiceLineType.Die);
        super.m_6667_(source);
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        this.TryPlayVoiceLine(EVoiceLineType.Hurt);
        if (entity instanceof Player) {
            Player playerHurtMe = (Player)entity;
            this.SetRelationshipTo(playerHurtMe, ENpcRelationship.Hostile);
        }
        if (this.GetDef().Can(ENpcActionType.Hostile_TeleportAway)) {
            this.TeleportAway();
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        NpcDefinition npcDef = this.GetDef();
        if (npcDef != null) {
            EDamageSourceType sourceType = EDamageSourceType.MatchType(source);
            return npcDef.IsInvulnerableTo(sourceType);
        }
        return false;
    }

    public void TeleportAway() {
        this.TryPlayVoiceLine(EVoiceLineType.Goodbye);
        for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(50.0))) {
            this.OnLeavePlayer(player);
        }
        this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (this.m_6084_() && !this.IsTrading() && !this.m_5803_() && !player.m_36341_()) {
            boolean hasNoOffers = this.m_6616_().isEmpty();
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (hasNoOffers) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), this.GetLevelForPlayer(player));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void OnLeavePlayer(Player player) {
        ENpcRelationship relationship = this.GetRelationshipTo(player);
        switch (relationship) {
            case Hostile: {
                this.SetCooldownForPlayer(player, this.GetDef().CooldownTicks(false));
                this.SetRelationshipTo(player, ENpcRelationship.PreviouslyMetHostile);
                break;
            }
            case Friendly: 
            case NotMet: {
                this.SetCooldownForPlayer(player, this.GetDef().CooldownTicks(true));
                this.SetRelationshipTo(player, ENpcRelationship.PreviouslyMetFriendly);
            }
        }
    }

    public int GetLevelForPlayer(Player player) {
        LazyOptional relationshipsCap = player.getCapability(NpcRelationshipsCapability.INSTANCE, Direction.UP);
        if (relationshipsCap.isPresent() && relationshipsCap.resolve().isPresent()) {
            return ((INpcRelationshipsCapability)relationshipsCap.resolve().get()).GetLevel(this.GetDef().Location);
        }
        return 0;
    }

    public ENpcRelationship GetRelationshipTo(Player player) {
        LazyOptional relationshipsCap = player.getCapability(NpcRelationshipsCapability.INSTANCE, Direction.UP);
        if (relationshipsCap.isPresent() && relationshipsCap.resolve().isPresent()) {
            return ((INpcRelationshipsCapability)relationshipsCap.resolve().get()).GetRelationship(this.GetDef().Location);
        }
        return ENpcRelationship.NotMet;
    }

    public void SetRelationshipTo(Player player, ENpcRelationship relationship) {
        LazyOptional relationshipsCap = player.getCapability(NpcRelationshipsCapability.INSTANCE, Direction.UP);
        relationshipsCap.ifPresent(relationships -> relationships.SetRelationship(this.GetDef().Location, relationship));
    }

    public void SetCooldownForPlayer(Player player, int cooldown) {
        LazyOptional relationshipsCap = player.getCapability(NpcRelationshipsCapability.INSTANCE, Direction.UP);
        relationshipsCap.ifPresent(relationships -> relationships.SetEndCooldownTick(this.GetDef().Location, this.m_9236_().m_46467_() + (long)cooldown));
    }

    public void SetWanderAround(@Nullable BlockPos pos) {
        this.WanderAroundBlock = pos;
    }

    @Nullable
    public BlockPos GetWanderAround() {
        return this.WanderAroundBlock;
    }

    protected void m_8099_() {
        NpcDefinition def = this.GetDef();
        this.f_21345_.m_25352_(0, (Goal)new Goodbye(this, EVoiceLineType.Goodbye));
        this.f_21345_.m_25352_(1, (Goal)new Hello(this, EVoiceLineType.Hello));
        this.f_21345_.m_25352_(1, (Goal)new Hello(this, EVoiceLineType.HelloHappy));
        this.f_21345_.m_25352_(1, (Goal)new Hello(this, EVoiceLineType.HelloUnhappy));
        if (def.Can(ENpcActionType.Hostile_TeleportAway)) {
            this.f_21345_.m_25352_(2, (Goal)new TeleportAway(this));
        }
        if (def.Can(ENpcActionType.Hostile_Retaliate)) {
            this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        }
        if (def.Can(ENpcActionType.Neutral_Wander)) {
            this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        }
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (def.Can(ENpcActionType.Neutral_LookAtPlayer)) {
            this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        }
        if (def.Can(ENpcActionType.Neutral_Idle)) {
            this.f_21345_.m_25352_(10, (Goal)new Talk(this, EVoiceLineType.Chat));
        }
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private static class Goodbye
    extends Goal {
        private final EVoiceLineType VoiceLineType;
        private final ShopkeeperEntity Shopkeeper;
        private Player TalkToTarget;

        public Goodbye(ShopkeeperEntity shopkeeper, EVoiceLineType type) {
            this.Shopkeeper = shopkeeper;
            this.VoiceLineType = type;
        }

        public boolean m_8036_() {
            for (Player previous : this.Shopkeeper.PlayersInRange) {
                if (!previous.m_21224_() && !previous.m_213877_() && !(previous.m_20280_((Entity)this.Shopkeeper) > 100.0) || this.Shopkeeper.GetRelationshipTo(previous) != ENpcRelationship.Friendly) continue;
                this.TalkToTarget = previous;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.Shopkeeper.m_21563_().m_148051_((Entity)this.TalkToTarget);
            ENpcRelationship relationship = this.Shopkeeper.GetRelationshipTo(this.TalkToTarget);
            switch (relationship) {
                case Friendly: {
                    this.Shopkeeper.SetRelationshipTo(this.TalkToTarget, ENpcRelationship.PreviouslyMetFriendly);
                    break;
                }
                case NotMet: {
                    this.Shopkeeper.SetRelationshipTo(this.TalkToTarget, ENpcRelationship.NotMet);
                    break;
                }
                case Hostile: {
                    this.Shopkeeper.SetRelationshipTo(this.TalkToTarget, ENpcRelationship.PreviouslyMetHostile);
                }
            }
            if (relationship == ENpcRelationship.Friendly) {
                this.Shopkeeper.TryPlayVoiceLine(this.VoiceLineType);
            }
            this.Shopkeeper.PlayersInRange.remove(this.TalkToTarget);
        }
    }

    private static class Hello
    extends Goal {
        private final EVoiceLineType VoiceLineType;
        private final ShopkeeperEntity Shopkeeper;
        private Player TalkToTarget;

        public Hello(ShopkeeperEntity shopkeeper, EVoiceLineType type) {
            this.Shopkeeper = shopkeeper;
            this.VoiceLineType = type;
        }

        public boolean m_8036_() {
            for (Player player : this.Shopkeeper.m_9236_().m_45955_(TargetingConditions.m_148353_(), (LivingEntity)this.Shopkeeper, this.Shopkeeper.m_20191_().m_82400_(10.0))) {
                if (this.Shopkeeper.PlayersInRange.contains(player)) continue;
                ENpcRelationship relationship = this.Shopkeeper.GetRelationshipTo(player);
                this.TalkToTarget = player;
                switch (relationship) {
                    case NotMet: {
                        return this.VoiceLineType == EVoiceLineType.Hello;
                    }
                    case Friendly: {
                        return this.VoiceLineType == EVoiceLineType.HelloHappy;
                    }
                    case Hostile: {
                        return this.VoiceLineType == EVoiceLineType.HelloUnhappy;
                    }
                }
            }
            return false;
        }

        public void m_8056_() {
            this.Shopkeeper.m_21563_().m_148051_((Entity)this.TalkToTarget);
            this.Shopkeeper.TryPlayVoiceLine(this.VoiceLineType);
            this.Shopkeeper.SetRelationshipTo(this.TalkToTarget, ENpcRelationship.Friendly);
        }
    }

    private static class TeleportAway
    extends Goal {
        public final ShopkeeperEntity Shopkeeper;

        public TeleportAway(ShopkeeperEntity shopkeeper) {
            this.Shopkeeper = shopkeeper;
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity livingEntity;
            return this.Shopkeeper.GetDef().Can(ENpcActionType.Hostile_TeleportAway) && (livingEntity = this.Shopkeeper.m_5448_()) instanceof Player && this.Shopkeeper.GetRelationshipTo(player = (Player)livingEntity) == ENpcRelationship.Hostile;
        }

        public void m_8056_() {
            this.Shopkeeper.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            this.Shopkeeper.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    private static class Talk
    extends Goal {
        private final EVoiceLineType VoiceLineType;
        private final ShopkeeperEntity Shopkeeper;
        private Player TalkToTarget;
        private int Cooldown = 0;

        public Talk(ShopkeeperEntity shopkeeper, EVoiceLineType type) {
            this.Shopkeeper = shopkeeper;
            this.VoiceLineType = type;
        }

        public boolean m_8036_() {
            this.TalkToTarget = this.Shopkeeper.m_9236_().m_45930_((Entity)this.Shopkeeper, 10.0);
            if (this.TalkToTarget != null) {
                ENpcRelationship relationship = this.Shopkeeper.GetRelationshipTo(this.TalkToTarget);
                switch (this.VoiceLineType) {
                    case Chat: 
                    case SoldToPlayer: 
                    case BoughtFromPlayer: {
                        return relationship == ENpcRelationship.Friendly;
                    }
                }
            }
            return false;
        }

        public boolean m_6767_() {
            return true;
        }

        public boolean m_8045_() {
            return this.Cooldown > 0;
        }

        public void m_8056_() {
            this.Cooldown = 200;
            this.Shopkeeper.TryPlayVoiceLine(this.VoiceLineType);
        }

        public void m_8037_() {
            if (this.TalkToTarget != null) {
                this.Shopkeeper.m_21563_().m_148051_((Entity)this.TalkToTarget);
            }
            --this.Cooldown;
        }
    }
}

