/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle;

import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;

public class PerPartMap<T> {
    @Nonnull
    private final Map<Integer, T> Values = new HashMap<Integer, T>();

    @Nonnull
    public Set<Integer> HashKeys() {
        return this.Values.keySet();
    }

    @Nonnull
    public Collection<T> Values() {
        return this.Values.values();
    }

    @Nonnull
    public Set<Map.Entry<Integer, T>> EntrySet() {
        return this.Values.entrySet();
    }

    @Nonnull
    public <R> R ApplyOrDefault(int hash, @Nonnull Function<T, R> func, @Nonnull R defaultValue) {
        if (this.Values.containsKey(hash)) {
            return func.apply(this.Values.get(hash));
        }
        return defaultValue;
    }

    @Nonnull
    public T GetOrDefault(int hash, @Nonnull T defaultValue) {
        return this.Values.getOrDefault(hash, defaultValue);
    }

    @Nullable
    public T ForHash(int hash) {
        return this.Values.get(hash);
    }

    public void Put(int hash, @Nonnull T value) {
        this.Values.put(hash, value);
    }

    public void ApplyTo(int hash, @Nonnull Consumer<T> applyFunc) {
        if (this.Values.containsKey(hash)) {
            applyFunc.accept(this.Values.get(hash));
        }
    }

    @Nonnull
    public Optional<T> TryGet(int hash) {
        return Optional.ofNullable(this.Values.get(hash));
    }

    @Nonnull
    public <R> R ApplyOrDefault(@Nonnull VehicleComponentPath componentPath, @Nonnull Function<T, R> func, @Nonnull R defaultValue) {
        return this.ApplyOrDefault(componentPath.hashCode(), func, defaultValue);
    }

    @Nonnull
    public T GetOrDefault(@Nonnull VehicleComponentPath componentPath, @Nonnull T defaultValue) {
        return this.GetOrDefault(componentPath.hashCode(), defaultValue);
    }

    @Nullable
    public T ForPart(@Nonnull VehicleComponentPath componentPath) {
        return this.ForHash(componentPath.hashCode());
    }

    @Nonnull
    public Optional<T> TryGet(@Nonnull VehicleComponentPath componentPath) {
        return this.TryGet(componentPath.hashCode());
    }

    public void Put(@Nonnull VehicleComponentPath componentPath, @Nonnull T value) {
        this.Put(componentPath.hashCode(), value);
    }

    public void ApplyTo(@Nonnull VehicleComponentPath componentPath, @Nonnull Consumer<T> applyFunc) {
        this.ApplyTo(componentPath.hashCode(), applyFunc);
    }

    public void CreateAndApply(@Nonnull VehicleComponentPath componentPath, @Nonnull Supplier<T> createFunc, @Nonnull Consumer<T> applyFunc) {
        int hash = componentPath.hashCode();
        if (!this.Values.containsKey(hash)) {
            this.Values.put(hash, createFunc.get());
        }
        applyFunc.accept(this.Values.get(hash));
    }

    public boolean equals(Object other) {
        if (other instanceof PerPartMap) {
            PerPartMap otherMap = (PerPartMap)other;
            return this.Values.equals(otherMap.Values);
        }
        return false;
    }

    public static <TDataType> EntityDataSerializer<PerPartMap<TDataType>> SERIALIZER(final @Nonnull EntityDataSerializer<TDataType> elementSerializer) {
        return new EntityDataSerializer.ForValueType<PerPartMap<TDataType>>(){

            public void write(@Nonnull FriendlyByteBuf buf, @Nonnull PerPartMap<TDataType> data) {
                buf.writeInt(data.Values.size());
                for (Map.Entry kvp : data.Values.entrySet()) {
                    buf.writeInt(kvp.getKey().intValue());
                    elementSerializer.m_6856_(buf, kvp.getValue());
                }
            }

            @Nonnull
            public PerPartMap<TDataType> read(@Nonnull FriendlyByteBuf buf) {
                int numEntries = buf.readInt();
                PerPartMap map = new PerPartMap();
                for (int i = 0; i < numEntries; ++i) {
                    int hash = buf.readInt();
                    Object element = elementSerializer.m_6709_(buf);
                    map.Values.put(hash, element);
                }
                return map;
            }
        };
    }
}

