/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.controls;

import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.controls.ControlLogic;
import com.flansmod.common.entity.vehicle.controls.VehicleInputState;
import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.EVehicleAxis;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.physics.common.units.IAcceleration;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LegacyVehicleControlLogic
extends ControlLogic {
    private static final VehicleComponentPath SingleEngineKey = VehicleComponentPath.of(VehiclePartPath.Core, EPartDefComponent.Engine, 0);
    private static final VehiclePartPath FrontRightWheelPart = VehiclePartPath.of("front_right_wheel");
    private static final VehiclePartPath BackRightWheelPart = VehiclePartPath.of("back_right_wheel");
    private static final VehiclePartPath FrontLeftWheelPart = VehiclePartPath.of("front_left_wheel");
    private static final VehiclePartPath BackLeftWheelPart = VehiclePartPath.of("back_left_wheel");
    private static final VehicleComponentPath FrontRightWheelDamageable = VehicleComponentPath.of(FrontRightWheelPart, EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath BackRightWheelDamageable = VehicleComponentPath.of(BackRightWheelPart, EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath FrontLeftWheelDamageable = VehicleComponentPath.of(FrontLeftWheelPart, EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath BackLeftWheelDamageable = VehicleComponentPath.of(BackLeftWheelPart, EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath[] DefaultWheels = new VehicleComponentPath[]{VehicleComponentPath.of(FrontRightWheelPart, EPartDefComponent.Wheel, 0), VehicleComponentPath.of(BackRightWheelPart, EPartDefComponent.Wheel, 1), VehicleComponentPath.of(FrontLeftWheelPart, EPartDefComponent.Wheel, 2), VehicleComponentPath.of(BackLeftWheelPart, EPartDefComponent.Wheel, 3)};
    public final boolean Tank;
    public float wheelsYaw;
    private static final float g = 0.098000005f;
    private static final Vec3 GRAVITY = new Vec3(0.0, -0.09800000488758087, 0.0);
    private static final float unbreakableBlockDamage = 100.0f;
    private static final float collisionForce = 30.0f;

    public LegacyVehicleControlLogic(@Nonnull ControlSchemeDefinition def, boolean tank) {
        super(def);
        this.Tank = tank;
    }

    @Override
    public boolean CanControl(@Nonnull VehicleDefinition vehicleDef) {
        int numWheels = vehicleDef.AsHierarchy().NumWheels();
        return numWheels == 4;
    }

    @Override
    public void TickAuthoritative(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        this.TickShared(vehicle, inputs);
    }

    @Override
    public void TickRemote(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        this.TickShared(vehicle, inputs);
    }

    private void TickShared(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        Player player;
        LivingEntity livingEntity;
        this.wheelsYaw *= 0.9f;
        if (this.wheelsYaw > 20.0f) {
            this.wheelsYaw = 20.0f;
        }
        if (this.wheelsYaw < -20.0f) {
            this.wheelsYaw = -20.0f;
        }
        Player driver = (livingEntity = vehicle.m_6688_()) instanceof Player ? (player = (Player)livingEntity) : null;
        Vec3 amountToMoveCar = Vec3.f_82478_;
        float throttle = inputs.GetValue(EVehicleAxis.Accelerator);
        float steering = inputs.GetValue(EVehicleAxis.Yaw);
        float engineSpeed = vehicle.GetEngineDef((VehicleComponentPath)LegacyVehicleControlLogic.SingleEngineKey).maxSpeed;
        List<IAcceleration> coreForces = vehicle.GetCoreForces();
        vehicle.m_6478_(MoverType.PLAYER, amountToMoveCar);
        this.CheckForCollisions(vehicle);
    }

    private void CheckForCollisions(@Nonnull VehicleEntity vehicle) {
        boolean crashInWater = false;
        double speed = vehicle.m_20184_().m_82553_();
        Level level = vehicle.m_9236_();
    }
}

