/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.modules;

import com.flansmod.common.entity.vehicle.PerPartMap;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleDefinitionHierarchy;
import com.flansmod.common.entity.vehicle.save.DamageSyncState;
import com.flansmod.common.types.vehicles.elements.DamageablePartDefinition;
import com.flansmod.physics.common.util.Maths;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;

public interface IVehicleDamageHelper {
    @Nonnull
    public VehicleDefinitionHierarchy GetHierarchy();

    @Nonnull
    public PerPartMap<DamageSyncState> GetDamageMap();

    public void SetDamageMap(@Nonnull PerPartMap<DamageSyncState> var1);

    @Nonnull
    public DamageablePartDefinition GetDef(@Nonnull VehicleComponentPath var1);

    default public float GetHealthOf(@Nonnull VehicleComponentPath partName) {
        return this.GetDamageMap().ApplyOrDefault(partName, DamageSyncState::Health, Float.valueOf(0.0f)).floatValue();
    }

    default public void SetHealthOf(@Nonnull VehicleComponentPath partName, float health) {
        PerPartMap<DamageSyncState> map = this.GetDamageMap();
        map.Put(partName, new DamageSyncState(health));
        this.SetDamageMap(map);
    }

    default public float GetMaxHealthOf(@Nonnull VehicleComponentPath partName) {
        return this.GetDef((VehicleComponentPath)partName).maxHealth;
    }

    default public float GetMaxHealth() {
        AtomicReference<Float> maxHealth = new AtomicReference<Float>(Float.valueOf(0.0f));
        this.GetHierarchy().ForEachDamageable((partPath, dmgDef) -> maxHealth.updateAndGet(v -> Float.valueOf(v.floatValue() + dmgDef.maxHealth)));
        return maxHealth.get().floatValue();
    }

    default public float GetTotalHealth() {
        float totalHealth = 0.0f;
        PerPartMap<DamageSyncState> map = this.GetDamageMap();
        for (DamageSyncState damageState : map.Values()) {
            totalHealth += damageState.Health();
        }
        return totalHealth;
    }

    @Nonnull
    default public DamageablePartDefinition GetCoreDamageDef() {
        return this.GetHierarchy().RootNode.Def.damage;
    }

    default public boolean HasDamageablePart(@Nonnull VehicleComponentPath partPath) {
        return this.GetHierarchy().FindDamageable(partPath).isPresent();
    }

    @Nonnull
    default public VehicleComponentPath DamageableOrElseCore(@Nonnull VehicleComponentPath partName) {
        return this.HasDamageablePart(partName) ? partName : VehicleComponentPath.coreDamage;
    }

    default public boolean IsPartDestroyed(@Nonnull VehicleComponentPath partName) {
        return this.HasDamageablePart(partName) && this.GetHealthOf(partName) <= 0.0f;
    }

    default public float ApplyDamageTo(@Nonnull VehicleComponentPath partName, @Nonnull DamageSource source, float amount) {
        VehicleComponentPath partToDamage = this.DamageableOrElseCore(partName);
        float damageToDeal = Maths.max(this.GetHealthOf(partToDamage) - amount, 0.0f);
        this.SetHealthOf(partToDamage, damageToDeal);
        return amount - damageToDeal;
    }
}

