/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.modules;

import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleDefinitionHierarchy;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.physics.common.util.ITransformPair;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public interface IVehicleTransformHelpers {
    @Nonnull
    public VehicleDefinitionHierarchy GetHierarchy();

    @Nonnull
    public Transform GetRootTransformCurrent();

    @Nonnull
    public Transform GetRootTransformPrevious();

    public void SetRootTransformCurrent(@Nonnull Transform var1);

    public void ApplyWorldToRootPrevious(@Nonnull TransformStack var1);

    public void ApplyWorldToRootCurrent(@Nonnull TransformStack var1);

    public void ApplyPartToPartPrevious(@Nonnull VehiclePartPath var1, @Nonnull TransformStack var2);

    public void ApplyPartToPartCurrent(@Nonnull VehiclePartPath var1, @Nonnull TransformStack var2);

    public void ApplyPartToComponentPrevious(@Nonnull VehicleComponentPath var1, @Nonnull TransformStack var2);

    public void ApplyPartToComponentCurrent(@Nonnull VehicleComponentPath var1, @Nonnull TransformStack var2);

    default public void Traverse(@Nonnull VehiclePartPath path, @Nonnull Consumer<VehicleDefinitionHierarchy.VehicleNode> func) {
        this.GetHierarchy().FromRootToNode(path, func);
    }

    default public void SetPosition(double x, double y, double z) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().withPosition(x, y, z));
    }

    default public void SetPosition(@Nonnull Vec3 pos) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().withPosition(pos));
    }

    default public void SetYaw(float yaw) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().withYaw(yaw));
    }

    default public void SetPitch(float pitch) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().withPitch(pitch));
    }

    default public void SetRoll(float roll) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().withRoll(roll));
    }

    default public void RotateYaw(float yaw) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().rotateYaw(yaw));
    }

    default public void RotatePitch(float pitch) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().rotatePitch(pitch));
    }

    default public void RotateRoll(float roll) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().rotateRoll(roll));
    }

    default public void SetEulerAngles(float pitch, float yaw, float roll) {
        this.SetRootTransformCurrent(this.GetRootTransformCurrent().withEulerAngles(pitch, yaw, roll));
    }

    @Nonnull
    default public Transform GetWorldToRootPrevious() {
        return Transform.flatten(this::ApplyWorldToRootPrevious);
    }

    @Nonnull
    default public Transform GetWorldToRootCurrent() {
        return Transform.flatten(this::ApplyWorldToRootCurrent);
    }

    @Nonnull
    default public ITransformPair GetWorldToRoot() {
        return ITransformPair.of(this::GetWorldToRootPrevious, this::GetWorldToRootCurrent);
    }

    @Nonnull
    default public Transform GetPartToPartPrevious(@Nonnull VehiclePartPath childPart) {
        return Transform.flatten(stack -> this.ApplyPartToPartPrevious(childPart, (TransformStack)stack));
    }

    @Nonnull
    default public Transform GetPartToPartCurrent(@Nonnull VehiclePartPath childPart) {
        return Transform.flatten(stack -> this.ApplyPartToPartCurrent(childPart, (TransformStack)stack));
    }

    @Nonnull
    default public Transform GetPartToComponentPrevious(@Nonnull VehicleComponentPath componentPath) {
        return Transform.flatten(stack -> this.ApplyPartToComponentPrevious(componentPath, (TransformStack)stack));
    }

    @Nonnull
    default public Transform GetPartToComponentCurrent(@Nonnull VehicleComponentPath componentPath) {
        return Transform.flatten(stack -> this.ApplyPartToComponentCurrent(componentPath, (TransformStack)stack));
    }

    @Nonnull
    default public ITransformPair GetPartToPart(@Nonnull VehiclePartPath childPart) {
        return ITransformPair.of(() -> this.GetPartToPartPrevious(childPart), () -> this.GetPartToPartCurrent(childPart));
    }

    @Nonnull
    default public ITransformPair GetPartToComponent(@Nonnull VehicleComponentPath componentPath) {
        return ITransformPair.of(() -> this.GetPartToComponentPrevious(componentPath), () -> this.GetPartToComponentCurrent(componentPath));
    }

    default public void TransformRootToPartPrevious(@Nonnull VehiclePartPath vehiclePart, @Nonnull TransformStack stack) {
        this.Traverse(vehiclePart, node -> stack.add(this.GetPartToPartPrevious(vehiclePart)));
    }

    @Nonnull
    default public Transform GetRootToPartPrevious(@Nonnull VehiclePartPath vehiclePart) {
        return Transform.flatten(stack -> this.TransformRootToPartPrevious(vehiclePart, (TransformStack)stack));
    }

    default public void TransformRootToPartCurrent(@Nonnull VehiclePartPath vehiclePart, @Nonnull TransformStack stack) {
        this.Traverse(vehiclePart, node -> stack.add(this.GetPartToPartCurrent(vehiclePart)));
    }

    @Nonnull
    default public Transform GetRootToPartCurrent(@Nonnull VehiclePartPath vehiclePart) {
        return Transform.flatten(stack -> this.TransformRootToPartCurrent(vehiclePart, (TransformStack)stack));
    }

    @Nonnull
    default public ITransformPair GetRootToPart(@Nonnull VehiclePartPath vehiclePart) {
        return ITransformPair.of(() -> this.GetRootToPartPrevious(vehiclePart), () -> this.GetRootToPartCurrent(vehiclePart));
    }

    @Nonnull
    default public ITransformPair GetWorldToPart(@Nonnull VehiclePartPath apPath) {
        return ITransformPair.compose(this.GetWorldToRoot(), this.GetRootToPart(apPath));
    }

    @Nonnull
    default public Transform GetWorldToPartPrevious(@Nonnull VehiclePartPath apPath) {
        return this.GetWorldToPart(apPath).previous();
    }

    @Nonnull
    default public Transform GetWorldToPartCurrent(@Nonnull VehiclePartPath apPath) {
        return this.GetWorldToPart(apPath).current();
    }

    @Nonnull
    default public ITransformPair GetWorldToPart(@Nonnull VehicleComponentPath apPath) {
        return ITransformPair.compose(this.GetWorldToRoot(), this.GetRootToPart(apPath.Part()));
    }

    @Nonnull
    default public Transform GetWorldToPartPrevious(@Nonnull VehicleComponentPath apPath) {
        return this.GetWorldToPart(apPath.Part()).previous();
    }

    @Nonnull
    default public Transform GetWorldToPartCurrent(@Nonnull VehicleComponentPath apPath) {
        return this.GetWorldToPart(apPath.Part()).current();
    }

    default public void Raycast(@Nonnull Vec3 start, @Nonnull Vec3 end, float dt, @Nonnull BiConsumer<VehiclePartPath, Vec3> func) {
        if (this.GetHierarchy().RootNode != null) {
            TransformStack stack = TransformStack.of(this.GetWorldToRoot().delta(dt));
            this.Raycast(stack, this.GetHierarchy().RootNode, start, end, dt, func);
        }
    }

    default public void Raycast(@Nonnull TransformStack stack, @Nonnull VehicleDefinitionHierarchy.VehicleNode node, @Nonnull Vec3 start, @Nonnull Vec3 end, float dt, @Nonnull BiConsumer<VehiclePartPath, Vec3> func) {
        Object articulation;
        stack.push();
        if (node.Def.IsArticulated() && !((Transform)(articulation = this.GetPartToPart(node.GetPath()).delta(dt))).isIdentity()) {
            start = ((Transform)articulation).globalToLocalPosition(start);
            end = ((Transform)articulation).globalToLocalPosition(end);
            stack.add((Transform)articulation);
        }
        for (VehicleDefinitionHierarchy.VehicleNode child : node.ChildNodes.values()) {
            this.Raycast(stack, child, start, end, dt, func);
        }
        if (node.Def.IsDamageable()) {
            stack.push();
            stack.add(Transform.fromPos(node.Def.damage.hitboxCenter));
            Vector3d hitPos = new Vector3d();
            if (Maths.rayBoxIntersect(start, end, stack.top(), node.Def.damage.hitboxHalfExtents.m_252839_(), hitPos)) {
                func.accept(node.GetPath(), new Vec3(hitPos.x, hitPos.y, hitPos.z));
            }
            stack.pop();
        }
        stack.pop();
    }
}

