/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.save;

import com.flansmod.common.entity.vehicle.IVehicleSaveNode;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.item.PartItem;
import com.flansmod.common.types.parts.PartDefinition;
import com.flansmod.common.types.parts.elements.EngineDefinition;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraftforge.common.ForgeHooks;

public class EngineSyncState
implements IVehicleSaveNode {
    public static final int NO_SLOT = -1;
    public int BurnTimeDuration = 0;
    public int BurnTimeRemaining = 0;
    public static final float ENGINE_OFF = 0.0f;
    public static final float ENGINE_IDLE = 1.0f;
    public static final float ENGINE_MAX = 2.0f;
    public float Throttle = 0.0f;
    @Nonnull
    public ItemStack EngineStack = ItemStack.f_41583_;
    @Nonnull
    public ItemStack[] SolidFuelSlots = new ItemStack[0];
    public int CurrentFE = 0;
    @Nullable
    public LiquidBlock LiquidType = null;
    public int LiquidAmount = 0;

    @Nullable
    public EngineDefinition GetEngine() {
        PartDefinition part = this.GetPart();
        return part.IsValid() ? part.engine : null;
    }

    @Nonnull
    public PartDefinition GetPart() {
        PartDefinition partDefinition;
        Item item;
        if (!this.EngineStack.m_41619_() && (item = this.EngineStack.m_41720_()) instanceof PartItem) {
            PartItem part = (PartItem)item;
            partDefinition = part.Def();
        } else {
            partDefinition = PartDefinition.INVALID;
        }
        return partDefinition;
    }

    public float GetEngineThrottle() {
        return this.Throttle;
    }

    public int GetNextBurnableSlot(@Nonnull RecipeType<?> recipeType) {
        for (int i = 0; i < this.SolidFuelSlots.length; ++i) {
            int burnTime = ForgeHooks.getBurnTime((ItemStack)this.SolidFuelSlots[i], recipeType);
            if (burnTime <= 0) continue;
            return i;
        }
        return -1;
    }

    public int CountBurnTime(@Nonnull RecipeType<?> recipeType) {
        int burnTime = 0;
        for (ItemStack solidFuelSlot : this.SolidFuelSlots) {
            burnTime += ForgeHooks.getBurnTime((ItemStack)solidFuelSlot, recipeType);
        }
        return burnTime;
    }

    public int CountBurnableItems(@Nonnull RecipeType<?> recipeType) {
        int burnables = 0;
        for (ItemStack solidFuelSlot : this.SolidFuelSlots) {
            if (ForgeHooks.getBurnTime((ItemStack)solidFuelSlot, recipeType) <= 0) continue;
            burnables += solidFuelSlot.m_41613_();
        }
        return burnables;
    }

    public int GetBurnTimeRemaining() {
        return this.BurnTimeRemaining;
    }

    public int GetBurnTimeDuration() {
        return this.BurnTimeDuration;
    }

    public int GetCurrentFE() {
        return this.CurrentFE;
    }

    public int GetLiquidAmount() {
        return this.LiquidAmount;
    }

    public void SetOff() {
        this.Throttle = 0.0f;
    }

    public void SetIdle() {
        this.Throttle = 1.0f;
    }

    public void SetFull() {
        this.Throttle = 2.0f;
    }

    public void SetBetweenOffAndFull(float parameter) {
        this.Throttle = Maths.lerpF(0.0f, 2.0f, parameter);
    }

    public void SetBetweenIdleAndFull(float parameter) {
        this.Throttle = Maths.lerpF(1.0f, 2.0f, parameter);
    }

    @Override
    public void Load(@Nonnull VehicleEntity vehicle, @Nonnull CompoundTag tags) {
        if (tags.m_128441_("item")) {
            this.EngineStack = ItemStack.m_41712_((CompoundTag)tags.m_128469_("item"));
        }
        this.BurnTimeRemaining = tags.m_128451_("burnRemaining");
        this.BurnTimeDuration = tags.m_128451_("burnDuration");
        this.Throttle = tags.m_128457_("power");
    }

    @Override
    @Nonnull
    public CompoundTag Save(@Nonnull VehicleEntity vehicle) {
        CompoundTag tags = new CompoundTag();
        tags.m_128365_("item", (Tag)this.EngineStack.m_41739_(new CompoundTag()));
        tags.m_128405_("burnRemaining", this.BurnTimeRemaining);
        tags.m_128405_("burnDuration", this.BurnTimeDuration);
        tags.m_128350_("power", this.Throttle);
        return tags;
    }
}

