/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots.snapshots;

import com.flansmod.common.gunshots.EPlayerHitArea;
import com.flansmod.common.gunshots.PlayerSnapshot;
import com.flansmod.common.item.GunItem;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CommonPlayerModel {
    private final SimpleCube head;
    private final SimpleCube hat;
    private final SimpleCube body;
    private final SimpleCube rightArm;
    private final SimpleCube leftArm;
    private final SimpleCube rightLeg;
    private final SimpleCube leftLeg;
    private float swimAmount = 0.0f;
    private boolean riding = false;
    private boolean crouching = false;
    private ArmPose leftArmPose = ArmPose.EMPTY;
    private ArmPose rightArmPose = ArmPose.EMPTY;
    private float attackTime = 0.0f;

    public CommonPlayerModel() {
        CubeDeformation deform = new CubeDeformation(0.0f);
        float height = 0.0f;
        boolean isSlim = false;
        this.head = SimpleCube.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deform).offset(0.0f, 0.0f + height, 0.0f);
        this.hat = SimpleCube.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deform.extend(0.5f)).offset(0.0f, 0.0f + height, 0.0f);
        this.body = SimpleCube.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deform).offset(0.0f, 0.0f + height, 0.0f);
        this.rightLeg = SimpleCube.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform).offset(-1.9f, 12.0f + height, 0.0f);
        float f = 0.25f;
        if (isSlim) {
            this.leftArm = SimpleCube.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, deform).offset(5.0f, 2.5f, 0.0f);
            this.rightArm = SimpleCube.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, deform).offset(-5.0f, 2.5f, 0.0f);
        } else {
            this.leftArm = SimpleCube.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform).offset(5.0f, 2.0f, 0.0f);
            this.rightArm = SimpleCube.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform).offset(-5.0f, 2.0f + height, 0.0f);
        }
        this.leftLeg = SimpleCube.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform).offset(1.9f, 12.0f, 0.0f);
    }

    public void Snap(@Nonnull Player player, @Nonnull PlayerSnapshot snap) {
        Direction direction;
        boolean shouldSit;
        snap.valid = false;
        TransformStack poseStack = TransformStack.empty();
        float p_115310_ = 0.0f;
        Vec3 vec3 = this.getRenderOffset(player, p_115310_);
        double d2 = player.m_20182_().f_82479_ + vec3.m_7096_();
        double d3 = player.m_20182_().f_82480_ + vec3.m_7098_();
        double d0 = player.m_20182_().f_82481_ + vec3.m_7094_();
        poseStack.translate(d2, d3, d0);
        this.setModelProperties(player);
        this.attackTime = player.m_21324_(p_115310_);
        this.riding = shouldSit = player.m_20159_() && player.m_20202_() != null && player.m_20202_().shouldRiderSit();
        float f = Mth.m_14189_((float)p_115310_, (float)player.f_20884_, (float)player.f_20883_);
        float f1 = Mth.m_14189_((float)p_115310_, (float)player.f_20886_, (float)player.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && player.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)player.m_20202_();
            f = Mth.m_14189_((float)p_115310_, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)p_115310_, (float)player.f_19860_, (float)player.m_146909_());
        if (player.m_217003_(Pose.SLEEPING) && (direction = player.m_21259_()) != null) {
            float f4 = player.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-direction.m_122429_()) * f4, 0.0, (float)(-direction.m_122431_()) * f4);
        }
        float f7 = this.getBob(player, p_115310_);
        this.playerSetupRotations(player, poseStack, f7, f, p_115310_);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        this.scale(poseStack);
        poseStack.translate(0.0, -1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && player.m_6084_()) {
            f8 = player.f_267362_.m_267711_(p_115310_);
            f5 = player.f_267362_.m_267590_(p_115310_);
            if (player.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.prepareMobModel(player, f5, f8, p_115310_);
        this.livingSetupAnim(player, f5, f8, f7, f2, f6);
        poseStack.push();
        this.head.Pose(poseStack);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        snap.UpdateHitbox(EPlayerHitArea.HEAD, poseStack.top(), this.head.GetHalfExtents());
        poseStack.pop();
        poseStack.push();
        this.body.Pose(poseStack);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        snap.UpdateHitbox(EPlayerHitArea.BODY, poseStack.top(), this.body.GetHalfExtents());
        poseStack.pop();
        poseStack.push();
        this.leftLeg.Pose(poseStack);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        snap.UpdateHitbox(EPlayerHitArea.LEFTLEG, poseStack.top(), this.leftLeg.GetHalfExtents());
        poseStack.pop();
        poseStack.push();
        this.rightLeg.Pose(poseStack);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        snap.UpdateHitbox(EPlayerHitArea.RIGHTLEG, poseStack.top(), this.rightLeg.GetHalfExtents());
        poseStack.pop();
        poseStack.push();
        this.leftArm.Pose(poseStack);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        snap.UpdateHitbox(EPlayerHitArea.LEFTARM, poseStack.top(), this.leftArm.GetHalfExtents());
        poseStack.pop();
        poseStack.push();
        this.rightArm.Pose(poseStack);
        poseStack.mulPose(Axis.f_252403_.m_252977_(180.0f));
        snap.UpdateHitbox(EPlayerHitArea.RIGHTARM, poseStack.top(), this.rightArm.GetHalfExtents());
        poseStack.pop();
        snap.valid = true;
    }

    @Nonnull
    public Vec3 getRenderOffset(@Nonnull Player p_117785_, float p_117786_) {
        return p_117785_.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : Vec3.f_82478_;
    }

    public void prepareMobModel(@Nonnull Player p_102861_, float p_102862_, float p_102863_, float p_102864_) {
        this.swimAmount = p_102861_.m_20998_(p_102864_);
    }

    protected void livingSetupRotations(@Nonnull Player p_115317_, @Nonnull TransformStack poseStack, float p_115319_, float p_115320_, float p_115321_) {
        if (this.isShaking(p_115317_)) {
            p_115320_ += (float)(Math.cos((double)p_115317_.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!p_115317_.m_217003_(Pose.SLEEPING)) {
            poseStack.mulPose(Axis.f_252436_.m_252977_(180.0f - p_115320_));
        }
        if (p_115317_.f_20919_ > 0) {
            float f = ((float)p_115317_.f_20919_ + p_115321_ - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.mulPose(Axis.f_252403_.m_252977_(f * this.getFlipDegrees(p_115317_)));
        } else if (p_115317_.m_21209_()) {
            poseStack.mulPose(Axis.f_252529_.m_252977_(-90.0f - p_115317_.m_146909_()));
            poseStack.mulPose(Axis.f_252436_.m_252977_(((float)p_115317_.f_19797_ + p_115321_) * -75.0f));
        } else if (p_115317_.m_217003_(Pose.SLEEPING)) {
            Direction direction = p_115317_.m_21259_();
            float f1 = direction != null ? CommonPlayerModel.sleepDirectionToRotation(direction) : p_115320_;
            poseStack.mulPose(Axis.f_252436_.m_252977_(f1));
            poseStack.mulPose(Axis.f_252403_.m_252977_(this.getFlipDegrees(p_115317_)));
            poseStack.mulPose(Axis.f_252436_.m_252977_(270.0f));
        }
    }

    protected void playerSetupRotations(@Nonnull Player p_117802_, @Nonnull TransformStack poseStack, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.m_20998_(p_117806_);
        if (p_117802_.m_21255_()) {
            this.livingSetupRotations(p_117802_, poseStack, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.m_21256_() + p_117806_;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.m_21209_()) {
                poseStack.mulPose(Axis.f_252529_.m_252977_(f2 * (-90.0f - p_117802_.m_146909_())));
            }
            Vec3 vec3 = p_117802_.m_20252_(p_117806_);
            Vec3 vec31 = p_117802_.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                poseStack.mulPose(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            this.livingSetupRotations(p_117802_, poseStack, p_117804_, p_117805_, p_117806_);
            float f3 = p_117802_.m_20069_() || p_117802_.isInFluidType((fluidType, height) -> p_117802_.canSwimInFluidType(fluidType)) ? -90.0f - p_117802_.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            poseStack.mulPose(Axis.f_252529_.m_252977_(f4));
            if (p_117802_.m_6067_()) {
                poseStack.translate(0.0, -1.0, 0.3f);
            }
        } else {
            this.livingSetupRotations(p_117802_, poseStack, p_117804_, p_117805_, p_117806_);
        }
    }

    private static float sleepDirectionToRotation(@Nonnull Direction p_115329_) {
        return switch (p_115329_) {
            case Direction.SOUTH -> 90.0f;
            case Direction.WEST -> 0.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    protected float getFlipDegrees(@Nonnull Player p_115337_) {
        return 90.0f;
    }

    protected boolean isShaking(@Nonnull Player p_115304_) {
        return p_115304_.m_146890_();
    }

    protected float getBob(@Nonnull Player p_115305_, float p_115306_) {
        return (float)p_115305_.f_19797_ + p_115306_;
    }

    protected void scale(@Nonnull TransformStack poseStack) {
        float f = 0.9375f;
        poseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    private void setModelProperties(@Nonnull Player p_117819_) {
        if (p_117819_.m_5833_()) {
            this.setAllVisible(false);
            this.head.visible = true;
            this.hat.visible = true;
        } else {
            this.setAllVisible(true);
            this.hat.visible = p_117819_.m_36170_(PlayerModelPart.HAT);
            this.crouching = p_117819_.m_6047_();
            ArmPose humanoidmodel$armpose = CommonPlayerModel.getArmPose(p_117819_, InteractionHand.MAIN_HAND);
            ArmPose humanoidmodel$armpose1 = CommonPlayerModel.getArmPose(p_117819_, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.isTwoHanded()) {
                ArmPose armPose = humanoidmodel$armpose1 = p_117819_.m_21206_().m_41619_() ? ArmPose.EMPTY : ArmPose.ITEM;
            }
            if (p_117819_.m_5737_() == HumanoidArm.RIGHT) {
                this.rightArmPose = humanoidmodel$armpose;
                this.leftArmPose = humanoidmodel$armpose1;
            } else {
                this.rightArmPose = humanoidmodel$armpose1;
                this.leftArmPose = humanoidmodel$armpose;
            }
        }
    }

    private static ArmPose getArmPose(@Nonnull Player p_117795_, @Nonnull InteractionHand p_117796_) {
        ItemStack itemstack = p_117795_.m_21120_(p_117796_);
        if (itemstack.m_41619_()) {
            return ArmPose.EMPTY;
        }
        if (p_117795_.m_7655_() == p_117796_ && p_117795_.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && p_117796_ == p_117795_.m_7655_()) {
                return ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return ArmPose.SPYGLASS;
            }
            if (useanim == UseAnim.TOOT_HORN) {
                return ArmPose.TOOT_HORN;
            }
            if (useanim == UseAnim.BRUSH) {
                return ArmPose.BRUSH;
            }
        } else {
            if (!p_117795_.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
                return ArmPose.CROSSBOW_HOLD;
            }
            Item item = itemstack.m_41720_();
            if (item instanceof GunItem) {
                GunItem gun = (GunItem)item;
                return ArmPose.BOW_AND_ARROW;
            }
        }
        return ArmPose.ITEM;
    }

    public void livingSetupAnim(@Nonnull Player player, float p_102867_, float p_102868_, float p_102869_, float p_102870_, float p_102871_) {
        boolean flag2;
        boolean flag = player.m_21256_() > 4;
        boolean flag1 = player.m_6067_();
        this.head.yRot = p_102870_ * ((float)Math.PI / 180);
        this.head.xRot = flag ? -0.7853982f : (this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, p_102871_ * ((float)Math.PI / 180))) : p_102871_ * ((float)Math.PI / 180));
        this.body.yRot = 0.0f;
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)player.m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.xRot = Mth.m_14089_((float)(p_102867_ * 0.6662f + (float)Math.PI)) * 2.0f * p_102868_ * 0.5f / f;
        this.leftArm.xRot = Mth.m_14089_((float)(p_102867_ * 0.6662f)) * 2.0f * p_102868_ * 0.5f / f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.m_14089_((float)(p_102867_ * 0.6662f)) * 1.4f * p_102868_ / f;
        this.leftLeg.xRot = Mth.m_14089_((float)(p_102867_ * 0.6662f + (float)Math.PI)) * 1.4f * p_102868_ / f;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        this.rightLeg.zRot = 0.005f;
        this.leftLeg.zRot = -0.005f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = flag2 = player.m_5737_() == HumanoidArm.RIGHT;
        if (player.m_6117_()) {
            boolean flag3;
            boolean bl2 = flag3 = player.m_7655_() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm(player);
            } else {
                this.poseLeftArm(player);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if (flag2 != flag4) {
                this.poseLeftArm(player);
                this.poseRightArm(player);
            } else {
                this.poseRightArm(player);
                this.poseLeftArm(player);
            }
        }
        this.setupAttackAnimation(player, p_102869_);
        if (this.crouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z = 4.0f;
            this.leftLeg.z = 4.0f;
            this.rightLeg.y = 12.2f;
            this.leftLeg.y = 12.2f;
            this.head.y = 4.2f;
            this.body.y = 3.2f;
            this.leftArm.y = 5.2f;
            this.rightArm.y = 5.2f;
        } else {
            this.body.xRot = 0.0f;
            this.rightLeg.z = 0.0f;
            this.leftLeg.z = 0.0f;
            this.rightLeg.y = 12.0f;
            this.leftLeg.y = 12.0f;
            this.head.y = 0.0f;
            this.body.y = 0.0f;
            this.leftArm.y = 2.0f;
            this.rightArm.y = 2.0f;
        }
        if (this.rightArmPose != ArmPose.SPYGLASS) {
            CommonPlayerModel.bobModelPart(this.rightArm, p_102869_, 1.0f);
        }
        if (this.leftArmPose != ArmPose.SPYGLASS) {
            CommonPlayerModel.bobModelPart(this.leftArm, p_102869_, -1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float f2;
            float f5 = p_102867_ % 26.0f;
            HumanoidArm humanoidarm = this.getAttackArm(player);
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f3 = f2 = humanoidarm == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!player.m_6117_()) {
                if (f5 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.m_14179_((float)f1, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.m_14179_((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.m_14179_((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f)));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f * f6);
                    this.rightArm.xRot = Mth.m_14179_((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f * f6));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.m_14179_((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                    this.rightArm.zRot = Mth.m_14179_((float)f1, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f6));
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f32 = (f5 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f - 1.5707964f * f32);
                    this.rightArm.xRot = Mth.m_14179_((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f32));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.m_14179_((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.m_14179_((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            float f7 = 0.3f;
            float f4 = 0.33333334f;
            this.leftLeg.xRot = Mth.m_14179_((float)this.swimAmount, (float)this.leftLeg.xRot, (float)(0.3f * Mth.m_14089_((float)(p_102867_ * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.m_14179_((float)this.swimAmount, (float)this.rightLeg.xRot, (float)(0.3f * Mth.m_14089_((float)(p_102867_ * 0.33333334f))));
        }
        this.hat.copyFrom(this.head);
    }

    private void poseRightArm(@Nonnull Player p_102876_) {
        switch (this.rightArmPose) {
            case EMPTY: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.9424779f;
                this.rightArm.yRot = -0.5235988f;
                break;
            }
            case ITEM: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                CommonPlayerModel.animateCrossbowCharge(this.rightArm, this.leftArm, (LivingEntity)p_102876_, true);
                break;
            }
            case CROSSBOW_HOLD: {
                CommonPlayerModel.animateCrossbowHold(this.rightArm, this.leftArm, this.head, true);
                break;
            }
            case BRUSH: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.62831855f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case SPYGLASS: {
                this.rightArm.xRot = Mth.m_14036_((float)(this.head.xRot - 1.9198622f - (p_102876_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.rightArm.xRot = Mth.m_14036_((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.rightArm.yRot = this.head.yRot - 0.5235988f;
            }
        }
    }

    private void poseLeftArm(@Nonnull Player p_102879_) {
        switch (this.leftArmPose) {
            case EMPTY: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.9424779f;
                this.leftArm.yRot = 0.5235988f;
                break;
            }
            case ITEM: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                CommonPlayerModel.animateCrossbowCharge(this.rightArm, this.leftArm, (LivingEntity)p_102879_, false);
                break;
            }
            case CROSSBOW_HOLD: {
                CommonPlayerModel.animateCrossbowHold(this.rightArm, this.leftArm, this.head, false);
                break;
            }
            case BRUSH: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.62831855f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case SPYGLASS: {
                this.leftArm.xRot = Mth.m_14036_((float)(this.head.xRot - 1.9198622f - (p_102879_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.leftArm.xRot = Mth.m_14036_((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.leftArm.yRot = this.head.yRot + 0.5235988f;
            }
        }
    }

    private float quadraticArmUpdate(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    protected void setupAttackAnimation(@Nonnull Player p_102858_, float p_102859_) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            SimpleCube modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.body.yRot = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            this.rightArm.z = Mth.m_14031_((float)this.body.yRot) * 5.0f;
            this.rightArm.x = -Mth.m_14089_((float)this.body.yRot) * 5.0f;
            this.leftArm.z = -Mth.m_14031_((float)this.body.yRot) * 5.0f;
            this.leftArm.x = Mth.m_14089_((float)this.body.yRot) * 5.0f;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.m_14031_((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    @Nonnull
    protected SimpleCube getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    private HumanoidArm getAttackArm(@Nonnull Player p_102857_) {
        HumanoidArm humanoidarm = p_102857_.m_5737_();
        return p_102857_.f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }

    protected float rotlerpRad(float p_102836_, float p_102837_, float p_102838_) {
        float f = (p_102838_ - p_102837_) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return p_102837_ + p_102836_ * f;
    }

    public void setAllVisible(boolean p_102880_) {
        this.head.visible = p_102880_;
        this.hat.visible = p_102880_;
        this.body.visible = p_102880_;
        this.rightArm.visible = p_102880_;
        this.leftArm.visible = p_102880_;
        this.rightLeg.visible = p_102880_;
        this.leftLeg.visible = p_102880_;
    }

    public static void bobModelPart(@Nonnull SimpleCube p_170342_, float p_170343_, float p_170344_) {
        p_170342_.zRot += p_170344_ * (Mth.m_14089_((float)(p_170343_ * 0.09f)) * 0.05f + 0.05f);
        p_170342_.xRot += p_170344_ * Mth.m_14031_((float)(p_170343_ * 0.067f)) * 0.05f;
    }

    public static void animateCrossbowHold(@Nonnull SimpleCube p_102098_, @Nonnull SimpleCube p_102099_, @Nonnull SimpleCube p_102100_, boolean p_102101_) {
        SimpleCube modelpart = p_102101_ ? p_102098_ : p_102099_;
        SimpleCube modelpart1 = p_102101_ ? p_102099_ : p_102098_;
        modelpart.yRot = (p_102101_ ? -0.3f : 0.3f) + p_102100_.yRot;
        modelpart1.yRot = (p_102101_ ? 0.6f : -0.6f) + p_102100_.yRot;
        modelpart.xRot = -1.5707964f + p_102100_.xRot + 0.1f;
        modelpart1.xRot = -1.5f + p_102100_.xRot;
    }

    public static void animateCrossbowCharge(@Nonnull SimpleCube p_102087_, @Nonnull SimpleCube p_102088_, @Nonnull LivingEntity p_102089_, boolean p_102090_) {
        SimpleCube modelpart = p_102090_ ? p_102087_ : p_102088_;
        SimpleCube modelpart1 = p_102090_ ? p_102088_ : p_102087_;
        modelpart.yRot = p_102090_ ? -0.8f : 0.8f;
        modelpart1.xRot = modelpart.xRot = -0.97079635f;
        float f = CrossbowItem.m_40939_((ItemStack)p_102089_.m_21211_());
        float f1 = Mth.m_14036_((float)p_102089_.m_21252_(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        modelpart1.yRot = Mth.m_14179_((float)f2, (float)0.4f, (float)0.85f) * (float)(p_102090_ ? 1 : -1);
        modelpart1.xRot = Mth.m_14179_((float)f2, (float)modelpart1.xRot, (float)-1.5707964f);
    }

    public static enum ArmPose {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true),
        SPYGLASS(false),
        TOOT_HORN(false),
        BRUSH(false);

        private final boolean twoHanded;

        private ArmPose(boolean p_102896_) {
            this.twoHanded = p_102896_;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }
    }

    private static class CubeDeformation {
        public static final CubeDeformation NONE = new CubeDeformation(0.0f);
        final float growX;
        final float growY;
        final float growZ;

        public CubeDeformation(float x, float y, float z) {
            this.growX = x;
            this.growY = y;
            this.growZ = z;
        }

        public CubeDeformation(float expand) {
            this(expand, expand, expand);
        }

        public CubeDeformation extend(float expand) {
            return new CubeDeformation(this.growX + expand, this.growY + expand, this.growZ + expand);
        }

        public CubeDeformation extend(float x, float y, float z) {
            return new CubeDeformation(this.growX + x, this.growY + y, this.growZ + z);
        }
    }

    private static class SimpleCube {
        public float x;
        public float y;
        public float z;
        public float xRot;
        public float yRot;
        public float zRot;
        public boolean visible;
        public Vector3f BoxMin;
        public Vector3f BoxDims;
        public boolean Mirror = false;

        private SimpleCube() {
        }

        public static SimpleCube create() {
            return new SimpleCube();
        }

        @Nonnull
        public SimpleCube texOffs(int u, int v) {
            return this;
        }

        @Nonnull
        public SimpleCube addBox(float xMin, float yMin, float zMin, float w, float h, float d, @Nonnull CubeDeformation deform) {
            this.BoxMin = new Vector3f(xMin - deform.growX, yMin - deform.growY, zMin - deform.growZ);
            this.BoxDims = new Vector3f(w + deform.growX * 2.0f, h + deform.growY * 2.0f, d + deform.growZ * 2.0f);
            return this;
        }

        @Nonnull
        public SimpleCube mirror() {
            this.Mirror = !this.Mirror;
            return this;
        }

        @Nonnull
        public SimpleCube offset(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public void copyFrom(@Nonnull SimpleCube other) {
            this.BoxMin = other.BoxMin;
            this.BoxDims = other.BoxDims;
            this.Mirror = other.Mirror;
            this.xRot = other.xRot;
            this.yRot = other.yRot;
            this.zRot = other.zRot;
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
        }

        public void Pose(@Nonnull TransformStack stack) {
            stack.add(Transform.fromPos(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f));
            stack.add(Transform.fromPosAndQuat(Vec3.f_82478_, new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot)));
            stack.add(Transform.fromPos(this.BoxMin.x / 16.0f + this.BoxDims.x / 32.0f, this.BoxMin.y / 16.0f + this.BoxDims.y / 32.0f, this.BoxMin.z / 16.0f + this.BoxDims.z / 32.0f));
        }

        @Nonnull
        public Transform GetCenter() {
            TransformStack stack = TransformStack.empty();
            this.Pose(stack);
            return stack.top();
        }

        @Nonnull
        public Vector3f GetHalfExtents() {
            return new Vector3f(this.BoxDims.x / 32.0f, this.BoxDims.y / 32.0f, this.BoxDims.z / 32.0f);
        }
    }
}

