/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.item;

import com.flansmod.api.IAmmoItem;
import com.flansmod.common.FlansMod;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.bullets.BulletBagDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;

public class BulletBagItem
extends FlanItem
implements IForgeItem,
IAmmoItem {
    @Override
    public BulletBagDefinition Def() {
        return (BulletBagDefinition)FlansMod.BULLET_BAGS.Get(this.DefinitionLocation);
    }

    public BulletBagItem(@Nonnull ResourceLocation defLoc, @Nonnull Item.Properties properties) {
        super(defLoc, properties);
    }

    @Nonnull
    public List<ItemStack> getBulletStacks(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("bullets")) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            ListTag tagList = stack.m_41783_().m_128437_("bullets", 10);
            tagList.forEach(tag -> listBuilder.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))));
            return listBuilder.build();
        }
        return List.of();
    }

    public void setBulletStacks(@Nonnull ItemStack stack, @Nonnull List<ItemStack> subStacks) {
        ListTag tagList = new ListTag();
        int numStacks = 0;
        for (ItemStack subStack : subStacks) {
            if (subStack.m_41619_()) continue;
            if (numStacks >= this.Def().slotCount) {
                FlansMod.LOGGER.warn("Trying to store more bullets in a BulletBag than slots");
                continue;
            }
            tagList.add((Object)subStack.m_41739_(new CompoundTag()));
            ++numStacks;
        }
        stack.m_41784_().m_128365_("bullets", (Tag)tagList);
    }

    @Override
    @Nonnull
    public ItemStack provideAny(@Nonnull ItemStack fromStack) {
        ItemStack provided = ItemStack.f_41583_;
        List<ItemStack> contents = this.getBulletStacks(fromStack);
        for (ItemStack subStack : contents) {
            Item item = subStack.m_41720_();
            if (!(item instanceof IAmmoItem)) continue;
            IAmmoItem ammoItem = (IAmmoItem)item;
            provided = ammoItem.provideAny(subStack);
            break;
        }
        this.setBulletStacks(fromStack, contents);
        return provided;
    }

    @Override
    public boolean matchesTags(@Nonnull ItemStack fromStack, @Nonnull List<TagKey<Item>> matchTags) {
        List<ItemStack> contents = this.getBulletStacks(fromStack);
        for (ItemStack subStack : contents) {
            IAmmoItem ammoItem;
            Item item = subStack.m_41720_();
            if (!(item instanceof IAmmoItem) || !(ammoItem = (IAmmoItem)item).matchesTags(subStack, matchTags)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack provideForTags(@Nonnull ItemStack fromStack, @Nonnull List<TagKey<Item>> matchTags) {
        List<ItemStack> contents = this.getBulletStacks(fromStack);
        for (ItemStack subStack : contents) {
            IAmmoItem ammoItem;
            Item item = subStack.m_41720_();
            if (!(item instanceof IAmmoItem) || !(ammoItem = (IAmmoItem)item).matchesTags(subStack, matchTags)) continue;
            return ammoItem.provideForTags(subStack, matchTags);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean matchesIDs(@Nonnull ItemStack fromStack, @Nonnull List<ResourceLocation> matchIDs) {
        List<ItemStack> contents = this.getBulletStacks(fromStack);
        for (ItemStack subStack : contents) {
            IAmmoItem ammoItem;
            Item item = subStack.m_41720_();
            if (!(item instanceof IAmmoItem) || !(ammoItem = (IAmmoItem)item).matchesIDs(subStack, matchIDs)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack provideForIDs(@Nonnull ItemStack fromStack, @Nonnull List<ResourceLocation> matchIDs) {
        List<ItemStack> contents = this.getBulletStacks(fromStack);
        for (ItemStack subStack : contents) {
            IAmmoItem ammoItem;
            Item item = subStack.m_41720_();
            if (!(item instanceof IAmmoItem) || !(ammoItem = (IAmmoItem)item).matchesIDs(subStack, matchIDs)) continue;
            return ammoItem.provideForIDs(subStack, matchIDs);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        List<ItemStack> subStacks = this.getBulletStacks(stack);
        tooltips.add((Component)Component.m_237110_((String)"flansmod.bullet_bag.fullness", (Object[])new Object[]{subStacks.size(), this.Def().slotCount}));
        for (ItemStack subStack : subStacks) {
            tooltips.add((Component)Component.m_237110_((String)"flansmod.bullet_bag.substack", (Object[])new Object[]{subStack.m_41611_(), subStack.m_41613_(), this.Def().maxStackSize}));
        }
    }
}

