/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.item;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.render.guns.GunItemClientExtension;
import com.flansmod.common.FlansMod;
import com.flansmod.common.abilities.AbilityEffectProvideEnchantment;
import com.flansmod.common.abilities.AbilityInstanceApplyModifier;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.ContextCache;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextItem;
import com.flansmod.common.actions.contexts.GunshotContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextPlayer;
import com.flansmod.common.item.BulletItem;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.projectiles.BulletGuidance;
import com.flansmod.common.types.abilities.elements.EAbilityTarget;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.common.types.bullets.elements.ProjectileDefinition;
import com.flansmod.common.types.guns.GunDefinition;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.ActionGroupDefinition;
import com.flansmod.common.types.guns.elements.EActionType;
import com.flansmod.common.types.guns.elements.ERepeatMode;
import com.flansmod.common.types.guns.elements.ReloadDefinition;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.Maths;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.NotNull;

public class GunItem
extends FlanItem {
    public Entity LockedOnTarget = null;
    public float lockTime = 0.0f;
    public float lockTimeMax = 20.0f;

    @Override
    public GunDefinition Def() {
        return (GunDefinition)FlansMod.GUNS.Get(this.DefinitionLocation);
    }

    public GunItem(@Nonnull ResourceLocation defLoc, @Nonnull Item.Properties properties) {
        super(defLoc, properties);
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        ActionGroupContext actionContext;
        GunContext gunContext = GunContext.of(stack, EContextSide.of(level));
        if (gunContext.IsValid() && (actionContext = ActionGroupContext.CreateFrom(gunContext, "primary_fire")).IsValid()) {
            int primaryBullets;
            MagazineDefinition magDef;
            boolean advanced = flags.m_7050_();
            boolean expanded = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
            MutableComponent fireRateString = actionContext.RepeatMode() == ERepeatMode.SemiAuto ? Component.m_237115_((String)"tooltip.format.singlefire") : Component.m_237110_((String)"tooltip.format.fullautorpm", (Object[])new Object[]{actionContext.RoundsPerMinute()});
            GunshotContext gunshotContext = GunshotContext.hitscan(actionContext, BulletDefinition.STANDARD_TEST_BULLET, 0);
            if (expanded) {
                tooltips.add((Component)Component.m_237110_((String)"tooltip.format.impact_damage.advanced", (Object[])new Object[]{Float.valueOf(gunshotContext.EstimateImpactDamage(EAbilityTarget.ShotEntity))}));
                tooltips.add((Component)Component.m_237110_((String)"tooltip.format.vertical_recoil.advanced", (Object[])new Object[]{Float.valueOf(actionContext.VerticalRecoil())}));
                tooltips.add((Component)Component.m_237110_((String)"tooltip.format.spread.advanced", (Object[])new Object[]{Float.valueOf(actionContext.Spread())}));
            } else {
                tooltips.add((Component)Component.m_237110_((String)"tooltip.format.primarystatline", (Object[])new Object[]{Float.valueOf(gunshotContext.EstimateImpactDamage(EAbilityTarget.ShotEntity)), fireRateString, Float.valueOf(actionContext.VerticalRecoil()), Float.valueOf(actionContext.Spread())}));
            }
            if (expanded) {
                switch (actionContext.RepeatMode()) {
                    case Toggle: {
                        tooltips.add((Component)Component.m_237115_((String)"tooltip.format.toggle.advanced"));
                        break;
                    }
                    case FullAuto: {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.format.fullautorpm.advanced", (Object[])new Object[]{actionContext.RoundsPerMinute()}));
                        break;
                    }
                    case SemiAuto: {
                        tooltips.add((Component)Component.m_237115_((String)"tooltip.format.singlefire.advanced"));
                        break;
                    }
                    case Minigun: {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.format.minigunrpm.advanced", (Object[])new Object[]{actionContext.RoundsPerMinute()}));
                        break;
                    }
                    case BurstFire: {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.format.burstfirerpm.advanced", (Object[])new Object[]{actionContext.RoundsPerMinute()}));
                    }
                }
            }
            if ((magDef = actionContext.GetMagazineType(0)).IsValid()) {
                tooltips.add((Component)Component.m_237115_((String)("magazine." + magDef.Location.m_135827_() + "." + magDef.Location.m_135815_())));
            }
            if ((primaryBullets = actionContext.GetMagazineSize(0)) == 1) {
                ItemStack bulletStack = actionContext.GetBulletAtIndex(0, 0);
                if (!bulletStack.m_41619_()) {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.single_bullet_stack", (Object[])new Object[]{bulletStack.m_41786_()}));
                }
            } else {
                HashMap<Item, ItemStack> bulletCounts = new HashMap<Item, ItemStack>();
                for (int i = 0; i < primaryBullets; ++i) {
                    ItemStack bulletStack = actionContext.GetBulletAtIndex(0, i);
                    if (bulletStack.m_41619_()) continue;
                    if (!bulletCounts.containsKey(bulletStack.m_41720_())) {
                        bulletCounts.put(bulletStack.m_41720_(), bulletStack.m_41777_());
                        continue;
                    }
                    bulletCounts.replace(bulletStack.m_41720_(), bulletStack.m_255036_(((ItemStack)bulletCounts.get(bulletStack.m_41720_())).m_41613_() + 1));
                }
                for (Map.Entry kvp : bulletCounts.entrySet()) {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.multiple_bullet_stack", (Object[])new Object[]{((ItemStack)kvp.getValue()).m_41613_(), ((ItemStack)kvp.getValue()).m_41786_()}));
                }
            }
        }
        super.m_7373_(stack, level, tooltips, flags);
    }

    @Nonnull
    public CompoundTag GetRootTag(@Nonnull ItemStack stack, @Nonnull String groupPath) {
        ActionGroupContext actionGroupContext;
        ReloadDefinition reloadDef;
        String rootTagName = groupPath;
        GunContextItem gunContext = ContextCache.CreateWithoutCaching(stack);
        if (gunContext.IsValid() && (reloadDef = gunContext.GetReloadDefinitionContaining(actionGroupContext = gunContext.GetActionGroupContext(groupPath))) != null) {
            rootTagName = reloadDef.key;
        }
        if (!stack.m_41784_().m_128441_(rootTagName)) {
            stack.m_41784_().m_128365_(rootTagName, (Tag)new CompoundTag());
        }
        return stack.m_41784_().m_128469_(rootTagName);
    }

    @Nonnull
    public CompoundTag GetMagTag(@Nonnull ItemStack stack, @Nonnull String groupPath, int magIndex) {
        String magTag;
        CompoundTag rootTag = this.GetRootTag(stack, groupPath);
        if (!rootTag.m_128441_(magTag = "mag_" + magIndex)) {
            rootTag.m_128365_(magTag, (Tag)new CompoundTag());
        }
        return rootTag.m_128469_(magTag);
    }

    @Nonnull
    public MagazineDefinition GetMagazineType(ItemStack stack, String groupPath, int magIndex) {
        CompoundTag magTags = this.GetMagTag(stack, groupPath, magIndex);
        if (magTags.m_128441_("type")) {
            String type = magTags.m_128461_("type");
            ResourceLocation magLoc = new ResourceLocation(type);
            return (MagazineDefinition)FlansMod.MAGAZINES.Get(magLoc);
        }
        List<MagazineDefinition> matches = this.Def().GetMagazineSettings(groupPath).GetMatchingMagazines();
        if (matches.size() > 0) {
            return matches.get(0);
        }
        return MagazineDefinition.INVALID;
    }

    @Nonnull
    public ItemStack[] GetCombinedBulletStacks(@Nonnull ItemStack stack, @Nonnull String groupPath, int magIndex) {
        CompoundTag magTags = this.GetMagTag(stack, groupPath, magIndex);
        if (magTags.m_128441_("bullets")) {
            CompoundTag bulletTags = magTags.m_128469_("bullets");
            ItemStack[] stacks = new ItemStack[bulletTags.m_128440_()];
            int stackIndex = 0;
            for (String key : bulletTags.m_128431_()) {
                stacks[stackIndex] = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                ++stackIndex;
            }
            return stacks;
        }
        return new ItemStack[0];
    }

    @Nonnull
    public ItemStack GetBulletAtIndex(@Nonnull ItemStack stack, @Nonnull String groupPath, int magIndex, int bulletIndex) {
        CompoundTag magTags = this.GetMagTag(stack, groupPath, magIndex);
        if (magTags.m_128441_("bullets")) {
            CompoundTag bulletTags = magTags.m_128469_("bullets");
            for (String key : bulletTags.m_128431_()) {
                int startIndex = Integer.parseInt(key);
                ItemStack bulletStack = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                int endIndex = startIndex + bulletStack.m_41613_();
                if (startIndex > bulletIndex || bulletIndex >= endIndex) continue;
                if (bulletStack.m_41720_() == Items.f_42410_) {
                    return ItemStack.f_41583_;
                }
                return bulletStack.m_255036_(1);
            }
        }
        return ItemStack.f_41583_;
    }

    public int GetNumBulletsInMag(@Nonnull ItemStack stack, @Nonnull String groupPath, int magIndex) {
        int count = 0;
        CompoundTag magTags = this.GetMagTag(stack, groupPath, magIndex);
        if (magTags.m_128441_("bullets")) {
            CompoundTag bulletTags = magTags.m_128469_("bullets");
            for (String key : bulletTags.m_128431_()) {
                int startIndex = Integer.parseInt(key);
                ItemStack bulletStack = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                if (bulletStack.m_41720_() == Items.f_42410_) continue;
                count += bulletStack.m_41613_();
            }
        }
        return count;
    }

    @Nonnull
    public Item[] ExtractCompactStacks(@Nonnull ItemStack stack, @Nonnull String groupPath, int magIndex) {
        MagazineDefinition magDef = this.GetMagazineType(stack, groupPath, magIndex);
        CompoundTag magTags = this.GetMagTag(stack, groupPath, magIndex);
        Item[] items = new Item[magDef.numRounds];
        for (int i = 0; i < magDef.numRounds; ++i) {
            items[i] = Items.f_42410_;
        }
        if (magTags.m_128441_("bullets")) {
            CompoundTag bulletTags = magTags.m_128469_("bullets");
            for (String key : bulletTags.m_128431_()) {
                int startIndex = Integer.parseInt(key);
                ItemStack bulletStack = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                int endIndex = startIndex + bulletStack.m_41613_();
                for (int i = startIndex; i < endIndex; ++i) {
                    if (0 > i || i >= magDef.numRounds) continue;
                    items[i] = bulletStack.m_41720_();
                }
            }
        }
        return items;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ClientHandleMouse(Player player, ItemStack stack, InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack() || event.isUseItem()) {
            // empty if block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ClientUpdateUsing(Player player, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
    }

    public boolean m_6777_(@Nonnull BlockState blockState, @Nonnull Level world, @Nonnull BlockPos blockPos, Player player) {
        if (player.m_7500_()) {
            return false;
        }
        ShooterContext shooterContext = ShooterContext.of((Entity)player);
        if (shooterContext.IsValid()) {
            for (GunContext gunContext : shooterContext.GetAllGunContexts()) {
                for (ActionDefinition actionDef : gunContext.GetPotentialPrimaryActions()) {
                    switch (actionDef.actionType) {
                        case Axe: 
                        case Pickaxe: 
                        case Hoe: 
                        case Shovel: 
                        case Melee: {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState blockState) {
        List tiers = TierSortingRegistry.getSortedTiers();
        GunContextItem gunContext = ContextCache.CreateWithoutCaching(stack);
        block7: for (ActionDefinition actionDef : gunContext.GetPotentialPrimaryActions()) {
            int harvestLevel = Maths.ceil(gunContext.ModifyFloat("tool_level").get());
            switch (actionDef.actionType) {
                case Melee: {
                    return blockState.m_60713_(Blocks.f_50033_);
                }
                case Axe: {
                    if (!blockState.m_204336_(BlockTags.f_144280_)) break;
                    for (Tier tier : tiers) {
                        if (tier.m_6604_() < harvestLevel || !TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) continue;
                        return true;
                    }
                    continue block7;
                }
                case Pickaxe: {
                    if (!blockState.m_204336_(BlockTags.f_144282_)) break;
                    for (Tier tier : tiers) {
                        if (tier.m_6604_() < harvestLevel || !TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) continue;
                        return true;
                    }
                    continue block7;
                }
                case Hoe: {
                    if (!blockState.m_204336_(BlockTags.f_144281_)) break;
                    for (Tier tier : tiers) {
                        if (tier.m_6604_() < harvestLevel || !TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) continue;
                        return true;
                    }
                    continue block7;
                }
                case Shovel: {
                    if (!blockState.m_204336_(BlockTags.f_144283_)) break;
                    for (Tier tier : tiers) {
                        if (tier.m_6604_() < harvestLevel || !TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState)) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    public void m_6883_(@Nonnull ItemStack stack, Level level, @Nonnull Entity entity, int i, boolean b) {
        if (level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150109_().f_35977_ == i) {
                GunContext gunContext = GunContext.of(stack, EContextSide.of(level));
                for (ActionDefinition actionDef : gunContext.GetPotentialPrimaryActions()) {
                    switch (actionDef.actionType) {
                        case Axe: 
                        case Pickaxe: 
                        case Hoe: 
                        case Shovel: 
                        case Melee: {
                            return;
                        }
                    }
                }
                FlansModClient.SetMissTime(10);
            }
        }
        this.HandleLock(stack, level, entity, i, b);
    }

    public void HandleLock(@Nonnull ItemStack stack, Level level, @Nonnull Entity entity, int i, boolean b) {
        if (this.LockedOnTarget != null && this.LockedOnTarget.m_213877_()) {
            GunContext gunContext = GunContext.of(stack, EContextSide.of(level));
            gunContext.SetLockTarget(null);
            this.LockedOnTarget = gunContext.GetLockTarget();
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150109_().f_35977_ == i) {
                GunContext gunContext = GunContext.of(stack, EContextSide.of(level));
                ItemStack bulletStack = this.GetBulletAtIndex(stack, "primary_fire", 0, 0);
                ActionGroupContext actionContext = ActionGroupContext.CreateFrom(gunContext, "primary_fire");
                MagazineDefinition magDef = actionContext.GetMagazineType(0);
                int rounds = magDef.numRounds;
                for (int j = 0; j < rounds && !((bulletStack = this.GetBulletAtIndex(stack, "primary_fire", 0, j)).m_41720_() instanceof BulletItem); ++j) {
                }
                BulletItem bullet = null;
                if (bulletStack.m_41720_() instanceof BulletItem) {
                    bullet = (BulletItem)bulletStack.m_41720_();
                }
                if (bullet == null) {
                    this.LockedOnTarget = null;
                    this.lockTime = 0.0f;
                    gunContext.SetLockTarget(null);
                    return;
                }
                if (bullet.Def().projectiles.length <= 0) {
                    this.LockedOnTarget = null;
                    this.lockTime = 0.0f;
                    gunContext.SetLockTarget(null);
                    return;
                }
                ProjectileDefinition def = bullet.Def().projectiles[0];
                this.lockTimeMax = def.lockTime;
                if (this.LockedOnTarget == null) {
                    if (def.HasLockOn()) {
                        Entity e = BulletGuidance.getLockOnTarget(def.Targets(), (Entity)player, def);
                        if (e != null) {
                            this.LockedOnTarget = e;
                        }
                    } else {
                        this.LockedOnTarget = null;
                    }
                } else if (!BulletGuidance.checkLock((Entity)player, this.LockedOnTarget, def)) {
                    this.LockedOnTarget = null;
                }
                if (this.LockedOnTarget != null) {
                    this.lockTime += 1.0f;
                    if (this.lockTime > def.lockTime) {
                        gunContext.SetLockTarget(this.LockedOnTarget);
                    }
                } else {
                    this.lockTime = 0.0f;
                    gunContext.SetLockTarget(null);
                }
            }
        }
    }

    public ProjectileDefinition GetChamberProjectile(ItemStack stack, GunContext gunContext) {
        ItemStack bulletStack = new ItemStack((ItemLike)Items.f_41852_);
        ActionGroupContext actionContext = ActionGroupContext.CreateFrom(gunContext, "primary_fire");
        MagazineDefinition magDef = actionContext.GetMagazineType(0);
        int rounds = magDef.numRounds;
        for (int i = 0; i < rounds && !((bulletStack = this.GetBulletAtIndex(stack, "primary_fire", 0, i)).m_41720_() instanceof BulletItem); ++i) {
        }
        BulletItem bullet = null;
        if (bulletStack.m_41720_() instanceof BulletItem) {
            bullet = (BulletItem)bulletStack.m_41720_();
        }
        if (bullet == null) {
            this.LockedOnTarget = null;
            this.lockTime = 0.0f;
            gunContext.SetLockTarget(null);
            return null;
        }
        if (bullet.Def().projectiles.length <= 0) {
            this.LockedOnTarget = null;
            this.lockTime = 0.0f;
            gunContext.SetLockTarget(null);
            return null;
        }
        return bullet.Def().projectiles[0];
    }

    public int getEnchantmentLevel(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        int highestLevel = 0;
        GunContext gun = GunContext.of(stack);
        if (gun.IsValid()) {
            for (Map.Entry<AbilityInstanceApplyModifier, AbilityStack> kvp : gun.GetActiveModifierAbilities().entrySet()) {
                int level;
                IAbilityEffect iAbilityEffect = kvp.getKey().Def.GetEffectProcessor();
                if (!(iAbilityEffect instanceof AbilityEffectProvideEnchantment)) continue;
                AbilityEffectProvideEnchantment enchantmentProvider = (AbilityEffectProvideEnchantment)iAbilityEffect;
                if (!enchantmentProvider.Enchant.equals(enchantment) || (level = enchantmentProvider.GetLevel(gun.GetActionGroupContext("primary_fire"), kvp.getValue())) <= highestLevel) continue;
                highestLevel = level;
            }
        }
        return Maths.max(highestLevel, super.getEnchantmentLevel(stack, enchantment));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ActionGroupContext actionGroupContext;
        GunContextItem gunContext = ContextCache.CreateWithoutCaching(stack);
        if (gunContext.IsValid() && (actionGroupContext = gunContext.GetActionGroupContext("primary_fire")).IsValid()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (ActionDefinition actionDef : gunContext.GetPotentialPrimaryActions()) {
                if (actionDef.actionType != EActionType.Melee) continue;
                float meleeDamage = actionGroupContext.ModifyFloat("melee_damage").get();
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Gun modifier", (double)meleeDamage, AttributeModifier.Operation.ADDITION));
            }
            return builder.build();
        }
        return ImmutableMultimap.of();
    }

    public boolean m_7579_(ItemStack stack, @Nonnull LivingEntity wielder, @Nonnull LivingEntity victim) {
        stack.m_41622_(2, victim, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(@Nonnull ItemStack stack, Level level, @Nonnull BlockState blockState, @Nonnull BlockPos blockPos, @Nonnull LivingEntity wielder) {
        if (!level.f_46443_ && blockState.m_60800_((BlockGetter)level, blockPos) != 0.0f) {
            stack.m_41622_(1, wielder, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        GunContextItem gunContext = ContextCache.CreateWithoutCaching(stack);
        for (ActionDefinition actionDef : gunContext.GetPotentialSecondaryActions()) {
            switch (actionDef.actionType) {
                case Shield: {
                    return UseAnim.BLOCK;
                }
            }
        }
        return UseAnim.NONE;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        GunContextItem gunContext = ContextCache.CreateWithoutCaching(stack);
        for (ActionDefinition actionDef : gunContext.GetPotentialSecondaryActions()) {
            switch (actionDef.actionType) {
                case Shield: {
                    return 72000;
                }
            }
        }
        return 0;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ShooterContext shooterContext = ShooterContext.of((Entity)player);
        if (shooterContext.IsValid() && shooterContext instanceof ShooterContextPlayer) {
            ShooterContextPlayer playerContext = (ShooterContextPlayer)shooterContext;
            GunContext gunContext = playerContext.GetGunContextForSlot(hand, world.f_46443_);
            for (ActionDefinition actionDef : gunContext.GetPotentialSecondaryActions()) {
                switch (actionDef.actionType) {
                    case Shield: {
                        ItemStack stackInHand = player.m_21120_(hand);
                        player.m_6672_(hand);
                        return InteractionResultHolder.m_19096_((Object)stackInHand);
                    }
                }
            }
        }
        ItemStack itemstack = player.m_21120_(hand);
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ShooterContextPlayer playerContext;
        GunContext gunContext;
        ShooterContext shooter = ShooterContext.of((Entity)context.m_43723_());
        if (shooter.IsValid() && shooter instanceof ShooterContextPlayer && (gunContext = (playerContext = (ShooterContextPlayer)shooter).GetGunContextForSlot(context.m_43724_(), context.m_43725_().f_46443_)).IsValid()) {
            ActionGroupContext actionGroupContext;
            ActionStack actionStack = gunContext.GetActionStack();
            ActionGroupInstance actionGroup = actionStack.GetOrCreateGroupInstance(actionGroupContext = gunContext.GetActionGroupContext("secondary"));
            EActionResult startResult = actionGroup.CanStart();
            if (startResult == EActionResult.CanProcess) {
                for (ActionInstance action : actionGroup.GetActions()) {
                    switch (action.Def.actionType) {
                        case Strip: {
                            return Items.f_42423_.m_6225_(context);
                        }
                        case Shear: {
                            return Items.f_42574_.m_6225_(context);
                        }
                        case Flatten: {
                            return Items.f_42421_.m_6225_(context);
                        }
                        case Till: {
                            return Items.f_42424_.m_6225_(context);
                        }
                    }
                }
            }
            actionStack.CancelGroupInstance(actionGroupContext);
        }
        return InteractionResult.CONSUME;
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ToolAction toolAction) {
        for (ActionGroupDefinition actionGroup : this.Def().actionGroups) {
            block12: for (ActionDefinition actionDef : actionGroup.actions) {
                switch (actionDef.actionType) {
                    case Strip: {
                        if (toolAction != ToolActions.AXE_STRIP) continue block12;
                        return true;
                    }
                    case Shear: {
                        if (toolAction != ToolActions.SHEARS_HARVEST) continue block12;
                        return true;
                    }
                    case Flatten: {
                        if (toolAction != ToolActions.SHOVEL_FLATTEN) continue block12;
                        return true;
                    }
                    case Till: {
                        if (toolAction != ToolActions.HOE_TILL) continue block12;
                        return true;
                    }
                    case Axe: {
                        if (toolAction != ToolActions.AXE_DIG) continue block12;
                        return true;
                    }
                    case Pickaxe: {
                        if (toolAction != ToolActions.PICKAXE_DIG) continue block12;
                        return true;
                    }
                    case Shovel: {
                        if (toolAction != ToolActions.SHOVEL_DIG) continue block12;
                        return true;
                    }
                    case Hoe: {
                        if (toolAction != ToolActions.HOE_DIG) continue block12;
                        return true;
                    }
                    case Shield: {
                        if (toolAction != ToolActions.SHIELD_BLOCK) continue block12;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(GunItemClientExtension.of(this));
    }

    public boolean m_8120_(ItemStack i) {
        return false;
    }
}

