/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.item;

import com.flansmod.common.FlansMod;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.abilities.CraftingTraitDefinition;
import com.flansmod.common.types.abilities.elements.CraftingTraitProviderDefinition;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.parts.PartDefinition;
import com.flansmod.physics.common.util.Maths;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PartItem
extends FlanItem {
    @Override
    public PartDefinition Def() {
        return (PartDefinition)FlansMod.PARTS.Get(this.DefinitionLocation);
    }

    public PartItem(@Nonnull ResourceLocation defLoc, @Nonnull Item.Properties props) {
        super(defLoc, props);
    }

    @Override
    public boolean ShouldRenderAsIcon(@Nonnull ItemDisplayContext transformType) {
        return true;
    }

    @Override
    public boolean CanBeCraftedFromParts() {
        return false;
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        MaterialDefinition material = this.Def().GetMaterial();
        if (material.IsValid()) {
            MutableComponent colourCode = Component.m_237115_((String)("tooltip.tier_colour." + material.craftingTier));
            switch (material.materialType) {
                case Misc: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_misc_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                    break;
                }
                case Wood: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_wood_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                    break;
                }
                case Glass: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_glass_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                    break;
                }
                case Metal: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_metal_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                    break;
                }
                case Composite: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_composite_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                    break;
                }
                case Electronic: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_electronic_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                    break;
                }
                case Fabric: {
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.part_fabric_tier", (Object[])new Object[]{colourCode, material.craftingTier}));
                }
            }
        }
        if (this.Def().compatiblityTags.length != 3) {
            // empty if block
        }
        block15: for (ResourceLocation tag : this.Def().itemSettings.tags) {
            switch (tag.toString()) {
                case "flansmod:engine": {
                    tooltips.add(this.Def().engine.GetFuelConsumptionTooltip());
                    tooltips.add(this.Def().engine.GetFuelStorageTooltip());
                    if (this.Def().engine.maxSpeed != 1.0f) {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.format.engine_speed_modifier", (Object[])new Object[]{Maths.floor(this.Def().engine.maxSpeed * 100.0f)}));
                    }
                    if (this.Def().engine.maxAcceleration != 1.0f && this.Def().engine.maxAcceleration == this.Def().engine.maxDeceleration) {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.format.engine_acceleration_and_deceleration_modifier", (Object[])new Object[]{Maths.floor(this.Def().engine.maxAcceleration * 100.0f)}));
                        continue block15;
                    }
                    if (this.Def().engine.maxAcceleration != 1.0f) {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.format.engine_acceleration_modifier", (Object[])new Object[]{Maths.floor(this.Def().engine.maxAcceleration * 100.0f)}));
                        continue block15;
                    }
                    if (this.Def().engine.maxDeceleration == 1.0f) continue block15;
                    tooltips.add((Component)Component.m_237110_((String)"tooltip.format.engine_deceleration_modifier", (Object[])new Object[]{Maths.floor(this.Def().engine.maxDeceleration * 100.0f)}));
                }
            }
        }
    }

    @Override
    protected void CollectAbilities(@Nonnull ItemStack stack, @Nonnull Map<CraftingTraitDefinition, Integer> abilityMap) {
        for (CraftingTraitProviderDefinition provider : this.Def().traits) {
            abilityMap.put(provider.GetAbility(), provider.level);
        }
    }
}

