/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.VecWithOverride;
import com.flansmod.physics.common.util.Maths;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class DefinitionParser {
    private Class<? extends JsonDefinition> classRef;
    private static HashMap<Type, FieldParseMethod> Parsers = new HashMap();

    private static FieldParseMethod GetParserFor(Field field) {
        return DefinitionParser.GetParserFor(field.getType());
    }

    private static FieldParseMethod GetParserFor(Type type) {
        return Parsers.get(type);
    }

    public static void IterativelyCreateParsers(Type type) {
        if (DefinitionParser.GetParserFor(type) != null) {
            return;
        }
        if (type instanceof Class) {
            Class classRef = (Class)type;
            Parsers.put(classRef, null);
            if (classRef.isEnum()) {
                Parsers.put(classRef, new EnumDeserializer(classRef));
            } else if (classRef.isArray()) {
                TypeDescriptor.OfField elementType = classRef.componentType();
                DefinitionParser.IterativelyCreateParsers((Type)((Object)elementType));
                Parsers.put(classRef, new ListDeserializer(DefinitionParser.GetParserFor((Type)((Object)elementType)), (Class)elementType));
            } else {
                Parsers.put(classRef, new ClassDeserializer(classRef));
                for (Field field : classRef.getFields()) {
                    JsonField annotation = field.getAnnotation(JsonField.class);
                    if (annotation == null) continue;
                    DefinitionParser.IterativelyCreateParsers(field.getType());
                }
            }
        }
    }

    public static boolean LoadFromJSON(JsonDefinition definition, JsonElement jRoot) {
        try {
            if (definition == null || jRoot == null || !jRoot.isJsonObject()) {
                return false;
            }
            FieldParseMethod parser = DefinitionParser.GetParserFor(definition.getClass());
            if (parser == null) {
                return false;
            }
            parser.Parse(definition, jRoot, null);
            definition.LoadExtra(jRoot);
            return true;
        }
        catch (Exception e) {
            FlansMod.LOGGER.error("Failed to load " + definition.Location);
            FlansMod.LOGGER.error(e.getMessage());
            return false;
        }
    }

    static {
        Parsers.put(Integer.TYPE, (ref, jNode, annot) -> {
            try {
                return Maths.clamp(jNode.getAsInt(), Maths.ceil(annot.Min()), Maths.floor(annot.Max()));
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as int due to exception: " + e);
                throw e;
            }
        });
        Parsers.put(Float.TYPE, (ref, jNode, annot) -> {
            try {
                return Float.valueOf(Maths.clamp(jNode.getAsFloat(), (float)annot.Min(), (float)annot.Max()));
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as float due to exception: " + e);
                throw e;
            }
        });
        Parsers.put(Double.TYPE, (ref, jNode, annot) -> {
            try {
                return Maths.clamp(jNode.getAsDouble(), annot.Min(), annot.Max());
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as double due to exception: " + e);
                throw e;
            }
        });
        Parsers.put(Short.TYPE, (ref, jNode, annot) -> {
            try {
                return Maths.clamp(jNode.getAsShort(), (short)annot.Min(), (short)annot.Max());
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as short due to exception: " + e);
                throw e;
            }
        });
        Parsers.put(Byte.TYPE, (ref, jNode, annot) -> {
            try {
                return jNode.getAsByte();
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as byte due to exception: " + e);
                throw e;
            }
        });
        Parsers.put(Character.TYPE, (ref, jNode, annot) -> {
            try {
                return Character.valueOf((char)jNode.getAsByte());
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as char due to exception: " + e);
                throw e;
            }
        });
        Parsers.put(Boolean.TYPE, (ref, jNode, annot) -> {
            try {
                return jNode.getAsBoolean();
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as bool due to exception: " + e);
                throw e;
            }
        });
        Parsers.put((Type)((Object)String.class), (ref, jNode, annot) -> {
            try {
                return jNode.getAsString();
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as string due to exception: " + e);
                throw e;
            }
        });
        Parsers.put((Type)((Object)Vec3.class), (ref, jNode, annot) -> {
            try {
                JsonArray jVec = jNode.getAsJsonArray();
                return new Vec3(jVec.get(0).getAsDouble(), jVec.get(1).getAsDouble(), jVec.get(2).getAsDouble());
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as Vec3 due to exception: " + e);
                throw e;
            }
        });
        Parsers.put((Type)((Object)Vector3f.class), (ref, jNode, annot) -> {
            try {
                JsonArray jVec = jNode.getAsJsonArray();
                return new Vector3f(jVec.get(0).getAsFloat(), jVec.get(1).getAsFloat(), jVec.get(2).getAsFloat());
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as Vector3f due to exception: " + e);
                throw e;
            }
        });
        Parsers.put((Type)((Object)VecWithOverride.class), VecWithOverride::ParseFunc);
        Parsers.put((Type)((Object)ResourceLocation.class), (ref, jNode, annot) -> {
            try {
                String resLoc = jNode.getAsString();
                return new ResourceLocation(resLoc);
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as ResourceLocation due to exception: " + e);
                throw e;
            }
        });
    }

    private static interface FieldParseMethod {
        public Object Parse(Object var1, JsonElement var2, JsonField var3) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException;
    }

    public static class EnumDeserializer<TEnum extends Enum<TEnum>>
    implements FieldParseMethod {
        private final Class<TEnum> enumRef;

        public EnumDeserializer(Class<TEnum> ref) {
            this.enumRef = ref;
        }

        @Override
        public Object Parse(Object ref, JsonElement jNode, JsonField annotation) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            try {
                return Enum.valueOf(this.enumRef, jNode.getAsString());
            }
            catch (Exception e1) {
                try {
                    return Enum.valueOf(this.enumRef, jNode.getAsString().toLowerCase());
                }
                catch (Exception e2) {
                    try {
                        return Enum.valueOf(this.enumRef, jNode.getAsString().toUpperCase());
                    }
                    catch (Exception e3) {
                        FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as Enum<" + this.enumRef + "> due to exception: " + e3);
                        throw e3;
                    }
                }
            }
        }
    }

    public static class ListDeserializer
    implements FieldParseMethod {
        private final FieldParseMethod elementParser;
        private final Class elementType;

        public ListDeserializer(FieldParseMethod parser, Class type) {
            this.elementParser = parser;
            this.elementType = type;
        }

        @Override
        public Object Parse(Object ref, JsonElement jNode, JsonField annotation) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            try {
                JsonArray jArray = jNode.getAsJsonArray();
                if (jArray != null) {
                    Object array = Array.newInstance(this.elementType, jArray.size());
                    if (array instanceof Object[]) {
                        Object[] objArray = (Object[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            objArray[index] = this.elementParser.Parse(null, jElement, annotation);
                            ++index;
                        }
                    } else if (array instanceof int[]) {
                        int[] intArray = (int[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            intArray[index] = (Integer)this.elementParser.Parse(null, jElement, annotation);
                            ++index;
                        }
                    } else if (array instanceof float[]) {
                        float[] floatArray = (float[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            floatArray[index] = ((Float)this.elementParser.Parse(null, jElement, annotation)).floatValue();
                            ++index;
                        }
                    } else if (array instanceof double[]) {
                        double[] doubleArray = (double[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            doubleArray[index] = (Double)this.elementParser.Parse(null, jElement, annotation);
                            ++index;
                        }
                    } else if (array instanceof long[]) {
                        long[] longArray = (long[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            longArray[index] = (Long)this.elementParser.Parse(null, jElement, annotation);
                            ++index;
                        }
                    } else if (array instanceof short[]) {
                        short[] shortArray = (short[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            shortArray[index] = (Short)this.elementParser.Parse(null, jElement, annotation);
                            ++index;
                        }
                    } else if (array instanceof byte[]) {
                        byte[] byteArray = (byte[])array;
                        int index = 0;
                        for (JsonElement jElement : jArray) {
                            byteArray[index] = (Byte)this.elementParser.Parse(null, jElement, annotation);
                            ++index;
                        }
                    } else {
                        FlansMod.LOGGER.error("Unknown array type " + array.getClass());
                    }
                    return array;
                }
                return new Object[0];
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as " + this.elementType + "[] due to exception: " + e);
                throw e;
            }
        }
    }

    public static class ClassDeserializer<TClass>
    implements FieldParseMethod {
        private final HashMap<String, Field> memberFields;
        private final Class<? extends TClass> classRef;

        public ClassDeserializer(Class<? extends TClass> cl) {
            this.classRef = cl;
            this.memberFields = new HashMap();
            for (Field field : this.classRef.getFields()) {
                JsonField annotation = field.getAnnotation(JsonField.class);
                if (annotation == null) continue;
                this.memberFields.put(field.getName(), field);
            }
        }

        @Override
        public Object Parse(Object ref, JsonElement jNode, JsonField annotation) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            try {
                if (ref == null) {
                    ref = this.classRef.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                for (Map.Entry kvp : jNode.getAsJsonObject().entrySet()) {
                    FieldParseMethod parser;
                    Field targetField = this.memberFields.get(kvp.getKey());
                    if (targetField == null || (parser = DefinitionParser.GetParserFor(targetField)) == null) continue;
                    Object targetObject = targetField.get(ref);
                    targetObject = parser.Parse(targetObject, (JsonElement)kvp.getValue(), targetField.getAnnotation(JsonField.class));
                    targetField.set(ref, targetObject);
                }
                return ref;
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " into " + ref + " as " + this.classRef + " due to exception: " + e);
                throw e;
            }
        }
    }

    public static class PolymorphicDeserializer<TClass>
    implements FieldParseMethod {
        private final Class<? extends TClass> baseClass;
        private final HashMap<String, ClassDeserializer<? extends TClass>> implementations;
        private final Optional<ClassDeserializer<? extends TClass>> defaultDeserializer;

        public PolymorphicDeserializer(Class<? extends TClass> cl, ClassDeserializer<? extends TClass> deser) {
            this.baseClass = cl;
            this.implementations = new HashMap();
            this.defaultDeserializer = Optional.of(deser);
        }

        public PolymorphicDeserializer(Class<? extends TClass> cl) {
            this.baseClass = cl;
            this.implementations = new HashMap();
            this.defaultDeserializer = Optional.empty();
        }

        public void AddImplementation(String typeName, ClassDeserializer<? extends TClass> implementation) {
            this.implementations.put(typeName, implementation);
        }

        @Override
        public Object Parse(Object ref, JsonElement jNode, JsonField annotation) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            try {
                if (jNode instanceof JsonObject) {
                    JsonObject jObject = (JsonObject)jNode;
                    if (jObject.has("type")) {
                        String type = jObject.get("type").getAsString();
                        if (this.implementations.containsKey(type)) {
                            return this.implementations.get(type).Parse(null, jNode, annotation);
                        }
                        FlansMod.LOGGER.warn("Could not parse polymorphic object as type '" + type + "' is not known.");
                    } else {
                        FlansMod.LOGGER.warn("Polymorphic object lacks a type field.");
                    }
                    if (this.defaultDeserializer.isPresent()) {
                        return this.defaultDeserializer.get().Parse(null, jNode, annotation);
                    }
                    FlansMod.LOGGER.warn("Polymorphic object could not resolve type AND had no valid default");
                } else {
                    FlansMod.LOGGER.warn("Polymorphic object expected a Json Object.");
                }
                return null;
            }
            catch (Exception e) {
                FlansMod.LOGGER.error("Failed to parse JsonNode " + jNode + " as a polymorphism of " + this.baseClass + " due to exception: " + e);
                throw e;
            }
        }
    }

    private static enum FieldType {
        INT,
        DOUBLE,
        FLOAT,
        BYTE,
        SHORT,
        STRING,
        STRUCT,
        LIST;

    }
}

