/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.common.types.DefinitionParser;
import com.flansmod.common.types.JsonDefinition;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.OnDatapackSyncEvent;
import org.slf4j.Logger;

public class Definitions<TDefinitionType extends JsonDefinition>
extends SimpleJsonResourceReloadListener {
    private static final ResourceLocation EMPTY = new ResourceLocation("empty");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = Definitions.createSerializer().create();
    private Map<ResourceLocation, TDefinitionType> keyedDefinitions = ImmutableMap.of();
    private Map<ResourceLocation, TDefinitionType> prefixKeyedDefinitions = ImmutableMap.of();
    private final Map<Integer, TDefinitionType> hashKeyedDefinitions = new HashMap<Integer, TDefinitionType>();
    private final TDefinitionType INVALID;
    private final String FolderName;
    private final Factory<TDefinitionType> createFunc;

    public static GsonBuilder createSerializer() {
        return new GsonBuilder();
    }

    public Definitions(@Nonnull String folderName, @Nonnull Class<? extends TDefinitionType> clazz, @Nonnull TDefinitionType invalid, @Nonnull Factory<TDefinitionType> createFunctor) {
        super(GSON, folderName.toLowerCase());
        this.createFunc = createFunctor;
        this.FolderName = folderName;
        this.INVALID = invalid;
        DefinitionParser.IterativelyCreateParsers(clazz);
    }

    @Nonnull
    public TDefinitionType Get(@Nonnull ResourceLocation location) {
        JsonDefinition def = (JsonDefinition)this.keyedDefinitions.get(location);
        if (def != null) {
            return (TDefinitionType)def;
        }
        return (TDefinitionType)((JsonDefinition)this.prefixKeyedDefinitions.getOrDefault(location, this.INVALID));
    }

    @Nonnull
    public TDefinitionType ByHash(int hash) {
        return (TDefinitionType)((JsonDefinition)this.hashKeyedDefinitions.getOrDefault(hash, this.INVALID));
    }

    public void RunOnMatch(@Nonnull String key, @Nonnull Consumer<TDefinitionType> resultFunction) {
        for (Map.Entry<ResourceLocation, TDefinitionType> kvp : this.keyedDefinitions.entrySet()) {
            if (!kvp.getKey().m_135815_().equals(key)) continue;
            resultFunction.accept((JsonDefinition)kvp.getValue());
        }
    }

    public void RunOnMatches(@Nonnull Function<TDefinitionType, Boolean> matchFunction, @Nonnull Consumer<TDefinitionType> resultFunction) {
        for (Map.Entry<ResourceLocation, TDefinitionType> kvp : this.keyedDefinitions.entrySet()) {
            if (!matchFunction.apply((JsonDefinition)kvp.getValue()).booleanValue()) continue;
            resultFunction.accept((JsonDefinition)kvp.getValue());
        }
    }

    @Nonnull
    public List<TDefinitionType> Find(@Nonnull Function<TDefinitionType, Boolean> matchFunction) {
        ArrayList<JsonDefinition> defs = new ArrayList<JsonDefinition>();
        for (Map.Entry<ResourceLocation, TDefinitionType> kvp : this.keyedDefinitions.entrySet()) {
            if (!matchFunction.apply((JsonDefinition)kvp.getValue()).booleanValue()) continue;
            defs.add((JsonDefinition)kvp.getValue());
        }
        return defs;
    }

    private void onDatapackSync(@Nonnull OnDatapackSyncEvent event) {
    }

    protected void updateDataFromServer(@Nonnull Map<ResourceLocation, TDefinitionType> dataMap) {
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> sources, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller p_79216_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder builderWithPrefix = ImmutableMap.builder();
        JsonElement jsonelement = sources.remove(EMPTY);
        if (jsonelement != null) {
            LOGGER.warn("Datapack tried to redefine {} definition, ignoring", (Object)EMPTY);
        }
        sources.forEach((key, value) -> {
            try {
                Resource res = resourceManager.m_213713_(this.getPreparedPath((ResourceLocation)key)).orElse(null);
                TDefinitionType def = this.createFunc.Create((ResourceLocation)key);
                DefinitionParser.LoadFromJSON(def, value);
                builder.put(key, def);
                builderWithPrefix.put((Object)key.m_246208_(this.FolderName + "/"), def);
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse gun definition {}", value, (Object)exception);
            }
        });
        builder.put((Object)EMPTY, this.INVALID);
        builderWithPrefix.put((Object)EMPTY.m_246208_(this.FolderName + "/"), this.INVALID);
        this.keyedDefinitions = builder.build();
        this.prefixKeyedDefinitions = builderWithPrefix.build();
        for (Map.Entry<ResourceLocation, TDefinitionType> kvp : this.keyedDefinitions.entrySet()) {
            this.hashKeyedDefinitions.put(kvp.getKey().hashCode(), (JsonDefinition)kvp.getValue());
        }
        for (Map.Entry<ResourceLocation, TDefinitionType> kvp : this.prefixKeyedDefinitions.entrySet()) {
            this.hashKeyedDefinitions.put(kvp.getKey().hashCode(), (JsonDefinition)kvp.getValue());
        }
    }

    @Nonnull
    public JsonElement serialize(@Nonnull TDefinitionType def) {
        return GSON.toJsonTree(def);
    }

    @Nonnull
    public Set<ResourceLocation> getIds() {
        return this.keyedDefinitions.keySet();
    }

    public static interface Factory<TDefinitionType extends JsonDefinition> {
        public TDefinitionType Create(@Nonnull ResourceLocation var1);
    }
}

