/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.abilities.elements;

import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.ETriggerConditionType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;

public class TriggerConditionDefinition {
    @JsonField
    public ETriggerConditionType conditionType = ETriggerConditionType.CheckActionGroupPath;
    @JsonField
    public String[] allowedValues = new String[0];

    public boolean Matches(@Nonnull TriggerContext triggerContext) {
        switch (this.conditionType) {
            case CheckActionGroupPath: {
                return this.IsAllowed(triggerContext.ActionGroupPath);
            }
            case CheckOwnerEntityType: {
                return this.IsAllowed(triggerContext.Owner);
            }
            case CheckShooterEntityType: {
                return this.IsAllowed(triggerContext.Shooter);
            }
        }
        return false;
    }

    private boolean IsAllowed(@Nullable Entity check) {
        if (check == null) {
            return this.allowedValues.length == 0;
        }
        for (String allowed : this.allowedValues) {
            TagKey entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(allowed));
            if (!check.m_6095_().m_204039_(entityTag)) continue;
            return true;
        }
        return false;
    }

    private boolean IsAllowed(@Nullable String check) {
        if (check == null) {
            return this.allowedValues.length == 0;
        }
        for (String allowed : this.allowedValues) {
            if (!allowed.equals(check)) continue;
            return true;
        }
        return false;
    }
}

