/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.attachments;

import com.flansmod.common.actions.contexts.GunInputContext;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.CraftingTraitProviderDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.common.types.attachments.EMechaEffect;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.common.types.elements.ItemDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.guns.elements.ActionGroupDefinition;
import com.flansmod.common.types.guns.elements.ERepeatMode;
import com.flansmod.common.types.guns.elements.HandlerDefinition;
import com.flansmod.common.types.guns.elements.ReloadDefinition;
import net.minecraft.resources.ResourceLocation;

public class AttachmentDefinition
extends JsonDefinition {
    public static final AttachmentDefinition INVALID = new AttachmentDefinition(new ResourceLocation("flansmod", "attachments/null"));
    public static final String TYPE = "attachment";
    public static final String FOLDER = "attachments";
    @JsonField
    public ItemDefinition itemSettings = new ItemDefinition();
    @JsonField
    public EAttachmentType attachmentType = EAttachmentType.Generic;
    @JsonField
    public ModifierDefinition[] modifiers = new ModifierDefinition[0];
    @JsonField
    public EMechaEffect[] mechaEffects = new EMechaEffect[0];
    @JsonField
    public String mechaEffectFilter = "";
    @JsonField
    public HandlerDefinition[] handlerOverrides = new HandlerDefinition[0];
    @JsonField
    public ActionGroupDefinition[] actionOverrides = new ActionGroupDefinition[0];
    @JsonField
    public ReloadDefinition[] reloadOverrides = new ReloadDefinition[0];
    @JsonField
    public CraftingTraitProviderDefinition[] abilities = new CraftingTraitProviderDefinition[0];
    @JsonField
    public ERepeatMode modeOverride = ERepeatMode.FullAuto;
    @JsonField
    public boolean overrideFireMode = false;

    @Override
    public String GetTypeName() {
        return TYPE;
    }

    public AttachmentDefinition(ResourceLocation resLoc) {
        super(resLoc);
    }

    public ActionGroupDefinition GetActionGroup(String key) {
        for (ActionGroupDefinition group : this.actionOverrides) {
            if (!group.key.equals(key)) continue;
            return group;
        }
        return ActionGroupDefinition.INVALID;
    }

    public HandlerDefinition GetInputHandler(EPlayerInput inputType) {
        for (HandlerDefinition handler : this.handlerOverrides) {
            if (handler.inputType != inputType) continue;
            return handler;
        }
        return HandlerDefinition.INVALID;
    }

    public HandlerDefinition GetInputHandler(GunInputContext inputContext) {
        for (HandlerDefinition handler : this.handlerOverrides) {
            if (handler.inputType != inputContext.InputType) continue;
            return handler;
        }
        return HandlerDefinition.INVALID;
    }
}

