/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.bullets.elements;

import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.projectiles.BulletGuidance;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.bullets.elements.EProjectileResponseType;
import com.flansmod.common.types.bullets.elements.ImpactDefinition;
import com.flansmod.common.types.bullets.elements.TrailDefinition;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileDefinition {
    @JsonField(ModifiedBy="shot_count", Docs="Number of bullet entities to create", Min=0.0, Max=128.0)
    public int shotCount = 1;
    @JsonField(ModifiedBy="splash_radius", Docs="The radius within which to apply splash effects. If 0, any Impacts on splash won't trigger")
    public float splashRadius = 0.0f;
    @JsonField(Docs="Impact settings. You probably want at least a ShotPosition, or ShotEntity and ShotBlock")
    public ImpactDefinition[] impacts = new ImpactDefinition[0];
    @JsonField(ModifiedBy="launch_speed", Docs="The speed (blocks/s) with which this projectile leaves the gun")
    public float launchSpeed = 3.0f;
    @JsonField(ModifiedBy="acceleration", Docs="Acceleration of the projectile in blocks/s per tick")
    public float acceleration = 0.0f;
    @JsonField(ModifiedBy="max_speed", Docs="The maximum linear speed of the projectile")
    public float maxSpeed = 3.0f;
    @JsonField(ModifiedBy="gravity_factor", Docs="How much does gravity affect this? 0=Not at all, 1=Regular")
    public float gravityFactor = 1.0f;
    @JsonField(ModifiedBy="response_to_block")
    public EProjectileResponseType responseToBlock = EProjectileResponseType.Bounce;
    @JsonField(ModifiedBy="response_to_entity")
    public EProjectileResponseType responseToEntity = EProjectileResponseType.Detonate;
    @JsonField(ModifiedBy="response_to_vehicle")
    public EProjectileResponseType responseToVehicle = EProjectileResponseType.Detonate;
    @JsonField(ModifiedBy="fuse_time", Docs="If set to a non-zero amount, this projectile will have a fuse timer, in seconds")
    public float fuseTime = 0.0f;
    @JsonField(ModifiedBy="guidance_type", Docs="The guidance mode of the projectile. none/beam_riding/lock_on/lock_on_proportional")
    public String guidanceType = "none";
    @JsonField(ModifiedBy="lock_range", Docs="The size of the cone in which the projectile can lock onto a new target")
    public float lockRange = 128.0f;
    @JsonField(ModifiedBy="lock_cone", Docs="The size of the cone in which the projectile can lock onto a new target")
    public float lockCone = 15.0f;
    @JsonField(ModifiedBy="track_cone", Docs="The size of the cone in which the projectile can track a locked-on target")
    public float trackCone = 70.0f;
    @JsonField(ModifiedBy="track_cone", Docs="The size of the cone in which the projectile can track a locked-on target")
    public float lockTime = 20.0f;
    @JsonField(ModifiedBy="turn_rate", Docs="How quickly a projectile rotates to face the direction of travel")
    public float turnRate = 0.1f;
    @JsonField(Docs="Altitude gained above target during top attack mode")
    public float topAttackHeight = 10.0f;
    @JsonField(Docs="Lateral distance where missile will directly track target during top attack mode")
    public float topAttackRange = 10.0f;
    @JsonField(Docs="What types of entity this can target")
    public String[] targetTypes = new String[0];
    @JsonField(ModifiedBy="drag_in_air", Docs="Percent speed loss per tick (1/20s)")
    public float dragInAir = 0.01f;
    @JsonField(ModifiedBy="drag_in_water", Docs="Percent speed loss per tick (1/20s)")
    public float dragInWater = 0.2f;
    @JsonField(ModifiedBy="particles_in_air")
    public String airParticles = "";
    @JsonField(ModifiedBy="particles_in_water")
    public String waterParticles = "";
    @JsonField(ModifiedBy="time_between_particles")
    public float timeBetweenTrailParticles = 0.25f;
    @JsonField
    public TrailDefinition[] particleTrails = new TrailDefinition[0];

    public boolean HasSplash() {
        return this.splashRadius > 0.0f;
    }

    public BulletGuidance.GuidanceType GetGuidanceMode() {
        return BulletGuidance.GuidanceType(this.guidanceType);
    }

    public boolean HasLockOn() {
        return BulletGuidance.HasLockOn(this.guidanceType);
    }

    public ArrayList<Class> Targets() {
        ArrayList<Class> result = new ArrayList<Class>();
        String[] stringArray = this.targetTypes;
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "flyingMob": {
                    result.add(FlyingMob.class);
                    result.add(EnderDragon.class);
                    result.add(WitherBoss.class);
                    result.add(Blaze.class);
                    continue block14;
                }
                case "monster": {
                    result.add(Monster.class);
                    result.add(Raider.class);
                    continue block14;
                }
                case "vehicle": {
                    result.add(VehicleEntity.class);
                    continue block14;
                }
                case "player": {
                    result.add(Player.class);
                    continue block14;
                }
                case "living": {
                    result.add(LivingEntity.class);
                    continue block14;
                }
                default: {
                    EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(s));
                    if (entity == null) continue block14;
                    result.add(entity.m_142225_());
                }
            }
        }
        return result;
    }
}

